/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.ui.PessimisticProviderAction;

public class AddToControlAction
extends PessimisticProviderAction {
    public void run(IAction action) {
        IResource[] resources = this.getSelectedResources();
        if (resources == null || resources.length == 0) {
            return;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            while (resource.getType() != 4 && !this.isControlled(resource)) {
                resourceSet.add(resource);
                resource = resource.getParent();
            }
            ++i;
        }
        if (!resourceSet.isEmpty()) {
            final Map byProject = this.sortByProject(resourceSet);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    for (IProject project : byProject.keySet()) {
                        PessimisticFilesystemProvider provider = AddToControlAction.this.getProvider((IResource)project);
                        if (provider == null) continue;
                        Set set = (Set)byProject.get(project);
                        IResource[] resources = new IResource[set.size()];
                        set.toArray(resources);
                        provider.addToControl(resources, monitor);
                    }
                }
            };
            this.runWithProgressDialog(runnable);
        }
    }

    @Override
    protected boolean shouldEnableFor(IResource resource) {
        if (resource == null) {
            return false;
        }
        if ((resource.getType() & 0xC) != 0) {
            return false;
        }
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return !provider.isControlled(resource);
    }
}

