/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ui.PessimisticProviderAction;

public class DisconnectAction
extends PessimisticProviderAction {
    public void run(IAction action) {
        IResource[] resources;
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Disconnect");
        }
        if ((resources = this.getSelectedResources()) == null || resources.length == 0) {
            return;
        }
        final HashSet<IProject> projects = new HashSet<IProject>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 4) {
                projects.add(resource.getProject());
            }
            ++i;
        }
        if (!projects.isEmpty()) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            for (IProject project : projects) {
                                PessimisticFilesystemProvider provider = DisconnectAction.this.getProvider((IResource)project);
                                if (provider == null) continue;
                                try {
                                    RepositoryProvider.unmap((IProject)project);
                                }
                                catch (TeamException e) {
                                    PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Could not unmap " + project);
                                }
                            }
                        }
                    };
                    try {
                        ResourcesPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problem during unmap runnable");
                    }
                }
            };
            this.runWithProgressDialog(runnable);
        }
    }

    @Override
    protected boolean shouldEnableFor(IResource resource) {
        if (resource.getType() == 4) {
            PessimisticFilesystemProvider provider = this.getProvider(resource);
            return provider != null;
        }
        return false;
    }
}

