/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.mapping;

import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.core.mapping.ResourceMappingScope;
import org.eclipse.team.tests.core.TeamTest;
import org.eclipse.team.ui.synchronize.ModelOperation;

public class ScopeBuildingTests
extends TeamTest {
    private static final RuntimeException PROMPT_EXCEPTION = new RuntimeException();
    protected static final String TEST_MODEL_PROVIDER_ID = "id1";

    public static Test suite() {
        return ScopeBuildingTests.suite(ScopeBuildingTests.class);
    }

    public ScopeBuildingTests() {
    }

    public ScopeBuildingTests(String name) {
        super(name);
    }

    private void expectPrompt(TestResourceMappingOperation op) {
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            ScopeBuildingTests.fail((String)("Unexpected exception: " + e.getTargetException().getMessage()));
        }
        catch (InterruptedException interruptedException) {
            ScopeBuildingTests.fail((String)"Unexpected interupt");
        }
        catch (RuntimeException e) {
            if (e == PROMPT_EXCEPTION) {
                return;
            }
            throw e;
        }
        ScopeBuildingTests.fail((String)"Expected prompt did not occur");
    }

    private ResourceMapping getMapping(final IProject project, final IResource[] resources, final int depth) {
        return new ResourceMapping(){

            public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                return new ResourceTraversal[]{new ResourceTraversal(resources, depth, 0)};
            }

            public IProject[] getProjects() {
                return new IProject[]{project};
            }

            public Object getModelObject() {
                return new Object();
            }

            public String getModelProviderId() {
                return ScopeBuildingTests.TEST_MODEL_PROVIDER_ID;
            }

            public boolean contains(ResourceMapping mapping) {
                return false;
            }
        };
    }

    public void testAdditionalResources() throws CoreException {
        IProject project = this.createProject(new String[]{"file.txt", "folder1/file2.txt", "folder1/folder2/file3.txt", "folder3/"});
        ResourceMapping[] mappings = new ResourceMapping[]{this.getMapping(project, new IResource[]{project.getFolder("folder1")}, 2)};
        ResourceMapping[] additionalMappings = new ResourceMapping[]{this.getMapping(project, new IResource[]{project.getFile("file.txt")}, 2)};
        TestResourceMappingOperation op = new TestResourceMappingOperation(mappings, additionalMappings);
        this.expectPrompt(op);
    }

    private class TestResourceMappingOperation
    extends ModelOperation {
        protected TestResourceMappingOperation(ResourceMapping[] selectedMappings, final ResourceMapping[] additionalMappings) {
            super(null, (ISynchronizationScopeManager)new SynchronizationScopeManager("", selectedMappings, ResourceMappingContext.LOCAL_CONTEXT, false){

                public void initialize(IProgressMonitor monitor) throws CoreException {
                    super.initialize(monitor);
                    int i = 0;
                    while (i < additionalMappings.length) {
                        ResourceMapping mapping = additionalMappings[i];
                        ResourceTraversal[] traversals = mapping.getTraversals(this.getContext(), monitor);
                        ((ResourceMappingScope)this.getScope()).addMapping(mapping, traversals);
                        ++i;
                    }
                }
            });
        }

        protected void endOperation(IProgressMonitor monitor) throws InvocationTargetException {
            ISynchronizationScopeManager manager = this.getScopeManager();
            manager.dispose();
            super.endOperation(monitor);
        }

        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }
    }
}

