/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.tests.ReflectionUtils;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.team.tests.core.TeamTest;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SaveableCompareEditorInputTest
extends TeamTest {
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private IFile file1;
    private IFile file2;
    private String appendFileContents = "_append";
    private String fileContents1 = "FileContents";
    private String fileContents2 = "FileContents2";
    private TestLogListener logListener = new TestLogListener();
    private IProject project;

    public static Test suite() {
        return SaveableCompareEditorInputTest.suite(SaveableCompareEditorInputTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject("Project_", new String[]{"File1.txt", "File2.txt"});
        this.file1 = this.project.getFile("File1.txt");
        this.file2 = this.project.getFile("File2.txt");
        this.file1.setContents((InputStream)new ByteArrayInputStream(this.fileContents1.getBytes()), true, true, null);
        this.file2.setContents((InputStream)new ByteArrayInputStream(this.fileContents2.getBytes()), true, true, null);
        RuntimeLog.addLogListener((ILogListener)this.logListener);
    }

    protected void tearDown() throws Exception {
        RuntimeLog.removeLogListener((ILogListener)this.logListener);
        super.tearDown();
    }

    private void verifyDirtyStateChanges(TestSaveableEditorInput compareEditorInput) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TextMergeViewer viewer = (TextMergeViewer)compareEditorInput.findContentViewer(null, compareEditorInput.input, (Composite)shell);
        viewer.setInput(compareEditorInput.getCompareResult());
        MergeSourceViewer left = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fLeft");
        StyledText leftText = left.getSourceViewer().getTextWidget();
        leftText.append(this.appendFileContents);
        SaveableCompareEditorInputTest.assertTrue((boolean)compareEditorInput.isDirty());
        viewer.flush(null);
        SaveableCompareEditorInputTest.assertFalse((boolean)compareEditorInput.isDirty());
    }

    public void testDirtyFlagOnLocalResourceTypedElement() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        LocalResourceTypedElement el1 = (LocalResourceTypedElement)SaveableCompareEditorInput.createFileElement((IFile)this.file1);
        TestFileElement el2 = new TestFileElement(this.file2);
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput((ITypedElement)el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
        SaveableCompareEditorInputTest.assertTrue((boolean)this.compareContent(new ByteArrayInputStream((String.valueOf(this.fileContents1) + this.appendFileContents).getBytes()), this.file1.getContents()));
    }

    public void testDirtyFlagOnCustomTypedElement() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        TestFileElement el1 = new TestFileElement(this.file1);
        TestFileElement el2 = new TestFileElement(this.file2);
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput(el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
    }

    public void testDirtyFlagOnLocalResourceTypedElementAndEmptyRight() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        LocalResourceTypedElement el1 = (LocalResourceTypedElement)SaveableCompareEditorInput.createFileElement((IFile)this.file1);
        ITypedElement el2 = null;
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput((ITypedElement)el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
        SaveableCompareEditorInputTest.assertTrue((boolean)this.compareContent(new ByteArrayInputStream((String.valueOf(this.fileContents1) + this.appendFileContents).getBytes()), this.file1.getContents()));
    }

    public void testDirtyFlagOnCustomTypedElementAndEmptyRight() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        TestFileElement el1 = new TestFileElement(this.file1);
        ITypedElement el2 = null;
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput(el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
    }

    private void verifyModifyAndSaveBothSidesOfCompareEditor(String extention) throws InterruptedException, InvocationTargetException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, CoreException {
        IFile file1 = this.project.getFile("CompareFile1." + extention);
        IFile file2 = this.project.getFile("CompareFile2." + extention);
        file1.create((InputStream)new ByteArrayInputStream(this.fileContents1.getBytes()), true, null);
        file2.create((InputStream)new ByteArrayInputStream(this.fileContents2.getBytes()), true, null);
        SaveablesCompareEditorInput input = new SaveablesCompareEditorInput(null, SaveablesCompareEditorInput.createFileElement((IFile)file1), SaveablesCompareEditorInput.createFileElement((IFile)file2), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        input.run(null);
        CompareEditor editor = (CompareEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, COMPARE_EDITOR, true);
        CompareViewerSwitchingPane pane = (CompareViewerSwitchingPane)ReflectionUtils.getField((Object)input, (String)"fContentInputPane", (boolean)true);
        Viewer viewer = pane.getViewer();
        MergeSourceViewer left = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fLeft", (boolean)true);
        MergeSourceViewer right = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fRight", (boolean)true);
        StyledText leftText = left.getSourceViewer().getTextWidget();
        StyledText rightText = right.getSourceViewer().getTextWidget();
        leftText.append(this.appendFileContents);
        rightText.append(this.appendFileContents);
        editor.doSave(null);
        SaveableCompareEditorInputTest.assertFalse((boolean)editor.isDirty());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
        SaveableCompareEditorInputTest.assertTrue((boolean)this.compareContent(new ByteArrayInputStream((String.valueOf(this.fileContents1) + this.appendFileContents).getBytes()), file1.getContents()));
        SaveableCompareEditorInputTest.assertTrue((boolean)this.compareContent(new ByteArrayInputStream((String.valueOf(this.fileContents2) + this.appendFileContents).getBytes()), file2.getContents()));
    }

    public void testModifyAndSaveBothSidesOfCompareEditorHtml() throws IllegalArgumentException, SecurityException, InterruptedException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, CoreException {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("html");
    }

    public void testModifyAndSaveBothSidesOfCompareEditorTxt() throws IllegalArgumentException, SecurityException, InterruptedException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, CoreException {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("txt");
    }

    public void testModifyAndSaveBothSidesOfCompareEditorJava() throws IllegalArgumentException, SecurityException, InterruptedException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, CoreException {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("java");
    }

    public void testModifyAndSaveBothSidesOfCompareEditorXml() throws IllegalArgumentException, SecurityException, InterruptedException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, CoreException {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("xml");
    }

    public void testModifyAndSaveBothSidesOfCompareEditorProperties() throws IllegalArgumentException, SecurityException, InterruptedException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, CoreException {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("properties");
    }

    private class TestDiffNode
    extends AbstractCompareInput {
        private CompareInputChangeNotifier notifier;

        public TestDiffNode(ITypedElement left, ITypedElement right) {
            super(3, null, left, right);
            this.notifier = new CompareInputChangeNotifier(){

                private IResource getResource(ITypedElement el) {
                    if (el instanceof LocalResourceTypedElement) {
                        return ((LocalResourceTypedElement)el).getResource();
                    }
                    if (el instanceof TestFileElement) {
                        return ((TestFileElement)el).getFile();
                    }
                    return null;
                }

                protected IResource[] getResources(ICompareInput input) {
                    ArrayList<IResource> resources = new ArrayList<IResource>();
                    if (this.getResource(TestDiffNode.this.getLeft()) != null) {
                        resources.add(this.getResource(TestDiffNode.this.getLeft()));
                    }
                    if (this.getResource(TestDiffNode.this.getRight()) != null) {
                        resources.add(this.getResource(TestDiffNode.this.getRight()));
                    }
                    return resources.toArray(new IResource[2]);
                }
            };
        }

        public void fireChange() {
            super.fireChange();
        }

        protected CompareInputChangeNotifier getChangeNotifier() {
            return this.notifier;
        }

        public boolean needsUpdate() {
            return false;
        }

        public void update() {
            this.fireChange();
        }
    }

    private class TestFileElement
    implements ITypedElement {
        private IFile file;

        public IFile getFile() {
            return this.file;
        }

        public TestFileElement(IFile file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getName();
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }
    }

    private class TestLogListener
    implements ILogListener {
        private TestLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            if (status.getSeverity() == 4) {
                SaveableCompareEditorInputTest.fail((String)status.toString());
            }
        }
    }

    private class TestSaveableEditorInput
    extends SaveableCompareEditorInput {
        protected ITypedElement left;
        protected ITypedElement right;
        private ICompareInput input;

        public Object getCompareResult() {
            return this.input;
        }

        public TestSaveableEditorInput(ITypedElement left, ITypedElement right, CompareConfiguration conf) {
            super(conf, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
            this.left = left;
            this.right = right;
        }

        protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.input = this.createCompareInput();
            this.getCompareConfiguration().setLeftEditable(true);
            this.getCompareConfiguration().setRightEditable(false);
            return null;
        }

        private ICompareInput createCompareInput() {
            return new TestDiffNode(this.left, this.right);
        }

        protected void fireInputChange() {
            ((TestDiffNode)((Object)this.getCompareResult())).fireChange();
        }
    }
}

