/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;

public class CVSTestLogListener
implements ILogListener {
    Map<String, List<IStatus>> errors = new HashMap<String, List<IStatus>>();

    public void logging(IStatus status, String plugin) {
        List<IStatus> pluginErrors = this.errors.get(plugin);
        if (pluginErrors == null) {
            pluginErrors = new ArrayList<IStatus>();
            this.errors.put(plugin, pluginErrors);
        }
        pluginErrors.add(status);
    }

    public void checkErrors() throws CoreException {
        if (this.errors.isEmpty()) {
            return;
        }
        ArrayList<IStatus> allErrors = new ArrayList<IStatus>();
        for (List<IStatus> pluginErrors : this.errors.values()) {
            allErrors.addAll(pluginErrors);
        }
        this.errors.clear();
        if (allErrors.isEmpty()) {
            return;
        }
        IStatus status = null;
        if (allErrors.size() == 1 && !(status = (IStatus)allErrors.get(0)).isMultiStatus()) {
            throw new CVSException(status);
        }
        if (status == null) {
            status = new MultiStatus("org.eclipse.team.tests.cvs.core", 0, allErrors.toArray(new IStatus[allErrors.size()]), "Errors were logged during this test. Check the log file for details", null);
        }
        throw new CoreException(status);
    }
}

