/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.tests.ccvs.core.CVSClientException;
import org.eclipse.team.tests.ccvs.core.ICVSClient;
import org.junit.Assert;

public class EclipseCVSClient
implements ICVSClient {
    public static final ICVSClient INSTANCE = new EclipseCVSClient();
    private static final HashMap<String, Command> commandPool = new HashMap();

    static {
        commandPool.put("update", (Command)Command.UPDATE);
        commandPool.put("co", (Command)Command.CHECKOUT);
        commandPool.put("ci", (Command)Command.COMMIT);
        commandPool.put("import", (Command)Command.IMPORT);
        commandPool.put("add", (Command)Command.ADD);
        commandPool.put("remove", (Command)Command.REMOVE);
        commandPool.put("status", (Command)Command.STATUS);
        commandPool.put("log", (Command)Command.LOG);
        commandPool.put("tag", (Command)Command.TAG);
        commandPool.put("rtag", (Command)Command.RTAG);
        commandPool.put("admin", (Command)Command.ADMIN);
        commandPool.put("diff", (Command)Command.DIFF);
    }

    @Override
    public void executeCommand(ICVSRepositoryLocation repositoryLocation, IContainer localRoot, String command, String[] globalOptions, String[] localOptions, String[] arguments) throws CVSException {
        EclipseCVSClient.execute(repositoryLocation, CVSWorkspaceRoot.getCVSFolderFor((IContainer)localRoot), command, globalOptions, localOptions, arguments);
    }

    public static void execute(ICVSRepositoryLocation cvsRepositoryLocation, ICVSFolder cvsLocalRoot, String command, String[] globalOptions, String[] localOptions, String[] arguments) throws CVSException {
        Assert.assertNotNull((Object)cvsRepositoryLocation);
        Assert.assertNotNull((Object)cvsLocalRoot);
        Assert.assertNotNull((Object)command);
        Assert.assertNotNull((Object)globalOptions);
        Assert.assertNotNull((Object)localOptions);
        Assert.assertNotNull((Object)arguments);
        Assert.assertTrue((boolean)cvsLocalRoot.exists());
        Command cvsCommand = commandPool.get(command);
        ArrayList<CustomGlobalOption> globals = new ArrayList<CustomGlobalOption>();
        int i = 0;
        while (i < globalOptions.length) {
            globals.add(new CustomGlobalOption(globalOptions[i]));
            ++i;
        }
        Command.GlobalOption[] cvsGlobalOptions = globals.toArray(new Command.GlobalOption[globals.size()]);
        ArrayList<CustomLocalOption> locals = new ArrayList<CustomLocalOption>();
        int i2 = 0;
        while (i2 < localOptions.length) {
            String option = localOptions[i2];
            String argument = null;
            if (i2 < localOptions.length - 1 && localOptions[i2 + 1].charAt(0) != '-') {
                argument = localOptions[++i2];
            }
            locals.add(new CustomLocalOption(option, argument));
            ++i2;
        }
        Command.LocalOption[] cvsLocalOptions = locals.toArray(new Command.LocalOption[locals.size()]);
        NullProgressMonitor monitor = new NullProgressMonitor();
        Session session = new Session(cvsRepositoryLocation, cvsLocalRoot);
        try {
            session.open((IProgressMonitor)monitor, true);
            IStatus status = cvsCommand.execute(session, cvsGlobalOptions, cvsLocalOptions, arguments, null, (IProgressMonitor)monitor);
            if (status.getCode() == -10) {
                throw new CVSClientException("Eclipse client returned non-ok status: " + status);
            }
        }
        finally {
            session.close();
            monitor.done();
        }
    }

    private static class CustomGlobalOption
    extends Command.GlobalOption {
        public CustomGlobalOption(String option) {
            super(option);
        }
    }

    private static class CustomLocalOption
    extends Command.LocalOption {
        public CustomLocalOption(String option, String arg) {
            super(option, arg);
        }
    }
}

