/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.ui.IWorkbenchPart;

public class FindCommittersTest
extends EclipseTest {
    public FindCommittersTest() {
    }

    public FindCommittersTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FindCommittersTest.class);
    }

    public void testFetchLogs() throws CVSException, InvocationTargetException, InterruptedException {
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:anonymous@dev.eclipse.org:/cvsroot/eclipse");
        ICVSRemoteResource[] members = location.members(null, false, DEFAULT_MONITOR);
        Set<String> authors = this.fetchLogs(members);
        for (String name : authors) {
            System.out.println(name);
        }
    }

    private Set<String> fetchLogs(ICVSRemoteResource[] members) throws InvocationTargetException, InterruptedException {
        CVSTag tag1 = new CVSTag(new GregorianCalendar(2001, 10, 7).getTime());
        CVSTag tag2 = new CVSTag(new Date());
        RemoteLogOperation.LogEntryCache logEntryCache = new RemoteLogOperation.LogEntryCache();
        FindCommittersOperation op = new FindCommittersOperation(null, members, tag1, tag2, logEntryCache);
        op.run(DEFAULT_MONITOR);
        return op.getAuthors();
    }

    public class FindCommittersOperation
    extends RemoteLogOperation {
        private RemoteLogOperation.LogEntryCache cache;
        private Set<String> authors;

        public FindCommittersOperation(IWorkbenchPart part, ICVSRemoteResource[] remoteResources, CVSTag tag1, CVSTag tag2, RemoteLogOperation.LogEntryCache cache) {
            super(part, remoteResources, tag1, tag2, cache);
            this.cache = cache;
        }

        protected Command.LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
            return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.REVISIONS_ON_DEFAULT_BRANCH, new Command.LocalOption("-d" + tag1.asDate() + "<" + tag2.asDate().toString(), null){}};
        }

        protected void execute(ICVSRepositoryLocation location, ICVSRemoteResource[] remoteResources, IProgressMonitor monitor) throws CVSException {
            super.execute(location, remoteResources, monitor);
            this.processAuthors();
        }

        private void processAuthors() {
            this.authors = this.getAuthors(this.cache);
        }

        private Set<String> getAuthors(RemoteLogOperation.LogEntryCache logEntryCache) {
            String[] paths = logEntryCache.getCachedFilePaths();
            HashSet<String> authors = new HashSet<String>();
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                ILogEntry[] entries = logEntryCache.getLogEntries(path);
                int j = 0;
                while (j < entries.length) {
                    ILogEntry entry = entries[j];
                    authors.add(entry.getAuthor());
                    ++j;
                }
                ++i;
            }
            return authors;
        }

        public Set<String> getAuthors() {
            return this.authors;
        }
    }
}

