/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.compatible;

import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.team.tests.ccvs.core.JUnitTestCase;
import org.eclipse.team.tests.ccvs.core.compatible.CompatibleTestSetup;
import org.eclipse.team.tests.ccvs.core.compatible.SameResultEnv;

public class BasicTest
extends JUnitTestCase {
    SameResultEnv env1;
    SameResultEnv env2;

    public BasicTest(String arg) {
        super(arg);
        this.env1 = new SameResultEnv(String.valueOf(arg) + "-checkout1");
        this.env2 = new SameResultEnv(String.valueOf(arg) + "-checkout2");
    }

    public BasicTest() {
        this("BasicTest");
    }

    public static void main(String[] args) {
        BasicTest.run(BasicTest.class);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BasicTest.class);
        return new CompatibleTestSetup((Test)suite);
    }

    public void setUp() throws Exception {
        this.env1.setUp();
        this.env2.setUp();
        this.env1.magicSetUpRepo("proj2", new String[]{"a.txt", "f1/b.txt", "f1/c.txt"});
        this.env2.deleteFile("proj2");
    }

    public void tearDown() throws Exception {
        this.env1.tearDown();
        this.env2.tearDown();
    }

    public void testAdd() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.writeToFile("proj2/d.txt", new String[]{"The file to be added", "next"});
        this.env1.mkdirs("proj2/f2/f3");
        this.env1.mkdirs("proj2/f4/f5");
        this.env1.writeToFile("proj2/f4/f5/e.txt", new String[]{"Another file to be added", "next"});
        this.env1.execute("add", EMPTY_ARGS, new String[]{"d.txt"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f2", "f2/f3"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4/f5"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4/f5/e.txt"}, "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"});
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"});
    }

    public void testAddUpdate() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.writeToFile("proj2/d.txt", new String[]{"The file to be added", "next"});
        this.env1.mkdirs("proj2/f2/f3");
        this.env1.mkdirs("proj2/f4/f5");
        this.env1.writeToFile("proj2/f4/f5/e.txt", new String[]{"Another file to be added", "next"});
        this.env1.execute("add", EMPTY_ARGS, new String[]{"d.txt"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f2", "f2/f3"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4/f5"}, "proj2");
        this.env1.execute("add", EMPTY_ARGS, new String[]{"f4/f5/e.txt"}, "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"});
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"});
    }

    public void testRemove() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.execute("remove", EMPTY_ARGS, new String[]{"a.txt"}, "proj2");
        this.env1.execute("remove", EMPTY_ARGS, new String[]{"f1/c.txt"}, "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"});
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"});
    }

    public void testRemoveRecusive() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.execute("remove", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"});
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"});
    }

    public void testRoundRewrite() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt"});
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"}, "");
    }

    public void testUpdateMinusN() throws Exception {
        String[] fileContent1 = new String[]{"RandomNumber", String.valueOf(Math.random())};
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.writeToFile("proj1/folder1/c.txt", fileContent1);
        this.env1.execute("ci", new String[]{"-n"}, new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"});
    }

    public void testStatus() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("status", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("status", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("status", EMPTY_ARGS, new String[0], "proj2");
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.execute("status", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("status", EMPTY_ARGS, new String[]{"f1/b.txt"}, "proj2");
    }

    public void testLog() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("log", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("log", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("log", EMPTY_ARGS, new String[0], "proj2");
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.execute("log", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("log", EMPTY_ARGS, new String[]{"f1/b.txt"}, "proj2");
    }

    public void testBranchTag() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("tag", new String[]{"-b"}, new String[]{"tag1", "proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("tag", new String[]{"-b"}, new String[]{"tag2", "proj2"});
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "tag1"}, new String[]{"proj2"});
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendItTwo"});
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.execute("add", new String[0], new String[]{"d.txt"}, "proj2");
        this.env1.execute("ci", new String[]{"-m", "branch"}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "tag1"}, new String[]{"proj2"});
        this.env2.execute("co", new String[]{"-r", "tag2"}, new String[]{"proj2"});
        this.env2.appendToFile("proj2/f1/b.txt", new String[]{"AppendItThree"});
        this.env2.createRandomFile("proj2/d.txt");
        this.env2.execute("add", new String[0], new String[]{"d.txt"}, "proj2");
        this.env2.execute("ci", new String[]{"-m", "branch"}, new String[]{"proj2"});
        this.env2.deleteFile("proj2");
        this.env2.execute("co", new String[]{"-r", "tag2"}, new String[]{"proj2"});
    }

    public void testBranchingWithLocalChanges() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        JUnitTestCase.waitMsec(1500);
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("tag", new String[]{"-b"}, new String[]{"branch-with-changes", "proj2"});
        this.env1.execute("update", new String[]{"-r", "branch-with-changes"}, new String[]{"proj2"});
    }

    public void testTag() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag1", "proj2"});
        this.env1.deleteFile("proj2/a.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag2", "proj2"});
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag2"}, "proj2");
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag3"}, "proj2");
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag3", "f1/b.txt"}, "proj2");
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "tag1"}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "tag2"}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "tag3"}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-r", "tag1"}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-r", "tag2"}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-r", "tag3"}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-A"}, new String[]{"proj2"});
    }

    public void testRTag() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("tag", EMPTY_ARGS, new String[]{"tag1", "proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("rtag", new String[]{"-r", "tag1"}, new String[]{"rtag1", "proj2"});
        this.env1.execute("rtag", new String[]{"-b", "-r", "tag1"}, new String[]{"btag1", "proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "rtag1"}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-r", "btag1"}, new String[]{"proj2"});
    }

    public void testPrune() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.deleteFile("proj2/f1/b.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.execute("remove", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env1.execute("update", new String[]{"-P"}, new String[]{"proj2"}, "");
        this.env2.execute("update", new String[]{"-P"}, new String[]{"proj2"}, "");
    }

    public void testPrune2() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.deleteFile("proj2/f1/b.txt");
        this.env1.deleteFile("proj2/f1/c.txt");
        this.env1.execute("remove", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env1.execute("update", new String[]{"-P"}, new String[0], "proj2");
        this.env2.execute("update", new String[]{"-P"}, new String[0], "proj2");
    }

    public void testAdmin() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.execute("admin", new String[]{"-kb"}, new String[]{"proj2/f1/b.txt"}, "");
        this.env1.execute("update", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
    }

    public void testDiff() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("diff", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.setIgnoreExceptions(true);
        this.env1.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt2"});
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt"});
        this.env1.execute("diff", EMPTY_ARGS, new String[]{"proj2"});
        this.env1.execute("diff", EMPTY_ARGS, new String[0], "proj2");
        this.env1.createRandomFile("proj2/d.txt");
        this.env1.execute("diff", EMPTY_ARGS, new String[0], "proj2");
        this.env1.execute("diff", EMPTY_ARGS, new String[]{"f1/b.txt"}, "proj2");
        this.env1.setIgnoreExceptions(false);
    }

    public void testReadOnly() throws Exception {
        this.env1.execute("co", new String[]{"-r"}, EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", new String[0], EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt2"});
        this.env1.execute("update", new String[]{"-r"}, EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.execute("update", new String[0], EMPTY_ARGS, new String[]{"proj2"}, "");
    }

    public void testQuestionables() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.writeToFile("proj2/f2/d.txt", new String[]{"content"});
        this.env1.writeToFile("proj2/f3/f4/d.txt", new String[]{"content"});
        this.env1.writeToFile("proj2/f5/f6/f7/d.txt", new String[]{"content"});
        this.env1.execute("add", new String[0], new String[]{"f3"}, "proj2");
        this.env1.execute("add", new String[0], new String[]{"f3/f4"}, "proj2");
        this.env1.execute("update", new String[0], new String[]{"."}, "proj2");
    }

    public void testImportWrappers() throws Exception {
        this.env1.magicSetUpRepo("proj3", new String[]{"NoImportant.txt"});
        this.env2.deleteFile("proj3");
        this.env1.createRandomFile(new String[]{"a.txt", "a.class", "a.xxx"}, "proj3");
        this.env1.execute("import", new String[]{"-W", "*.txt -k 'kv'", "-W", "*.class -k 'b'", "-I", "*.xxx", "-m", "msg"}, new String[]{"proj3", "aTag", "bTag"}, "proj3");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj3"}, "");
    }

    public void testImportIgnores() throws Exception {
        this.env1.magicSetUpRepo("proj3", new String[]{"NoImportant.txt"});
        this.env2.deleteFile("proj3");
        this.env1.createRandomFile(new String[]{"a.txt", "a.class", "a.xxx"}, "proj3");
        this.env1.execute("import", new String[]{"-I", "*.xxx", "-m", "msg"}, new String[]{"proj3", "aTag", "bTag"}, "proj3");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj3"}, "");
    }

    private String toGMTString(Date d) {
        return d.toGMTString();
    }

    public void testDate() throws Exception {
        this.env1.execute("co", new String[0], new String[]{"proj2"});
        BasicTest.waitMsec(1100);
        Date beforeChange = GregorianCalendar.getInstance().getTime();
        BasicTest.waitMsec(1100);
        this.env1.appendToFile("proj2/a.txt", new String[]{"AppendIt"});
        this.env1.execute("ci", new String[]{"-m", "msg"}, new String[]{"proj2"});
        Date firstChange = GregorianCalendar.getInstance().getTime();
        BasicTest.waitMsec(1100);
        this.env1.appendToFile("proj2/a.txt", new String[]{"AppendIt2"});
        this.env1.appendToFile("proj2/f1/b.txt", new String[]{"AppendIt2"});
        this.env1.execute("ci", new String[]{"-m", "msg"}, new String[]{"proj2"});
        Date secondChange = GregorianCalendar.getInstance().getTime();
        BasicTest.waitMsec(1100);
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-D", this.toGMTString(beforeChange)}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-D", this.toGMTString(firstChange)}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[]{"-D", this.toGMTString(secondChange)}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[0], new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(beforeChange)}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(firstChange)}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(secondChange)}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(beforeChange), "-A"}, new String[]{"proj2"});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(secondChange)}, new String[]{"proj2"});
        this.env1.deleteFile("proj2");
        this.env1.execute("co", new String[0], new String[]{"proj2"});
        this.env1.appendToFile("proj2/a.txt", new String[]{"This is the world ..."});
        this.env1.execute("update", new String[]{"-D", this.toGMTString(beforeChange)}, new String[]{"proj2"});
        this.env1.appendToFile("proj2/a.txt", new String[]{"... which constantly changes"});
        this.env1.execute("update", new String[]{"-A"}, new String[]{"proj2"});
        this.env1.appendToFile("proj2/a.txt", new String[]{"... and the changes are approved"});
        this.env1.execute("ci", new String[]{"-m", "msg"}, new String[]{"proj2"});
    }
}

