/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.compatible;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.team.tests.ccvs.core.JUnitTestCase;
import org.eclipse.team.tests.ccvs.core.compatible.CompatibleTestSetup;
import org.eclipse.team.tests.ccvs.core.compatible.SameResultEnv;

public class ConflictTest
extends JUnitTestCase {
    SameResultEnv env1;
    SameResultEnv env2;

    public ConflictTest() {
        this(null);
    }

    public ConflictTest(String arg) {
        super(arg);
        this.env1 = new SameResultEnv(String.valueOf(arg) + "checkout1");
        this.env2 = new SameResultEnv(String.valueOf(arg) + "checkout2");
    }

    public void setUp() throws Exception {
        this.env1.setUp();
        this.env2.setUp();
        this.env1.magicSetUpRepo("proj2", new String[]{"a.txt", "f1/b.txt", "f1/c.txt"});
        this.env2.deleteFile("proj2");
    }

    public void tearDown() throws Exception {
        this.env1.tearDown();
        this.env2.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ConflictTest.class);
        return new CompatibleTestSetup((Test)suite);
    }

    public void testSimpleConflict() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt This"});
        this.env2.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt That"});
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.setIgnoreExceptions(true);
        this.env2.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env2.setIgnoreExceptions(false);
        this.env2.appendToFile("proj2/f1/c.txt", new String[]{"That's allright"});
        this.env2.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
    }

    public void testMergedUpdate() throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("co", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env1.prefixToFile("proj2/f1/c.txt", new String[]{"AppendIt at top"});
        this.env2.appendToFile("proj2/f1/c.txt", new String[]{"AppendIt at bottom"});
        this.env1.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
        this.env2.execute("update", EMPTY_ARGS, new String[]{"proj2"}, "");
        this.env2.execute("ci", new String[]{"-m", "TestMessage"}, new String[]{"proj2"}, "");
    }
}

