/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.compatible;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.tests.ccvs.core.CommandLineCVSClient;
import org.eclipse.team.tests.ccvs.core.EclipseCVSClient;
import org.eclipse.team.tests.ccvs.core.ICVSClient;
import org.eclipse.team.tests.ccvs.core.JUnitTestCase;
import org.eclipse.team.tests.ccvs.core.compatible.CompatibleTestSetup;

public final class SameResultEnv
extends JUnitTestCase {
    private IProject referenceProject;
    private ICVSFolder referenceRoot;
    private IProject eclipseProject;
    private ICVSFolder eclipseRoot;
    private boolean ignoreExceptions;

    public SameResultEnv(String arg) {
        super(arg);
    }

    public void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.referenceProject = root.getProject(String.valueOf(this.getName()) + "-reference");
        this.referenceProject.delete(true, true, null);
        SameResultEnv.mkdirs((IContainer)this.referenceProject);
        this.referenceRoot = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.referenceProject);
        this.eclipseProject = root.getProject(String.valueOf(this.getName()) + "-eclipse");
        this.eclipseProject.delete(true, true, null);
        SameResultEnv.mkdirs((IContainer)this.eclipseProject);
        this.eclipseRoot = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.eclipseProject);
        this.ignoreExceptions = false;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void execute(String command, String[] localOptions, String[] arguments, String pathRelativeToRoot) throws CVSException {
        this.execute(command, EMPTY_ARGS, localOptions, arguments, pathRelativeToRoot);
    }

    public void execute(String command, String[] localOptions, String[] arguments) throws CVSException {
        this.execute(command, EMPTY_ARGS, localOptions, arguments, "");
    }

    public void execute(String command, String[] globalOptions, String[] localOptions, String[] arguments, String pathRelativeToRoot) throws CVSException {
        boolean referenceClientException = this.execute(CommandLineCVSClient.INSTANCE, (ICVSRepositoryLocation)CompatibleTestSetup.referenceClientRepository, (IContainer)this.referenceProject, command, globalOptions, localOptions, arguments, pathRelativeToRoot);
        boolean eclipseClientException = this.execute(EclipseCVSClient.INSTANCE, (ICVSRepositoryLocation)CompatibleTestSetup.eclipseClientRepository, (IContainer)this.eclipseProject, command, globalOptions, localOptions, arguments, pathRelativeToRoot);
        SameResultEnv.assertEquals((boolean)referenceClientException, (boolean)eclipseClientException);
        this.assertConsistent();
    }

    private boolean execute(ICVSClient client, ICVSRepositoryLocation repositoryLocation, IContainer localRoot, String command, String[] globalOptions, String[] localOptions, String[] arguments, String pathRelativeToRoot) throws CVSException {
        try {
            Path path = new Path(pathRelativeToRoot);
            if (path.segmentCount() != 0) {
                localRoot = localRoot.getFolder((IPath)path);
            }
            client.executeCommand(repositoryLocation, localRoot, command, globalOptions, localOptions, arguments);
        }
        catch (CVSException e) {
            if (this.ignoreExceptions) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    public void magicDeleteRemote(String remoteName) throws CVSException {
        JUnitTestCase.magicDeleteRemote((ICVSRepositoryLocation)CompatibleTestSetup.referenceClientRepository, remoteName);
        JUnitTestCase.magicDeleteRemote((ICVSRepositoryLocation)CompatibleTestSetup.eclipseClientRepository, remoteName);
    }

    public void magicSetUpRepo(String projectName) throws IOException, CoreException, CVSException {
        this.magicSetUpRepo(projectName, new String[]{"a.txt", "f1/b.txt", "f1/c.txt"});
    }

    @Override
    public void magicSetUpRepo(String projectName, String[] createResources) throws IOException, CoreException, CVSException {
        this.magicDeleteRemote(projectName);
        IProject projectRoot = workspaceRoot.getProject(String.valueOf(projectName) + "-setup-tmp");
        SameResultEnv.mkdirs((IContainer)projectRoot);
        SameResultEnv.createRandomFile((IContainer)projectRoot, createResources);
        String[] lOptions = new String[]{"-m", "msg"};
        String[] args = new String[]{projectName, "a", "b"};
        SameResultEnv.magicDeleteRemote((ICVSRepositoryLocation)CompatibleTestSetup.referenceClientRepository, projectName);
        EclipseCVSClient.execute((ICVSRepositoryLocation)CompatibleTestSetup.referenceClientRepository, CVSWorkspaceRoot.getCVSFolderFor((IContainer)projectRoot), "import", EMPTY_ARGS, lOptions, args);
        SameResultEnv.magicDeleteRemote((ICVSRepositoryLocation)CompatibleTestSetup.eclipseClientRepository, projectName);
        EclipseCVSClient.execute((ICVSRepositoryLocation)CompatibleTestSetup.eclipseClientRepository, CVSWorkspaceRoot.getCVSFolderFor((IContainer)projectRoot), "import", EMPTY_ARGS, lOptions, args);
        projectRoot.delete(false, null);
    }

    public void createRandomFile(String relativeFileName) throws IOException, CoreException {
        String[] contents = new String[]{SameResultEnv.createRandomContent()};
        this.writeToFile(relativeFileName, contents);
    }

    public void createRandomFile(String[] relativeFileNames, String pathRelativeToRoot) throws CoreException, IOException {
        if (pathRelativeToRoot == null) {
            pathRelativeToRoot = "";
        } else if (!pathRelativeToRoot.endsWith("/")) {
            pathRelativeToRoot = String.valueOf(pathRelativeToRoot) + "/";
        }
        int i = 0;
        while (i < relativeFileNames.length) {
            this.createRandomFile(String.valueOf(pathRelativeToRoot) + relativeFileNames[i]);
            ++i;
        }
    }

    public String[] readFromFile(String relativeFileName) throws IOException, CoreException {
        IFile referenceFile = this.referenceProject.getFile(relativeFileName);
        Object[] content1 = JUnitTestCase.readFromFile(referenceFile);
        IFile eclipseFile = this.eclipseProject.getFile(relativeFileName);
        Object[] content2 = JUnitTestCase.readFromFile(eclipseFile);
        SameResultEnv.assertEqualsArrays(content1, content2);
        return content1;
    }

    public void deleteFile(String relativeFileName) throws CoreException {
        IProject eclipseFile;
        IProject referenceFile;
        if (relativeFileName.length() != 0) {
            referenceFile = this.referenceProject.findMember(relativeFileName);
            eclipseFile = this.eclipseProject.findMember(relativeFileName);
        } else {
            referenceFile = this.referenceProject;
            eclipseFile = this.eclipseProject;
        }
        SameResultEnv.assertEquals((referenceFile != null ? 1 : 0) != 0, (eclipseFile != null ? 1 : 0) != 0);
        if (referenceFile == null) {
            return;
        }
        SameResultEnv.assertEquals((boolean)referenceFile.exists(), (boolean)eclipseFile.exists());
        referenceFile.delete(true, null);
        eclipseFile.delete(true, null);
    }

    public void mkdirs(String relativeFolderName) throws CoreException {
        IFolder referenceFolder = this.referenceProject.getFolder(relativeFolderName);
        IFolder eclipseFolder = this.eclipseProject.getFolder(relativeFolderName);
        SameResultEnv.assertEquals((boolean)referenceFolder.exists(), (boolean)eclipseFolder.exists());
        SameResultEnv.mkdirs((IContainer)referenceFolder);
        SameResultEnv.mkdirs((IContainer)eclipseFolder);
    }

    public void appendToFile(String relativeFileName, String[] contents) throws IOException, CoreException {
        SameResultEnv.waitMsec(1500);
        IFile referenceFile = this.referenceProject.getFile(relativeFileName);
        SameResultEnv.appendToFile(referenceFile, contents);
        IFile eclipseFile = this.eclipseProject.getFile(relativeFileName);
        SameResultEnv.appendToFile(eclipseFile, contents);
    }

    public void prefixToFile(String relativeFileName, String[] contents) throws IOException, CoreException {
        SameResultEnv.waitMsec(1500);
        IFile referenceFile = this.referenceProject.getFile(relativeFileName);
        SameResultEnv.prefixToFile(referenceFile, contents);
        IFile eclipseFile = this.eclipseProject.getFile(relativeFileName);
        SameResultEnv.prefixToFile(eclipseFile, contents);
    }

    public void writeToFile(String relativeFileName, String[] contents) throws IOException, CoreException {
        IFile referenceFile = this.referenceProject.getFile(relativeFileName);
        SameResultEnv.writeToFile(referenceFile, contents);
        IFile eclipseFile = this.eclipseProject.getFile(relativeFileName);
        SameResultEnv.writeToFile(eclipseFile, contents);
    }

    public void assertConsistent() throws CVSException {
        SameResultEnv.assertEquals(this.referenceRoot, this.eclipseRoot);
    }

    public static void assertEquals(ICVSResource mResource1, ICVSResource mResource2) throws CVSException {
        SameResultEnv.assertEquals((boolean)mResource1.isFolder(), (boolean)mResource2.isFolder());
        SameResultEnv.assertEquals((boolean)mResource1.isManaged(), (boolean)mResource2.isManaged());
        SameResultEnv.assertEquals((boolean)mResource1.exists(), (boolean)mResource2.exists());
        if (!mResource1.exists()) {
            return;
        }
        if (mResource1.isFolder()) {
            SameResultEnv.assertEquals((ICVSFolder)mResource1, (ICVSFolder)mResource2);
        } else {
            SameResultEnv.assertEquals((ICVSFile)mResource1, (ICVSFile)mResource2);
        }
    }

    private static void assertEquals(ICVSFile mFile1, ICVSFile mFile2) throws CVSException {
        if (mFile1.getName().equals(".project")) {
            return;
        }
        SameResultEnv.assertEquals((boolean)mFile1.isReadOnly(), (boolean)mFile2.isReadOnly());
        try {
            InputStream in1 = mFile1.getContents();
            InputStream in2 = mFile2.getContents();
            byte[] buffer1 = new byte[(int)mFile1.getSize()];
            byte[] buffer2 = new byte[(int)mFile2.getSize()];
            in1.read(buffer1);
            in2.read(buffer2);
            in1.close();
            in2.close();
            SameResultEnv.assertEquals((String)("Length differs for file " + mFile1.getName()), (int)buffer1.length, (int)buffer2.length);
            SameResultEnv.assertEquals((String)("Contents differs for file " + mFile1.getName()), (String)new String(buffer1), (String)new String(buffer2));
        }
        catch (IOException iOException) {
            throw new CVSException("Error in TestCase");
        }
        SameResultEnv.assertEquals((mFile1.getSyncInfo() == null ? 1 : 0) != 0, (mFile2.getSyncInfo() == null ? 1 : 0) != 0);
        if (mFile1.getSyncInfo() == null) {
            return;
        }
        ResourceSyncInfo info1 = mFile1.getSyncInfo();
        ResourceSyncInfo info2 = mFile2.getSyncInfo();
        SameResultEnv.assertEquals((Object)info1.getKeywordMode(), (Object)info2.getKeywordMode());
        SameResultEnv.assertEquals((Object)info1.getTag(), (Object)info2.getTag());
        SameResultEnv.assertEquals((String)info1.getName(), (String)info2.getName());
        SameResultEnv.assertEquals((String)info1.getRevision(), (String)info2.getRevision());
        SameResultEnv.assertEquals((boolean)info1.isDeleted(), (boolean)info2.isDeleted());
        SameResultEnv.assertEquals((boolean)info1.isAdded(), (boolean)info2.isAdded());
        SameResultEnv.assertEquals((boolean)info1.isMerged(), (boolean)info2.isMerged());
        SameResultEnv.assertEquals((boolean)info1.isMergedWithConflicts(), (boolean)info2.isMergedWithConflicts());
    }

    private static void assertEquals(ICVSFolder mFolder1, ICVSFolder mFolder2) throws CVSException {
        SameResultEnv.assertEquals((boolean)mFolder1.isCVSFolder(), (boolean)mFolder2.isCVSFolder());
        if (mFolder1.isCVSFolder()) {
            String root1 = SameResultEnv.removePassword(mFolder1.getFolderSyncInfo().getRoot());
            String root2 = SameResultEnv.removePassword(mFolder2.getFolderSyncInfo().getRoot());
            root1 = root1.substring(0, root1.lastIndexOf("@"));
            root2 = root2.substring(0, root2.lastIndexOf("@"));
            SameResultEnv.assertEquals((String)root1, (String)root2);
            SameResultEnv.assertEquals((String)mFolder1.getFolderSyncInfo().getRepository(), (String)mFolder2.getFolderSyncInfo().getRepository());
            SameResultEnv.assertEquals((boolean)mFolder1.getFolderSyncInfo().getIsStatic(), (boolean)mFolder2.getFolderSyncInfo().getIsStatic());
            SameResultEnv.assertEquals((Object)mFolder1.getFolderSyncInfo().getTag(), (Object)mFolder2.getFolderSyncInfo().getTag());
        }
        ICVSResource[] resourceList1 = mFolder1.members(3);
        ICVSResource[] resourceList2 = mFolder2.members(3);
        SameResultEnv.assertEquals((int)resourceList1.length, (int)resourceList2.length);
        int i = 0;
        while (i < resourceList1.length) {
            boolean resourceFound = false;
            int j = 0;
            while (j < resourceList2.length) {
                if (resourceList1[i].getName().equals(resourceList2[j].getName())) {
                    SameResultEnv.assertEquals(resourceList1[i], resourceList2[j]);
                    resourceFound = true;
                    break;
                }
                ++j;
            }
            SameResultEnv.assertTrue((String)("Resource " + resourceList1[i].getName() + " not found in the list"), (boolean)resourceFound);
            ++i;
        }
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    public static String removePassword(String root) {
        int indexOfHostSeparator = root.lastIndexOf("@", root.length());
        String hostAndPath = root.substring(indexOfHostSeparator);
        root = root.substring(0, indexOfHostSeparator);
        StringTokenizer tok = new StringTokenizer(root, ":", true);
        StringBuffer filteredRoot = new StringBuffer();
        int colonCounter = 3;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (":".equals(token) && --colonCounter == 0 || colonCounter == 0) continue;
            filteredRoot.append(token);
        }
        filteredRoot.append(hostAndPath);
        return filteredRoot.toString();
    }
}

