/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.cvsresources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class EclipseFolderTest
extends EclipseTest {
    public EclipseFolderTest() {
    }

    public EclipseFolderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EclipseFolderTest.class);
        return new CVSTestSetup((Test)suite);
    }

    protected void assertChildrenHaveSync(IContainer root, final boolean hasSync) throws CoreException, CVSException {
        root.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                try {
                    ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                    if (!cvsResource.isIgnored()) {
                        if (resource.getType() == 1) {
                            EclipseFolderTest.assertTrue((cvsResource.getSyncInfo() != null == hasSync ? 1 : 0) != 0);
                        } else {
                            EclipseFolderTest.assertTrue((((ICVSFolder)cvsResource).getFolderSyncInfo() != null == hasSync ? 1 : 0) != 0);
                        }
                    }
                }
                catch (CVSException e) {
                    throw new CoreException(e.getStatus());
                }
                return true;
            }
        });
    }

    public void testUnmanageFolder() throws CoreException, TeamException {
        IProject project = this.createProject("testUnmanageFolder_A", new String[]{"a.txt", "folder1/", "folder1/b.txt", "folder1/folder2/", "folder1/folder2/c.txt"});
        ICVSFolder cvsProject = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        this.assertChildrenHaveSync((IContainer)project, true);
        cvsProject.unmanage(null);
        this.assertChildrenHaveSync((IContainer)project, false);
        final IProject projectB = this.createProject("testUnmanageFolder_B", new String[]{"a.txt", "folder1/", "folder1/b.txt", "folder1/folder2/", "folder1/folder2/c.txt"});
        final ICVSFolder cvsProjectB = CVSWorkspaceRoot.getCVSFolderFor((IContainer)projectB);
        this.assertChildrenHaveSync((IContainer)projectB, true);
        cvsProjectB.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                try {
                    EclipseFolderTest.this.assertChildrenHaveSync((IContainer)projectB, true);
                    cvsProjectB.unmanage(null);
                    EclipseFolderTest.this.assertChildrenHaveSync((IContainer)projectB, false);
                }
                catch (CoreException e) {
                    throw CVSException.wrapException((CoreException)e);
                }
            }
        }, null);
        this.assertChildrenHaveSync((IContainer)projectB, false);
    }
}

