/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.cvsresources;

import java.text.ParseException;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.CVSDateFormatter;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.TestConnection;

public class ResourceSyncBytesTest
extends EclipseTest {
    public ResourceSyncBytesTest() {
    }

    public ResourceSyncBytesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceSyncBytesTest.class);
        return new CVSTestSetup((Test)suite);
    }

    private byte[] getBytesForSlot(String input, int slot) {
        return this.getBytesForSlot(input, slot, false);
    }

    private byte[] getBytesForSlot(String input, int slot, boolean includeRest) {
        byte[] result = Util.getBytesForSlot((byte[])input.getBytes(), (byte)47, (int)slot, (boolean)includeRest);
        return result;
    }

    private void assertEqualBytes(String expected, byte[] actual) {
        ResourceSyncBytesTest.assertEquals((String)expected, (String)new String(actual));
    }

    public void testUtilGetBytesForSlot() {
        String input = "zero/one/two";
        this.assertEqualBytes("zero", this.getBytesForSlot(input, 0));
        this.assertEqualBytes("one", this.getBytesForSlot(input, 1));
        this.assertEqualBytes("two", this.getBytesForSlot(input, 2));
        this.assertEqualBytes("one/two", this.getBytesForSlot(input, 1, true));
        this.assertEqualBytes("", this.getBytesForSlot("///", 0));
        this.assertEqualBytes("", this.getBytesForSlot("///", 1));
        this.assertEqualBytes("", this.getBytesForSlot("///", 2));
        this.assertEqualBytes("/", this.getBytesForSlot("///", 2, true));
        input = "zero/one/two";
        ResourceSyncBytesTest.assertNull((Object)this.getBytesForSlot(input, 3));
        ResourceSyncBytesTest.assertNull((Object)this.getBytesForSlot(input, 4));
        ResourceSyncBytesTest.assertNull((Object)this.getBytesForSlot(input, -1));
    }

    public void testSendEntry() throws CVSException, ParseException {
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(":test:user:password@host:/path");
        CVSProviderPlugin.getPlugin().setDetermineVersionEnabled(false);
        Session session = new Session(location, CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()));
        session.open(DEFAULT_MONITOR, false);
        byte[] entryLine = "/plugin.xml/1.27/Tue Mar  4 19:47:36 2003/-ko/".getBytes();
        session.sendEntry(entryLine, ResourceSyncInfo.getTimestampToServer((byte[])entryLine, (Date)CVSDateFormatter.entryLineToDate((String)"Tue Mar  4 19:47:36 2003")));
        ResourceSyncBytesTest.assertEquals((String)"Entry /plugin.xml/1.27//-ko/", (String)TestConnection.getLastLine());
        entryLine = "/newfile.txt/1.10/Result of merge+Thu Mar 20 16:36:56 2003//".getBytes();
        session.sendEntry(entryLine, ResourceSyncInfo.getTimestampToServer((byte[])entryLine, (Date)CVSDateFormatter.entryLineToDate((String)"Thu Mar 20 16:36:56 2003")));
        ResourceSyncBytesTest.assertEquals((String)"Entry /newfile.txt/1.10/+=//", (String)TestConnection.getLastLine());
        entryLine = "/newfile.txt/1.10/Result of merge+Thu Mar 20 16:36:56 2003//".getBytes();
        session.sendEntry(entryLine, ResourceSyncInfo.getTimestampToServer((byte[])entryLine, (Date)CVSDateFormatter.entryLineToDate((String)"Thu Mar 20 16:37:56 2003")));
        ResourceSyncBytesTest.assertEquals((String)"Entry /newfile.txt/1.10/+modified//", (String)TestConnection.getLastLine());
        entryLine = "/plugin.xml/0/dummy timestamp/-ko/".getBytes();
        session.sendEntry(entryLine, ResourceSyncInfo.getTimestampToServer((byte[])entryLine, (Date)CVSDateFormatter.entryLineToDate((String)"Tue Mar  4 19:47:36 2003")));
        ResourceSyncBytesTest.assertEquals((String)"Entry /plugin.xml/0//-ko/", (String)TestConnection.getLastLine());
        entryLine = "/plugin.xml/1.1//-ko/".getBytes();
        session.sendEntry(entryLine, ResourceSyncInfo.getTimestampToServer((byte[])entryLine, (Date)CVSDateFormatter.entryLineToDate((String)"Tue Mar  4 19:47:36 2003")));
        ResourceSyncBytesTest.assertEquals((String)"Entry /plugin.xml/1.1//-ko/", (String)TestConnection.getLastLine());
    }
}

