/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.mappings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.internal.resources.mapping.SimpleResourceMapping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.operations.CacheBaseContentsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CacheRemoteContentsOperation;
import org.eclipse.team.internal.core.ResourceVariantCache;
import org.eclipse.team.internal.core.ResourceVariantCacheEntry;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.mappings.SyncInfoSetTraveralContext;
import org.eclipse.team.ui.TeamOperation;

public class ResourceMapperTests
extends EclipseTest {
    public ResourceMapperTests() {
    }

    public ResourceMapperTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ResourceMapperTests.suite(ResourceMapperTests.class);
    }

    protected void update(ResourceMapping mapper, Command.LocalOption[] options) throws Exception {
        SyncInfoTree incomingSet = this.getIncoming(mapper.getProjects());
        this.update(new ResourceMapping[]{mapper}, options);
        this.assertUpdate(mapper, incomingSet);
    }

    protected void replace(ResourceMapping mapper) throws Exception {
        SyncInfoTree incomingSet = this.getIncoming(mapper.getProjects());
        this.replace(new ResourceMapping[]{mapper});
        this.assertUpdate(mapper, incomingSet);
    }

    protected void commit(ResourceMapping mapper, String message) throws CoreException {
        SyncInfoTree set = this.getOutgoing(mapper.getProjects());
        this.commit(new ResourceMapping[]{mapper}, message);
        this.assertCommit(mapper, set);
    }

    protected void tag(ResourceMapping mapping, CVSTag tag) throws CoreException {
        this.tag(new ResourceMapping[]{mapping}, tag, false);
        this.assertTagged(mapping, tag);
    }

    protected void branch(ResourceMapping mapping, CVSTag branch) throws CoreException, IOException {
        CVSTag version = new CVSTag("Root_" + branch.getName(), 2);
        this.branch(new ResourceMapping[]{mapping}, version, branch, true);
        this.assertTagged(mapping, version);
        this.assertBranched(mapping, branch);
    }

    protected void add(ResourceMapping mapping) throws CoreException {
        SyncInfoTree set = this.getUnaddedResource(mapping);
        this.add(new ResourceMapping[]{mapping});
        this.assertAdded(mapping, set);
    }

    private void assertAdded(ResourceMapping mapping, final SyncInfoTree set) throws CoreException {
        this.visit(mapping, ResourceMappingContext.LOCAL_CONTEXT, new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                ICVSResource cvsResource = ResourceMapperTests.this.getCVSResource(resource);
                ResourceMapperTests.assertTrue((String)("Resource was not added but should have been: " + resource.getFullPath()), (cvsResource.isManaged() || cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder() ? 1 : 0) != 0);
                set.remove(resource);
                return true;
            }
        });
        SyncInfo[] infos = set.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            ICVSResource cvsResource = this.getCVSResource(info.getLocal());
            ResourceMapperTests.assertTrue((String)("Resource was added but should not have been: " + info.getLocal().getFullPath()), (!cvsResource.isManaged() ? 1 : 0) != 0);
            ++i;
        }
    }

    private void assertBranched(ResourceMapping mapping, CVSTag branch) throws CoreException {
        this.assertTagged(mapping, branch);
        Map remotes = this.getTaggedRemoteFilesByPath(mapping, branch);
        Map locals = this.getTaggedLocalFilesByPath(mapping, branch);
        Iterator iter = remotes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ICVSRemoteFile remote = (ICVSRemoteFile)remotes.get(key);
            ICVSFile local = (ICVSFile)locals.get(key);
            ResourceMapperTests.assertNotNull((String)("Remotely tagged resource was not tagged locally: " + remote.getRepositoryRelativePath()), (Object)local);
            this.assertEquals(local.getIResource().getParent().getFullPath(), (ICVSFile)remote, local, false, false);
            ResourceMapperTests.assertEquals((String)("Remotely tagged resource was not tagged locally: " + remote.getRepositoryRelativePath()), (Object)branch, (Object)local.getSyncInfo().getTag());
            locals.remove(key);
            iter.remove();
        }
        for (String path : remotes.keySet()) {
            ResourceMapperTests.fail((String)("Remote file " + path + " was tagged remotely but not locally."));
        }
        for (String path : locals.keySet()) {
            ResourceMapperTests.fail((String)("Local file " + path + " was tagged locally but not remotely."));
        }
    }

    private void assertTagged(ResourceMapping mapping, CVSTag tag) throws CoreException {
        final Map tagged = this.getTaggedRemoteFilesByPath(mapping, tag);
        this.visit(mapping, ResourceMappingContext.LOCAL_CONTEXT, new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    ICVSRemoteFile file = ResourceMapperTests.this.popRemote(resource, tagged);
                    ResourceMapperTests.assertNotNull((String)("Resource was not tagged: " + resource.getFullPath()), (Object)file);
                }
                return true;
            }
        });
        for (String path : tagged.keySet()) {
            ResourceMapperTests.fail((String)("Remote file " + path + " was tagged but should not have been."));
        }
    }

    private Map getTaggedLocalFilesByPath(ResourceMapping mapping, final CVSTag branch) throws CoreException {
        final HashMap tagged = new HashMap();
        IProject[] projects = mapping.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ICVSFile file;
                    ResourceSyncInfo info;
                    if (resource.getType() == 1 && (info = (file = (ICVSFile)ResourceMapperTests.this.getCVSResource(resource)).getSyncInfo()) != null && info.getTag() != null && info.getTag().equals((Object)branch)) {
                        tagged.put(file.getRepositoryRelativePath(), file);
                    }
                    return true;
                }
            });
            ++i;
        }
        return tagged;
    }

    private Map getTaggedRemoteFilesByPath(ResourceMapping mapping, CVSTag tag) throws CVSException {
        IProject[] projects = mapping.getProjects();
        ICVSResource[] remotes = this.getRemoteTrees(projects, tag);
        Map tagged = this.getFilesByPath(remotes);
        return tagged;
    }

    private ICVSResource[] getRemoteTrees(IProject[] projects, CVSTag tag) throws CVSException {
        ArrayList<RemoteFolderTree> result = new ArrayList<RemoteFolderTree>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            RemoteFolderTree tree = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)this.getRepository(), (IContainer)project, (CVSTag)tag, (IProgressMonitor)DEFAULT_MONITOR);
            result.add(tree);
            ++i;
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    private Map getFilesByPath(ICVSResource[] remotes) throws CVSException {
        HashMap result = new HashMap();
        int i = 0;
        while (i < remotes.length) {
            ICVSResource resource = remotes[i];
            this.collectFiles(resource, result);
            ++i;
        }
        return result;
    }

    private void collectFiles(ICVSResource resource, Map result) throws CVSException {
        if (resource.isFolder()) {
            ICVSResource[] members = ((ICVSFolder)resource).members(63);
            int i = 0;
            while (i < members.length) {
                ICVSResource member = members[i];
                this.collectFiles(member, result);
                ++i;
            }
        } else {
            result.put(resource.getRepositoryRelativePath(), resource);
        }
    }

    private ICVSRemoteFile popRemote(IResource resource, Map tagged) throws CVSException {
        ICVSResource cvsResource = this.getCVSResource(resource);
        ICVSRemoteFile remote = (ICVSRemoteFile)tagged.get(cvsResource.getRepositoryRelativePath());
        if (remote != null) {
            tagged.remove(remote.getRepositoryRelativePath());
        }
        return remote;
    }

    private ResourceMapping asResourceMapping(final IResource[] resources, final int depth) {
        return new ResourceMapping(){
            private Object object = new Object();

            public Object getModelObject() {
                return this.object;
            }

            public IProject[] getProjects() {
                return this.getProjects(resources);
            }

            private IProject[] getProjects(IResource[] resources2) {
                HashSet<IProject> projects = new HashSet<IProject>();
                int i = 0;
                while (i < resources2.length) {
                    IResource resource = resources2[i];
                    projects.add(resource.getProject());
                    ++i;
                }
                return projects.toArray(new IProject[projects.size()]);
            }

            public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                return new ResourceTraversal[]{new ResourceTraversal(resources, depth, 0)};
            }

            public String getModelProviderId() {
                return "org.eclipse.team.tests.cvs.core.modelProvider";
            }
        };
    }

    private void assertUpdate(ResourceMapping mapper, final SyncInfoTree set) throws Exception {
        final Exception[] exception = new Exception[1];
        this.visit(mapper, (ResourceMappingContext)new SyncInfoSetTraveralContext((SyncInfoSet)set), new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                SyncInfo info = set.getSyncInfo(resource);
                if (info != null) {
                    set.remove(resource);
                    try {
                        ResourceMapperTests.this.assertEquals(resource.getParent().getFullPath(), ResourceMapperTests.this.getCVSResource(resource), (ICVSResource)info.getRemote(), false, false);
                    }
                    catch (CVSException e) {
                        exception[0] = e;
                    }
                    catch (CoreException e) {
                        exception[0] = e;
                    }
                    catch (IOException e) {
                        exception[0] = e;
                    }
                }
                return true;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        this.assertUnchanged(set);
    }

    private void assertCommit(ResourceMapping mapper, final SyncInfoTree set) throws CoreException {
        this.visit(mapper, (ResourceMappingContext)new SyncInfoSetTraveralContext((SyncInfoSet)set), new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                SyncInfo info = set.getSyncInfo(resource);
                if (info != null) {
                    set.remove(resource);
                    ResourceMapperTests.assertTrue((String)("Committed resource is not in-sync: " + resource.getFullPath()), (ResourceMapperTests.this.getSyncInfo(resource).getKind() == 0 ? 1 : 0) != 0);
                }
                return true;
            }
        });
        this.assertUnchanged(set);
    }

    private void assertUnchanged(SyncInfoTree set) throws TeamException {
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().refresh(set.getResources(), 0, DEFAULT_MONITOR);
        SyncInfo[] infos = set.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            this.assertUnchanged(info);
            ++i;
        }
    }

    private void assertUnchanged(SyncInfo info) throws TeamException {
        SyncInfo current = this.getSyncInfo(info.getLocal());
        ResourceMapperTests.assertEquals((String)("The sync info changed for " + info.getLocal().getFullPath()), (Object)info, (Object)current);
    }

    private SyncInfo getSyncInfo(IResource local) throws TeamException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getSyncInfo(local);
    }

    private SyncInfoTree getIncoming(IProject[] projects) throws TeamException {
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().refresh((IResource[])projects, 2, DEFAULT_MONITOR);
        SyncInfoTree set = this.getAllOutOfSync(projects);
        set.removeOutgoingNodes();
        set.removeConflictingNodes();
        return set;
    }

    private SyncInfoTree getOutgoing(IProject[] projects) {
        SyncInfoTree set = this.getAllOutOfSync(projects);
        set.removeIncomingNodes();
        set.removeConflictingNodes();
        return set;
    }

    private SyncInfoTree getUnaddedResource(ResourceMapping mapping) {
        SyncInfoTree set = this.getAllOutOfSync(mapping.getProjects());
        set.selectNodes(new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                try {
                    if (info.getLocal().getType() != 4 && info.getRemote() == null && info.getBase() == null) {
                        ICVSResource resource = ResourceMapperTests.this.getCVSResource(info.getLocal());
                        return !resource.isManaged();
                    }
                }
                catch (CVSException e) {
                    ResourceMapperTests.fail((String)e.getMessage());
                }
                return false;
            }
        });
        return set;
    }

    private SyncInfoTree getAllOutOfSync(IProject[] projects) {
        SyncInfoTree set = new SyncInfoTree();
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().collectOutOfSync((IResource[])projects, 2, (SyncInfoSet)set, DEFAULT_MONITOR);
        return set;
    }

    private IResourceDiffTree getAllDiffs(IProject[] projects) throws CoreException {
        final ResourceDiffTree tree = new ResourceDiffTree();
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().accept((IResource[])projects, 2, new IDiffVisitor(){

            public boolean visit(IDiff delta) {
                tree.add(delta);
                return true;
            }
        });
        return tree;
    }

    private void visit(ResourceMapping mapper, ResourceMappingContext context, IResourceVisitor visitor) throws CoreException {
        ResourceTraversal[] traversals = mapper.getTraversals(context, null);
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            this.visit(traversal, context, visitor);
            ++i;
        }
    }

    private void visit(ResourceTraversal traversal, ResourceMappingContext context, IResourceVisitor visitor) throws CoreException {
        IResource[] resources = traversal.getResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.visit(resource, visitor, context, traversal.getDepth());
            ++i;
        }
    }

    private void visit(IResource resource, IResourceVisitor visitor, ResourceMappingContext context, int depth) throws CoreException {
        if (!visitor.visit(resource) || depth == 0 || resource.getType() == 1) {
            return;
        }
        HashSet<IResource> members = new HashSet<IResource>();
        members.addAll(Arrays.asList(((IContainer)resource).members(false)));
        if (context instanceof RemoteResourceMappingContext) {
            RemoteResourceMappingContext remoteContext = (RemoteResourceMappingContext)context;
            members.addAll(Arrays.asList(remoteContext.fetchMembers((IContainer)resource, DEFAULT_MONITOR)));
        }
        for (IResource member : members) {
            this.visit(member, visitor, context, depth == 1 ? 0 : 2);
        }
    }

    private boolean isTimeout(Throwable e) {
        CoreException ce;
        if (e == null) {
            return false;
        }
        if (e instanceof InterruptedIOException && e.getMessage() != null && e.getMessage().indexOf("Timeout while writing to output stream") >= 0) {
            return true;
        }
        if (e instanceof CoreException && (ce = (CoreException)e).getStatus() != null && ce.getStatus().isMultiStatus()) {
            MultiStatus multistatus = (MultiStatus)ce.getStatus();
            int i = 0;
            while (i < multistatus.getChildren().length) {
                if (this.isTimeout(multistatus.getChildren()[i].getException())) {
                    return true;
                }
                ++i;
            }
        }
        return this.isTimeout(e.getCause());
    }

    public void testUpdate() throws Exception {
        try {
            IProject project = this.createProject("testUpdate", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
            IProject copy = this.checkoutCopy(project, "-copy");
            this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
            this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
            this.deleteResources(new IResource[]{copy.getFile("deleted.txt")});
            this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
            this.setContentsAndEnsureModified(copy.getFile("folder1/subfolder1/c.txt"));
            this.commit(this.asResourceMapping(new IResource[]{copy}, 2), "A commit message");
            this.update(this.asResourceMapping(new IResource[]{project}, 1), null);
            this.update(this.asResourceMapping(new IResource[]{project.getFolder("folder1")}, 1), null);
            this.update(this.asResourceMapping(new IResource[]{project.getFile("folder1/subfolder1/c.txt")}, 0), null);
            this.update(this.asResourceMapping(new IResource[]{project.getFolder("folder2")}, 2), null);
            this.assertEquals(project, copy);
        }
        catch (Exception e) {
            if (this.isTimeout(e)) {
                System.err.println("Timeout while testUpdate");
                e.printStackTrace();
                return;
            }
            throw e;
        }
    }

    public void testReplace() throws Exception {
        try {
            IProject project = this.createProject("testReplace", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
            IProject copy = this.checkoutCopy(project, "-copy");
            this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
            this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
            this.deleteResources(new IResource[]{copy.getFile("deleted.txt")});
            this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
            this.setContentsAndEnsureModified(copy.getFile("folder1/subfolder1/c.txt"));
            this.commit(this.asResourceMapping(new IResource[]{copy}, 2), "A commit message");
            this.replace(this.asResourceMapping(new IResource[]{project}, 1));
            this.deleteResources(new IResource[]{project.getFile("folder1/b.txt")});
            this.replace(this.asResourceMapping(new IResource[]{project.getFolder("folder1")}, 1));
            this.replace(this.asResourceMapping(new IResource[]{project.getFile("folder1/subfolder1/c.txt")}, 0));
            this.replace(this.asResourceMapping(new IResource[]{project.getFolder("folder2")}, 2));
            this.assertEquals(project, copy);
        }
        catch (Exception e) {
            if (this.isTimeout(e)) {
                System.err.println("Timeout while testReplace");
                e.printStackTrace();
                return;
            }
            throw e;
        }
    }

    public void testCommit() throws Exception {
        if (Util.isMac()) {
            return;
        }
        IProject project = this.createProject("testCommit", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
        this.addResources((IContainer)project, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.deleteResources(new IResource[]{project.getFile("deleted.txt")});
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.setContentsAndEnsureModified(project.getFile("folder1/subfolder1/c.txt"));
        this.commit(this.asResourceMapping(new IResource[]{project}, 1), "A commit message");
        this.commit(this.asResourceMapping(new IResource[]{project.getFolder("folder1")}, 1), "A commit message");
        this.commit(this.asResourceMapping(new IResource[]{project.getFile("folder1/subfolder1/c.txt")}, 0), "A commit message");
        this.commit(this.asResourceMapping(new IResource[]{project.getFolder("folder2")}, 2), "A commit message");
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertEquals(project, copy);
    }

    public void testTag() throws Exception {
        IProject project = this.createProject("testTag", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
        this.tag(this.asResourceMapping(new IResource[]{project}, 1), new CVSTag("v1", 2));
        this.tag(this.asResourceMapping(new IResource[]{project.getFolder("folder1")}, 1), new CVSTag("v2", 2));
        this.tag(this.asResourceMapping(new IResource[]{project.getFile("folder1/subfolder1/c.txt")}, 0), new CVSTag("v3", 2));
        this.tag(this.asResourceMapping(new IResource[]{project}, 2), new CVSTag("v4", 2));
    }

    public void testBranch() throws Exception {
    }

    public void testAdd() throws TeamException, CoreException {
        IProject project = this.createProject("testAdd", new String[0]);
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"}, false);
        this.add(this.asResourceMapping(new IResource[]{project}, 1));
        this.add(this.asResourceMapping(new IResource[]{project.getFolder("folder1")}, 1));
        this.add(this.asResourceMapping(new IResource[]{project.getFile("folder1/subfolder1/c.txt")}, 0));
        this.add(this.asResourceMapping(new IResource[]{project}, 2));
    }

    public void testCacheBase() throws TeamException, CoreException {
        if (Util.isMac()) {
            return;
        }
        IProject project = this.createProject("testCacheBase", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(project.getFile("changed.txt"), "Uncommitted text");
        this.setContentsAndEnsureModified(project.getFile("folder1/b.txt"));
        project.getFile("deleted.txt").delete(false, true, null);
        try {
            this.cacheBase(project, true);
            this.cacheBase(project, false);
            this.setContentsAndEnsureModified(copy.getFile("changed.txt"), "Text comited from the copy");
            this.commitProject(copy);
            this.cacheBase(project, true);
            this.cacheBase(project, false);
        }
        catch (TeamException e) {
            this.logIfCausedByInterruptedIOException(e);
        }
    }

    private void logIfCausedByInterruptedIOException(TeamException e) throws TeamException {
        CVSCommunicationException cce;
        Throwable ex;
        MultiStatus mstatus;
        IStatus status = e.getStatus();
        if (status.isMultiStatus() && (status = (mstatus = (MultiStatus)status).getChildren()[0]) instanceof TeamStatus && (ex = status.getException()) instanceof CVSCommunicationException && (status = (cce = (CVSCommunicationException)ex).getStatus()).isMultiStatus() && status.getException() instanceof InterruptedIOException) {
            ResourceMapperTests.log((String)"org.eclipse.team.tests.cvs.core", (IStatus)e.getStatus());
            return;
        }
        throw e;
    }

    public void testCacheRemote() throws TeamException, CoreException {
        IProject project = this.createProject("testCacheRemote", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder1/subfolder1/c.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"), "Uncommitted text");
        this.setContentsAndEnsureModified(copy.getFile("folder1/b.txt"));
        this.commitProject(copy);
        project.getFile("deleted.txt").delete(false, true, null);
        this.cacheRemote(project);
    }

    private void cacheRemote(IProject project) throws CoreException {
        this.clearCache(project);
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().refresh((IResource[])new IProject[]{project}, 2, DEFAULT_MONITOR);
        IResourceDiffTree tree = this.getAllDiffs(new IProject[]{project});
        ResourceMapping[] mappings = new ResourceMapping[]{new SimpleResourceMapping((IResource)project)};
        CacheRemoteContentsOperation op = new CacheRemoteContentsOperation(null, mappings, tree);
        ResourceMapperTests.executeHeadless((TeamOperation)op);
        this.ensureRemoteCached(tree);
    }

    private void cacheBase(IProject project, boolean includeOutgoing) throws CoreException {
        this.clearCache(project);
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().refresh((IResource[])new IProject[]{project}, 2, DEFAULT_MONITOR);
        IResourceDiffTree tree = this.getAllDiffs(new IProject[]{project});
        ResourceMapping[] mappings = new ResourceMapping[]{new SimpleResourceMapping((IResource)project)};
        CacheBaseContentsOperation op = new CacheBaseContentsOperation(null, mappings, tree, includeOutgoing);
        ResourceMapperTests.executeHeadless((TeamOperation)op);
        this.ensureBaseCached(tree, includeOutgoing);
    }

    private void ensureRemoteCached(IResourceDiffTree tree) {
        IResource[] resources = tree.getAffectedResources();
        int i = 0;
        while (i < resources.length) {
            IThreeWayDiff twd;
            IResourceVariant remote;
            IResource resource = resources[i];
            IDiff node = tree.getDiff(resource);
            if (node instanceof IThreeWayDiff && (remote = SyncInfoToDiffConverter.getRemoteVariant((IThreeWayDiff)(twd = (IThreeWayDiff)node))) != null) {
                boolean isCached = ((CachedResourceVariant)remote).isContentsCached();
                int direction = twd.getDirection();
                if (direction == 768 || direction == 512) {
                    ResourceMapperTests.assertTrue((String)NLS.bind((String)"The remote contents should be cached for {0}", (Object[])new String[]{resource.getFullPath().toString()}), (boolean)isCached);
                } else {
                    ResourceMapperTests.assertFalse((String)NLS.bind((String)"The base contents should NOT be cached for {0}", (Object[])new String[]{resource.getFullPath().toString()}), (boolean)isCached);
                }
            }
            ++i;
        }
    }

    private void ensureBaseCached(IResourceDiffTree tree, boolean includeOutgoing) throws TeamException, CoreException {
        IResource[] resources = tree.getAffectedResources();
        int i = 0;
        while (i < resources.length) {
            IThreeWayDiff twd;
            IResourceVariant base;
            IResource resource = resources[i];
            IDiff node = tree.getDiff(resource);
            if (node instanceof IThreeWayDiff && (base = SyncInfoToDiffConverter.getBaseVariant((IThreeWayDiff)(twd = (IThreeWayDiff)node))) != null) {
                boolean isCached = ((CachedResourceVariant)base).isContentsCached();
                int direction = twd.getDirection();
                if (direction == 768 || includeOutgoing && direction == 256) {
                    IResourceVariant remote;
                    ResourceMapperTests.assertTrue((String)NLS.bind((String)"The base contents should be cached for {0}", (Object[])new String[]{resource.getFullPath().toString()}), (boolean)isCached);
                    if (direction == 12 && (remote = SyncInfoToDiffConverter.getRemoteVariant((IThreeWayDiff)twd)) != null) {
                        InputStream remoteIn;
                        InputStream baseIn = base.getStorage(DEFAULT_MONITOR).getContents();
                        if (baseIn == null) {
                            ResourceMapperTests.fail((String)NLS.bind((String)"Base was not fetched for {0}", (Object[])new String[]{resource.getFullPath().toString()}));
                        }
                        if (this.compareContent(baseIn, remoteIn = remote.getStorage(DEFAULT_MONITOR).getContents())) {
                            ResourceMapperTests.fail((String)NLS.bind((String)"The remote was fetched instead of the base for {0}", (Object[])new String[]{resource.getFullPath().toString()}));
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void clearCache(IProject project) {
        ResourceVariantCache cache = ResourceVariantCache.getCache((String)"org.eclipse.team.cvs.core");
        if (cache != null) {
            ResourceVariantCacheEntry[] entries = cache.getEntries();
            int i = 0;
            while (i < entries.length) {
                ResourceVariantCacheEntry entry = entries[i];
                entry.dispose();
                ++i;
            }
        }
    }

    public void testBug134517() throws Exception {
        IProject project = this.createProject("testBug134517", new String[]{"file1.txt", "file2.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"file0.txt", "new_folder1/", "new_folder1/file2.txt", "new_folder1/new_folder2/", "new_folder1/new_folder2/new_folder3/", "new_folder1/new_folder2/new_folder3/file3.txt"}, true);
        IResource[] resources = new IResource[]{project.getFile("file0.txt"), project.getFile("file1.txt"), project.getFile("new_folder1/file2.txt"), project.getFile("new_folder1/new_folder2/new_folder3/file3.txt")};
        this.update(this.asResourceMapping(resources, 0), null);
        this.assertEquals(project, copy);
    }

    public void testDeepNewFolder() throws Exception {
        IProject project = this.createProject("testBug134517", new String[]{"file1.txt", "file2.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"new_folder1/", "new_folder1/new_folder2/", "new_folder1/new_folder2/new_folder3/", "new_folder1/new_folder2/new_folder3/file3.txt"}, true);
        IResource[] resources = new IResource[]{project.getFolder("new_folder1/new_folder2/new_folder3/")};
        this.update(this.asResourceMapping(resources, 2), null);
        this.assertEquals(project, copy);
    }
}

