/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.mappings.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.tests.ccvs.core.mappings.model.ModelFile;
import org.eclipse.team.tests.ccvs.core.mappings.model.ModelObject;

public class ModelProject
extends ModelObject {
    public static boolean isModProject(IProject project) throws CoreException {
        if (!project.isOpen()) {
            return false;
        }
        IProjectDescription description = project.getDescription();
        return description.hasNature("org.eclipse.team.tests.cvs.core.bug302163_ModelNature");
    }

    public static void makeModProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natureIds = description.getNatureIds();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < natureIds.length) {
            result.add(natureIds[i]);
            ++i;
        }
        result.add("org.eclipse.team.tests.cvs.core.bug302163_ModelNature");
        description.setNatureIds(result.toArray(new String[result.size()]));
        project.setDescription(description, monitor);
    }

    public ModelProject(IProject project) {
        super((IResource)project);
    }

    protected IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    @Override
    public ModelObject[] getChildren() throws CoreException {
        IResource[] members = this.getContainer().members();
        ArrayList<ModelObject> result = new ArrayList<ModelObject>();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (ModelFile.isModFile(resource)) {
                result.add(new ModelFile((IFile)resource));
            } else if (resource instanceof IProject && ModelProject.isModProject((IProject)resource)) {
                result.add(new ModelProject((IProject)resource));
            }
            ++i;
        }
        return result.toArray(new ModelObject[result.size()]);
    }
}

