/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class ImportTest
extends EclipseTest {
    public ImportTest() {
    }

    public ImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ImportTest.class);
        return new CVSTestSetup((Test)suite);
    }

    protected void assertEquals(IContainer container1, IContainer container2) throws CoreException {
        ImportTest.assertEquals((String)container1.getName(), (String)container2.getName());
        ArrayList<IResource> members1 = new ArrayList<IResource>();
        members1.addAll(Arrays.asList(container1.members()));
        members1.remove(container1.findMember("CVS"));
        ArrayList<IResource> members2 = new ArrayList<IResource>();
        members2.addAll(Arrays.asList(container2.members()));
        members2.remove(container2.findMember("CVS"));
        ImportTest.assertTrue((members1.size() == members2.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < members1.size()) {
            IResource member1 = (IResource)members1.get(i);
            IResource member2 = container2.findMember(member1.getName());
            ImportTest.assertNotNull((Object)member2);
            this.assertEquals(member1, member2);
            ++i;
        }
    }

    protected void assertEquals(IFile file1, IFile file2) throws CoreException {
        ImportTest.assertEquals((String)file1.getName(), (String)file2.getName());
        ImportTest.assertTrue((boolean)this.compareContent(file1.getContents(), file2.getContents()));
    }

    @Override
    protected void assertEquals(IProject container1, IProject container2) throws CoreException {
        ArrayList<IResource> members1 = new ArrayList<IResource>();
        members1.addAll(Arrays.asList(container1.members()));
        members1.remove(container1.findMember(".project"));
        members1.remove(container1.findMember("CVS"));
        ArrayList<IResource> members2 = new ArrayList<IResource>();
        members2.addAll(Arrays.asList(container2.members()));
        members2.remove(container2.findMember(".project"));
        members2.remove(container2.findMember("CVS"));
        ImportTest.assertTrue((String)("Number of children differs for " + container1.getFullPath()), (members1.size() == members2.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < members1.size()) {
            IResource member1 = (IResource)members1.get(i);
            IResource member2 = container2.findMember(member1.getName());
            ImportTest.assertNotNull((Object)member2);
            this.assertEquals(member1, member2);
            ++i;
        }
    }

    protected void assertEquals(IResource resource1, IResource resource2) throws CoreException {
        ImportTest.assertEquals((int)resource1.getType(), (int)resource2.getType());
        if (resource1.getType() == 1) {
            this.assertEquals((IFile)resource1, (IFile)resource2);
        } else {
            this.assertEquals((IContainer)resource1, (IContainer)resource2);
        }
    }

    public void testImportAndCheckout() throws TeamException, CoreException {
        IProject project = this.getUniqueTestProject("testImport");
        this.buildResources((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        this.importProject(project);
        IProject copy = ImportTest.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + "Copy");
        ImportTest.checkout((ICVSRepositoryLocation)this.getRepository(), copy, project.getName(), null, DEFAULT_MONITOR);
        this.assertValidCheckout(copy);
        this.assertEquals(project, copy);
    }

    public void testCheckout() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testCheckout", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        project = this.checkoutProject(project, null, null);
        this.assertEquals(project, copy, true, true);
        ImportTest.waitForDecorator();
        project.delete(false, false, DEFAULT_MONITOR);
        project = this.checkoutProject(project, null, null);
        this.assertEquals(project, copy, true, true);
        ImportTest.waitForDecorator();
        project.delete(true, false, DEFAULT_MONITOR);
        project = this.checkoutProject(null, project.getName(), null);
        this.assertEquals(project, copy, true, true);
        ImportTest.waitForDecorator();
        project.delete(true, false, DEFAULT_MONITOR);
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        project.create(desc, DEFAULT_MONITOR);
        project = this.checkoutProject(project, null, null);
        this.assertEquals(project, copy, true, true);
        ImportTest.waitForDecorator();
        project.delete(true, false, DEFAULT_MONITOR);
        project = this.checkoutProject(null, String.valueOf(project.getName()) + "/folder1", null);
    }

    public void testRootShare() throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.buildResources((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        this.shareProject(this.getRepository(), project, null, DEFAULT_MONITOR);
        this.addResources((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        IProject copy = this.checkoutProject(this.getUniqueTestProject(String.valueOf(this.getName()) + "copy"), project.getName(), null);
        this.assertEquals(project, copy);
    }

    public void testNonRootShare() throws CoreException {
        IProject project = this.getUniqueTestProject(this.getName());
        this.buildResources((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        String moduleName = "root" + Long.toString(System.currentTimeMillis()) + "/" + project.getName();
        this.shareProject(this.getRepository(), project, moduleName, DEFAULT_MONITOR);
        this.addResources((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        IProject copy = this.checkoutProject(this.getUniqueTestProject(String.valueOf(this.getName()) + "copy"), moduleName, null);
        this.assertEquals(project, copy);
    }
}

