/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoSet;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;

public class SyncSetTests
extends CVSSyncSubscriberTest {
    public SyncSetTests() {
    }

    public SyncSetTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(SyncSetTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new SyncSetTests(testName));
    }

    public void testConcurrentAccessToSyncSet() throws Throwable {
        final SubscriberSyncInfoSet set = new SubscriberSyncInfoSet(null);
        final boolean[] done = new boolean[1];
        final IStatus[] error = new IStatus[1];
        int numJobs = 0;
        while (numJobs < 10) {
            Job job = new Job("SyncSetTests" + numJobs){

                public IStatus run(IProgressMonitor monitor) {
                    while (!done[0]) {
                        try {
                            set.add((SyncInfo)new TestSyncInfo());
                            set.getSyncInfos((IResource)ResourcesPlugin.getWorkspace().getRoot(), 2);
                            set.getSyncInfo((IResource)ResourcesPlugin.getWorkspace().getRoot());
                            set.getSyncInfos();
                        }
                        catch (Exception e) {
                            error[0] = new Status(4, "this", 1, "", (Throwable)e);
                            return error[0];
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult() != Status.OK_STATUS) {
                        error[0] = event.getResult();
                    }
                }
            });
            job.schedule();
            ++numJobs;
        }
        int i = 0;
        while (i < 10000) {
            set.add((SyncInfo)new TestSyncInfo());
            set.getSyncInfos((IResource)ResourcesPlugin.getWorkspace().getRoot(), 2);
            set.getSyncInfo((IResource)ResourcesPlugin.getWorkspace().getRoot());
            set.getSyncInfos();
            set.members((IResource)ResourcesPlugin.getWorkspace().getRoot());
            set.clear();
            ++i;
        }
        done[0] = true;
        if (error[0] != null) {
            throw error[0].getException();
        }
    }

    class TestSyncInfo
    extends SyncInfo {
        protected int calculateKind() throws TeamException {
            return 0;
        }

        public TestSyncInfo() throws TeamException {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot(), null, null, new IResourceVariantComparator(){

                public boolean compare(IResource local, IResourceVariant remote) {
                    return false;
                }

                public boolean compare(IResourceVariant base, IResourceVariant remote) {
                    return false;
                }

                public boolean isThreeWay() {
                    return false;
                }
            });
        }
    }
}

