/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.CVSRepositoryLocationMatcher;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.ConfigureRepositoryLocationsDialog;

public class CVSProjectSetImportTest
extends TestCase {
    private KnownRepositories knownRepositories;
    private ICVSRepositoryLocation[] savedRepositories;

    public CVSProjectSetImportTest() {
    }

    public CVSProjectSetImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(CVSProjectSetImportTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.knownRepositories = KnownRepositories.getInstance();
        this.savedRepositories = this.knownRepositories.getRepositories();
        int i = 0;
        while (i < this.savedRepositories.length) {
            this.knownRepositories.disposeRepository(this.savedRepositories[i]);
            ++i;
        }
    }

    public void testEmptyInfoMap() {
        IProject[] projects = new IProject[1];
        HashMap infoMap = new HashMap();
        Map alternativeMap = CVSRepositoryLocationMatcher.prepareSuggestedRepositoryLocations((IProject[])projects, infoMap);
        CVSProjectSetImportTest.assertNull((Object)alternativeMap);
        CVSProjectSetImportTest.assertEquals((int)0, (int)this.knownRepositories.getRepositories().length);
    }

    public void testEmptyReferenceStrings() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[0], new String[0], new String[][]{new String[0]});
    }

    public void testMalformedReferenceString() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[0], new String[]{"Hi, I'm a malformed reference string."}, new String[][]{new String[0]});
    }

    public void testUnknownSingleReferenceString() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[0], new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{{":pserver:dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testSelectionForUnknownSingleReferenceString() throws Exception {
        this._testDialogDefaultSelection(new String[0], new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse"});
    }

    public void testKnownSingleReferenceString() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{new String[0]});
    }

    public void testSingleKnownRepositoryWithUsername() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:extssh:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[][]{{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, {":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testSingleKnownRepositoryMatchesTwoReferenceStrings() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[][]{{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, {":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testOneMatchingReferenceString() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:extssh:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[][]{{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}, {":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testTwoMatchingKnownRepositories() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:joe@dev.eclipse.org:/cvsroot/eclipse", ":pserver:ann@dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{{":pserver:ann@dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testThreeKindsOfSuggestions() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse", ":pserver:localhost:/cvsroot/project"}, new String[]{"1.0,:extssh:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{{":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse", ":pserver:localhost:/cvsroot/project"}});
    }

    public void testOneCompatibleOfTwoKnown() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/TECHNOLOGY"}, new String[]{"1.0,:extssh:joe@dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{{":extssh:joe@dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/TECHNOLOGY"}});
    }

    public void testTwoUnknownOneCompatibleReferenceStrings() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":extssh:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:ext:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:pserver:dev.eclipse.org:/cvsroot/TECHNOLOGY,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[][]{{":ext:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse"}, {":pserver:dev.eclipse.org:/cvsroot/TECHNOLOGY", ":extssh:dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testSelectionForTwoUnknownOneCompatibleReferenceStrings() throws Exception {
        this._testDialogDefaultSelection(new String[]{":extssh:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:ext:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:pserver:dev.eclipse.org:/cvsroot/TECHNOLOGY,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[]{":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/TECHNOLOGY"});
    }

    public void testSelectionForOneCompatibleOfTwoKnown() throws Exception {
        this._testDialogDefaultSelection(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse", ":pserver:joe@dev.eclipse.org:/cvsroot/technology"}, new String[]{"1.0,:extssh:joe@dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse"});
    }

    public void testCompatibleSuggestionsOrder() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse", ":ext:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserverssh2:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh"}, new String[][]{{":pserverssh2:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse", ":ext:dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testSelectionForCompatibleSuggestionsOrder() throws Exception {
        this._testDialogDefaultSelection(new String[]{":ext:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserverssh2:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[]{":extssh:dev.eclipse.org:/cvsroot/eclipse"});
    }

    public void testCompatibleSuggestionsOrder2() throws Exception {
        this._testPrepareSuggestedRepositoryLocations(new String[]{":ext:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.cvs.ssh,org.eclipse.team.cvs.ssh", "1.0,:pserverssh2:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[][]{{":pserver:dev.eclipse.org:/cvsroot/eclipse"}, {":pserverssh2:dev.eclipse.org:/cvsroot/eclipse", ":extssh:dev.eclipse.org:/cvsroot/eclipse", ":pserver:dev.eclipse.org:/cvsroot/eclipse", ":ext:dev.eclipse.org:/cvsroot/eclipse"}});
    }

    public void testSelectionForOnlyOneReferenceStringNeedsAdditionalInfo() throws Exception {
        String[] stringArray = new String[2];
        stringArray[1] = ":pserver:dev.eclipse.org:/cvsroot/eclipse";
        this._testDialogDefaultSelection(new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core", "1.0,:extssh:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, stringArray);
    }

    public void testSelectionForUnknownReferenceString() throws Exception {
        this._testDialogDefaultSelection(new String[]{":pserver:LOCALHOST:/cvsroot/path"}, new String[]{"1.0,:pserver:dev.eclipse.org:/cvsroot/eclipse,org.eclipse.team.tests.cvs.core,org.eclipse.team.tests.cvs.core"}, new String[]{":pserver:dev.eclipse.org:/cvsroot/eclipse"});
    }

    private void _testPrepareSuggestedRepositoryLocations(String[] knownLocations, String[] referenceStrings, String[][] expectedSuggestions) throws Exception {
        int i = 0;
        while (i < knownLocations.length) {
            this.knownRepositories.addRepository((ICVSRepositoryLocation)CVSRepositoryLocation.fromString((String)knownLocations[i]), false);
            ++i;
        }
        HashMap infoMap = new HashMap(referenceStrings.length);
        IProject[] projects = CVSProjectSetCapability.asProjects((String[])referenceStrings, infoMap);
        Map suggestedRepositoryLocations = CVSRepositoryLocationMatcher.prepareSuggestedRepositoryLocations((IProject[])projects, infoMap);
        if (suggestedRepositoryLocations != null) {
            int i2 = 0;
            while (i2 < referenceStrings.length) {
                StringTokenizer st = new StringTokenizer(referenceStrings[i2], ",");
                st.nextToken();
                String locationString = st.nextToken();
                CVSRepositoryLocation referenceLocation = CVSRepositoryLocation.fromString((String)locationString);
                List suggestedList = (List)suggestedRepositoryLocations.get(referenceLocation);
                if (suggestedList == null) {
                    this.isItReallyAPerfectMatch((ICVSRepositoryLocation)referenceLocation);
                    CVSProjectSetImportTest.assertEquals((int)0, (int)expectedSuggestions[i2].length);
                } else {
                    CVSProjectSetImportTest.assertEquals((int)expectedSuggestions[i2].length, (int)suggestedList.size());
                    int j = 0;
                    while (j < expectedSuggestions[i2].length) {
                        ICVSRepositoryLocation actualSuggestion = (ICVSRepositoryLocation)suggestedList.get(j);
                        CVSRepositoryLocation expectedSuggestion = CVSRepositoryLocation.fromString((String)expectedSuggestions[i2][j]);
                        CVSProjectSetImportTest.assertEquals((ICVSRepositoryLocation)expectedSuggestion, actualSuggestion);
                        ++j;
                    }
                }
                ++i2;
            }
        }
        CVSProjectSetImportTest.assertEquals((int)knownLocations.length, (int)this.knownRepositories.getRepositories().length);
    }

    private static void assertEquals(ICVSRepositoryLocation expected, ICVSRepositoryLocation actual) {
        if (expected == actual) {
            return;
        }
        CVSProjectSetImportTest.assertTrue((String)("expected:<" + expected + "> but was:<" + actual + ">."), (boolean)expected.equals(actual));
        CVSProjectSetImportTest.assertEquals((String)("expected:<" + expected + "> but was:<" + actual + ">."), (String)expected.getLocation(true), (String)actual.getLocation(true));
    }

    private void _testDialogDefaultSelection(String[] knownLocations, String[] referenceStrings, String[] expectedSelections) throws Exception {
        int i = 0;
        while (i < knownLocations.length) {
            this.knownRepositories.addRepository((ICVSRepositoryLocation)CVSRepositoryLocation.fromString((String)knownLocations[i]), false);
            ++i;
        }
        HashMap infoMap = new HashMap(referenceStrings.length);
        IProject[] projects = CVSProjectSetCapability.asProjects((String[])referenceStrings, infoMap);
        Map alternativeMap = CVSRepositoryLocationMatcher.prepareSuggestedRepositoryLocations((IProject[])projects, infoMap);
        CVSProjectSetImportTest.assertFalse((boolean)alternativeMap.isEmpty());
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        ConfigureRepositoryLocationsDialog dialog = new ConfigureRepositoryLocationsDialog(shell, alternativeMap);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Map selected = dialog.getSelected();
        int i2 = 0;
        while (i2 < referenceStrings.length) {
            StringTokenizer st = new StringTokenizer(referenceStrings[i2], ",");
            st.nextToken();
            CVSRepositoryLocation referenceLocation = CVSRepositoryLocation.fromString((String)st.nextToken());
            ICVSRepositoryLocation selectedAlternativeRepository = (ICVSRepositoryLocation)selected.get(referenceLocation);
            if (expectedSelections[i2] == null) {
                this.isItReallyAPerfectMatch((ICVSRepositoryLocation)referenceLocation);
            } else {
                CVSRepositoryLocation expectedSelection = CVSRepositoryLocation.fromString((String)expectedSelections[i2]);
                CVSProjectSetImportTest.assertEquals((ICVSRepositoryLocation)expectedSelection, selectedAlternativeRepository);
            }
            ++i2;
        }
        dialog.getShell().dispose();
        dialog.close();
        dialog = null;
    }

    private void isItReallyAPerfectMatch(ICVSRepositoryLocation referenceLocation) {
        ICVSRepositoryLocation[] repositories = this.knownRepositories.getRepositories();
        boolean matchFound = false;
        int j = 0;
        while (j < repositories.length) {
            ICVSRepositoryLocation rl = repositories[j];
            if (CVSRepositoryLocationMatcher.isMatching((ICVSRepositoryLocation)referenceLocation, (ICVSRepositoryLocation)rl)) {
                CVSProjectSetImportTest.assertFalse((String)"There should be only one perfect match.", (boolean)matchFound);
                matchFound = true;
            }
            ++j;
        }
        CVSProjectSetImportTest.assertTrue((boolean)matchFound);
    }
}

