/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.ui.TestEditor;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTests
extends EclipseTest {
    public EditorTests() {
    }

    public EditorTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EditorTests.class);
        return new CVSTestSetup((Test)suite);
    }

    public void testOpenEditorOnRevision() throws CoreException, InvocationTargetException {
        IProject project = this.createProject(new String[]{"file.cvsTest"});
        IEditorPart localPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)project.getFile("file.cvsTest"));
        EditorTests.assertTrue((String)"The proper local editor was not opened", (boolean)(localPart instanceof TestEditor));
        ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("file.cvsTest"));
        IEditorPart part = CVSUIPlugin.getPlugin().openEditor(remoteFile, (IProgressMonitor)new NullProgressMonitor());
        EditorTests.assertTrue((String)"The proper remote editor was not opened", (!(part instanceof TestEditor) && part instanceof ITextEditor ? 1 : 0) != 0);
        EditorTests.assertNotNull((Object)Adapters.adapt((Object)part.getEditorInput(), IFileRevision.class));
        EditorTests.assertNotNull((Object)Adapters.adapt((Object)part.getEditorInput(), ICVSFile.class));
        EditorTests.assertNotNull((Object)Adapters.adapt((Object)part.getEditorInput(), IResourceVariant.class));
        EditorTests.assertNotNull((Object)Adapters.adapt((Object)part.getEditorInput(), IHistoryPageSource.class));
        EditorTests.assertNotNull((Object)Adapters.adapt((Object)part.getEditorInput(), IWorkbenchAdapter.class));
    }
}

