/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.AssertionFailedError;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.mapping.ShallowContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.provider.Diff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.mappings.CompareSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.mappings.MergeSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelCompareParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelMergeParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ModelSynchronizePage;
import org.eclipse.team.internal.ui.mapping.ResourceMarkAsMergedHandler;
import org.eclipse.team.internal.ui.mapping.ResourceMergeHandler;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshModelParticipantJob;
import org.eclipse.team.internal.ui.synchronize.SynchronizeView;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.ParticipantSyncInfoSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.junit.Assert;

public class ModelParticipantSyncInfoSource
extends ParticipantSyncInfoSource {
    public static ModelSynchronizeParticipant getParticipant(Subscriber subscriber) {
        ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < participants.length) {
            SubscriberMergeContext smc;
            ModelSynchronizeParticipant msp;
            ISynchronizationContext context;
            ISynchronizeParticipant participant;
            try {
                participant = participants[i].getParticipant();
            }
            catch (TeamException teamException) {
                return null;
            }
            if (participant instanceof ModelSynchronizeParticipant && (context = (msp = (ModelSynchronizeParticipant)participant).getContext()) instanceof SubscriberMergeContext && (smc = (SubscriberMergeContext)context).getSubscriber().equals(subscriber)) {
                return msp;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void assertSyncEquals(String message, Subscriber subscriber, IResource resource, int syncKind) throws CoreException {
        this.assertDiffKindEquals(message, subscriber, resource, SyncInfoToDiffConverter.asDiffFlags((int)syncKind));
    }

    @Override
    protected IDiff getDiff(Subscriber subscriber, IResource resource) throws CoreException {
        this.waitForCollectionToFinish(subscriber);
        IDiff subscriberDiff = subscriber.getDiff(resource);
        IDiff contextDiff = this.getContextDiff(subscriber, resource);
        this.assertDiffsEqual(subscriber, subscriberDiff, contextDiff);
        return contextDiff;
    }

    @Override
    public void refresh(Subscriber subscriber, IResource[] resources) throws TeamException {
        RefreshModelParticipantJob job = new RefreshModelParticipantJob((ISynchronizeParticipant)ModelParticipantSyncInfoSource.getParticipant(subscriber), "Refresh", "Refresh", Utils.getResourceMappings((Object[])resources), new IRefreshSubscriberListener(){

            public void refreshStarted(IRefreshEvent event) {
            }

            public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
                return null;
            }
        });
        job.schedule();
        this.waitForCollectionToFinish(subscriber);
        this.assertViewMatchesModel(subscriber);
    }

    public void waitForCollectionToFinish(Subscriber subscriber) {
        ModelSynchronizeParticipant family = ModelParticipantSyncInfoSource.getParticipant(subscriber);
        if (family == null) {
            while (this.waitUntilFamilyDone(subscriber)) {
            }
        } else {
            while (this.waitUntilFamilyDone(subscriber) || this.waitUntilFamilyDone(family) || this.waitUntilFamilyDone(family.getContext()) || this.waitUntilFamilyDone(family.getContext().getScope()) || this.waitUntilFamilyDone(((SynchronizationContext)family.getContext()).getScopeManager())) {
            }
        }
    }

    private boolean waitUntilFamilyDone(Object family) {
        if (family == null) {
            return false;
        }
        Job[] jobs = Job.getJobManager().find(family);
        boolean waited = false;
        int i = 0;
        while (i < jobs.length) {
            Job job = jobs[i];
            while (job.getState() != 0) {
                waited = true;
                while (Display.getCurrent().readAndDispatch()) {
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        return waited;
    }

    private void assertDiffsEqual(Subscriber subscriber, IDiff subscriberDiff, IDiff contextDiff) throws CoreException {
        int contextStatus;
        int subscriberStatus;
        if (subscriberDiff == null && contextDiff == null) {
            return;
        }
        if (subscriberDiff == null && contextDiff != null) {
            Assert.fail((String)("Subscriber contains no change for " + ResourceDiffTree.getResourceFor((IDiff)contextDiff).getFullPath().toString() + " but the context contains: " + contextDiff.toDiffString()));
        }
        if (subscriberDiff != null && contextDiff == null) {
            if (subscriber instanceof CVSCompareSubscriber && this.localContentsMatchRemote(subscriberDiff)) {
                return;
            }
            Assert.fail((String)("Subscriber contains change: " + subscriberDiff.toDiffString() + " for " + ResourceDiffTree.getResourceFor((IDiff)subscriberDiff).getFullPath().toString() + " but the context has no change"));
        }
        if ((subscriberStatus = ((Diff)subscriberDiff).getStatus()) != (contextStatus = ((Diff)subscriberDiff).getStatus())) {
            Assert.fail((String)("Subscriber contains change: " + subscriberDiff.toDiffString() + " for " + ResourceDiffTree.getResourceFor((IDiff)contextDiff).getFullPath().toString() + " but the context contains: " + contextDiff.toDiffString()));
        }
    }

    private boolean localContentsMatchRemote(IDiff subscriberDiff) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)subscriberDiff);
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            IFileRevision remote = SyncInfoToDiffConverter.getRemote((IDiff)subscriberDiff);
            return this.compareContent(file.getContents(), remote.getStorage(DEFAULT_MONITOR).getContents());
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public boolean compareContent(InputStream a, InputStream b) {
        int d;
        int c;
        block31: {
            if (a == null && b == null) {
                return true;
            }
            if (a != null && b != null) break block31;
            try {
                if (a != null) {
                    a.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        while ((c = a.read()) == (d = b.read()) && c != -1 && d != -1) {
        }
        boolean bl = c == -1 && d == -1;
        try {
            if (a != null) {
                a.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (b != null) {
                b.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (a != null) {
                        a.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (b != null) {
                        b.close();
                    }
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
            try {
                if (a != null) {
                    a.close();
                }
            }
            catch (IOException iOException4) {}
            try {
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException iOException5) {}
            return false;
        }
    }

    private IDiff getContextDiff(Subscriber subscriber, IResource resource) {
        ModelSynchronizeParticipant p = ModelParticipantSyncInfoSource.getParticipant(subscriber);
        return p.getContext().getDiffTree().getDiff(resource);
    }

    @Override
    protected SyncInfo getSyncInfo(Subscriber subscriber, IResource resource) throws TeamException {
        try {
            IDiff diff = this.getDiff(subscriber, resource);
            return this.getConverter(subscriber).asSyncInfo(diff, subscriber.getResourceComparator());
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    @Override
    protected void assertProjectRemoved(Subscriber subscriber, IProject project) throws TeamException {
        super.assertProjectRemoved(subscriber, project);
        this.waitForCollectionToFinish(subscriber);
        ModelSynchronizeParticipant participant = ModelParticipantSyncInfoSource.getParticipant(subscriber);
        IResourceDiffTree tree = participant.getContext().getDiffTree();
        if (tree.members((IResource)project).length > 0) {
            throw new AssertionFailedError("The diff tree still contains resources from the deleted project " + project.getName());
        }
    }

    private ISynchronizationScopeManager createScopeManager(IResource resource, Subscriber subscriber) {
        return new SubscriberScopeManager(subscriber.getName(), new ResourceMapping[]{Utils.getResourceMapping((Object)resource)}, subscriber, true);
    }

    private ISynchronizationScopeManager createWorkspaceScopeManager() {
        CVSWorkspaceSubscriber workspaceSubscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
        try {
            ModelProvider workspaceModel = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.core.resources.modelProvider").getModelProvider();
            return new SubscriberScopeManager(workspaceSubscriber.getName(), new ResourceMapping[]{Utils.getResourceMapping((Object)workspaceModel)}, (Subscriber)workspaceSubscriber, true);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    @Override
    public CVSMergeSubscriber createMergeSubscriber(IProject project, CVSTag root, CVSTag branch) {
        CVSMergeSubscriber mergeSubscriber = super.createMergeSubscriber(project, root, branch);
        ModelMergeParticipant participant = new ModelMergeParticipant(MergeSubscriberContext.createContext((ISynchronizationScopeManager)this.createScopeManager((IResource)project, (Subscriber)mergeSubscriber), (Subscriber)mergeSubscriber));
        this.showParticipant((ISynchronizeParticipant)participant);
        return mergeSubscriber;
    }

    @Override
    public Subscriber createWorkspaceSubscriber() throws TeamException {
        ISynchronizeManager synchronizeManager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] participants = synchronizeManager.get("org.eclipse.team.cvs.ui.workspace-participant");
        if (participants.length > 0) {
            Subscriber subscriber = ((SubscriberMergeContext)((WorkspaceModelParticipant)participants[0].getParticipant()).getContext()).getSubscriber();
            this.waitForCollectionToFinish(subscriber);
            return subscriber;
        }
        WorkspaceModelParticipant participant = new WorkspaceModelParticipant((SynchronizationContext)WorkspaceSubscriberContext.createContext((ISynchronizationScopeManager)this.createWorkspaceScopeManager(), (int)3));
        this.showParticipant((ISynchronizeParticipant)participant);
        Subscriber subscriber = super.createWorkspaceSubscriber();
        this.refresh(subscriber, subscriber.roots());
        return subscriber;
    }

    @Override
    public CVSCompareSubscriber createCompareSubscriber(IResource resource, CVSTag tag) {
        CVSCompareSubscriber s = super.createCompareSubscriber(resource, tag);
        ModelCompareParticipant participant = new ModelCompareParticipant(CompareSubscriberContext.createContext((ISynchronizationScopeManager)this.createScopeManager(resource, (Subscriber)s), (CVSCompareSubscriber)s));
        this.showParticipant((ISynchronizeParticipant)participant);
        return s;
    }

    @Override
    public void disposeSubscriber(Subscriber subscriber) {
        ModelSynchronizeParticipant participant = ModelParticipantSyncInfoSource.getParticipant(subscriber);
        ISynchronizeManager synchronizeManager = TeamUI.getSynchronizeManager();
        synchronizeManager.removeSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
    }

    @Override
    public void mergeResources(Subscriber subscriber, IResource[] resources, boolean allowOverwrite) throws TeamException {
        this.internalMergeResources(subscriber, resources, false);
        if (allowOverwrite) {
            this.internalMergeResources(subscriber, resources, true);
            try {
                this.assertInSync(subscriber, resources);
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
    }

    private void assertInSync(Subscriber subscriber, IResource[] resources) throws CoreException {
        this.waitForCollectionToFinish(subscriber);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.assertSyncEquals("merge failed", subscriber, resource, 0);
            ++i;
        }
    }

    private void internalMergeResources(Subscriber subscriber, IResource[] resources, boolean allowOverwrite) throws TeamException {
        ResourceMergeHandler handler = new ResourceMergeHandler(this.getConfiguration(subscriber), allowOverwrite){

            protected boolean promptToConfirm() {
                return true;
            }

            protected void promptForNoChanges() {
            }
        };
        handler.updateEnablement((IStructuredSelection)new StructuredSelection((Object[])this.asResourceMappings(resources)));
        try {
            handler.execute(new ExecutionEvent(null, Collections.EMPTY_MAP, null, null));
        }
        catch (ExecutionException e) {
            throw new TeamException("Error running merge", (Throwable)e);
        }
        this.waitForCollectionToFinish(subscriber);
    }

    @Override
    public void markAsMerged(Subscriber subscriber, IResource[] resources) throws InvocationTargetException, InterruptedException, TeamException {
        ResourceMarkAsMergedHandler handler = new ResourceMarkAsMergedHandler(this.getConfiguration(subscriber));
        handler.updateEnablement((IStructuredSelection)new StructuredSelection((Object[])resources));
        try {
            handler.execute(new ExecutionEvent(null, Collections.EMPTY_MAP, null, null));
        }
        catch (ExecutionException e) {
            throw new TeamException("Error running markAsMerged", (Throwable)e);
        }
        this.waitForCollectionToFinish(subscriber);
    }

    @Override
    public void updateResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        this.mergeResources(subscriber, resources, false);
    }

    @Override
    public void overrideAndUpdateResources(Subscriber subscriber, boolean shouldPrompt, IResource[] resources) throws CoreException {
        this.mergeResources(subscriber, resources, true);
    }

    @Override
    public void commitResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        try {
            new CommitWizard.AddAndCommitOperation(null, this.getChangedFiles(subscriber, resources), this.getNewResources(subscriber, resources), "").run(DEFAULT_MONITOR);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Assert.fail();
        }
    }

    private IResource[] getChangedFiles(Subscriber subscriber, IResource[] resources) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IDiff diff;
            IResource resource = resources[i];
            if (resource.getType() == 1 && (diff = subscriber.getDiff(resource)) != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private IResource[] getNewResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IThreeWayDiff twd;
            IResource resource = resources[i];
            IDiff diff = subscriber.getDiff(resource);
            if (diff instanceof IThreeWayDiff && (twd = (IThreeWayDiff)diff).getKind() == 1 && twd.getDirection() == 256 && !CVSWorkspaceRoot.getCVSResourceFor((IResource)resource).isManaged()) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private ResourceMapping[] asResourceMappings(IResource[] resources) {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                result.add(Utils.getResourceMapping((Object)resource));
            } else {
                result.add(new ZeroDepthResourceMapping(new ZeroDepthContainer((IContainer)resource)));
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    @Override
    public void overrideAndCommitResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        try {
            this.markAsMerged(subscriber, resources);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"unexpected interrupt");
        }
        this.commitResources(subscriber, resources);
    }

    public ISynchronizePageConfiguration getConfiguration(Subscriber subscriber) {
        ModelSynchronizePage page = this.getPage(subscriber);
        return page.getConfiguration();
    }

    private ModelSynchronizePage getPage(Subscriber subscriber) {
        try {
            ModelSynchronizeParticipant participant = ModelParticipantSyncInfoSource.getParticipant(subscriber);
            if (participant == null) {
                throw new AssertionFailedError("The participant for " + subscriber.getName() + " could not be retrieved");
            }
            IWorkbenchPage activePage = TeamUIPlugin.getActivePage();
            ISynchronizeView view = (ISynchronizeView)activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
            IPage page = ((SynchronizeView)view).getPage((ISynchronizeParticipant)participant);
            if (page instanceof ModelSynchronizePage) {
                ModelSynchronizePage subscriberPage = (ModelSynchronizePage)page;
                return subscriberPage;
            }
        }
        catch (PartInitException partInitException) {
            throw new AssertionFailedError("Cannot show sync view in active page");
        }
        throw new AssertionFailedError("The page for " + subscriber.getName() + " could not be retrieved");
    }

    @Override
    public void assertViewMatchesModel(Subscriber subscriber) {
        this.waitForCollectionToFinish(subscriber);
        TreeItem[] rootItems = this.getTreeItems(subscriber);
        ModelSynchronizeParticipant p = ModelParticipantSyncInfoSource.getParticipant(subscriber);
        ResourceDiffTree tree = (ResourceDiffTree)p.getContext().getDiffTree();
        ResourceDiffTree copy = new ResourceDiffTree();
        IDiff[] diffs = tree.getDiffs();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            copy.add(diff);
            ++i;
        }
        this.assertTreeMatchesDiffs(rootItems, copy);
    }

    private void assertTreeMatchesDiffs(TreeItem[] rootItems, ResourceDiffTree copy) {
        this.assertItemsInDiffTree(rootItems, copy);
        if (!copy.isEmpty()) {
            new AssertionFailedError("Viewer is not showing all diffs");
        }
    }

    private void assertItemsInDiffTree(TreeItem[] items, ResourceDiffTree copy) {
        if (items == null || items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            this.assertItemInTree(item, copy);
            ++i;
        }
    }

    private void assertItemInTree(TreeItem item, ResourceDiffTree copy) {
        Object element = item.getData();
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            if (copy.getDiff(resource) != null) {
                copy.remove(resource);
            } else if (copy.getChildren(resource.getFullPath()).length == 0) {
                if (CVSTestSetup.FAIL_ON_BAD_DIFF) {
                    throw new AssertionFailedError("Resource" + resource.getFullPath() + " is in the view but not in the diff tree");
                }
                System.out.println("Resource" + resource.getFullPath() + " is in the view but not in the diff tree");
                new Exception().printStackTrace();
                return;
            }
            this.assertItemsInDiffTree(item.getItems(), copy);
        }
    }

    private TreeItem[] getTreeItems(Subscriber subscriber) {
        ModelSynchronizePage page = this.getPage(subscriber);
        Viewer v = page.getViewer();
        if (v instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)v;
            treeViewer.expandAll();
            Tree t = treeViewer.getTree();
            return t.getItems();
        }
        throw new AssertionFailedError("The tree for " + subscriber.getName() + " could not be retrieved");
    }

    public class ZeroDepthContainer
    extends PlatformObject {
        private IContainer container;

        public ZeroDepthContainer(IContainer container) {
            this.container = container;
        }

        public IContainer getResource() {
            return this.container;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShallowContainer) {
                ZeroDepthContainer other = (ZeroDepthContainer)((Object)obj);
                return other.getResource().equals((Object)this.getResource());
            }
            return false;
        }

        public int hashCode() {
            return this.getResource().hashCode();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IResource.class || adapter == IContainer.class) {
                return this.container;
            }
            return super.getAdapter(adapter);
        }
    }

    public class ZeroDepthResourceMapping
    extends ResourceMapping {
        private final ZeroDepthContainer container;

        public ZeroDepthResourceMapping(ZeroDepthContainer container) {
            this.container = container;
        }

        public Object getModelObject() {
            return this.container;
        }

        public String getModelProviderId() {
            return "org.eclipse.core.resources.modelProvider";
        }

        public IProject[] getProjects() {
            return new IProject[]{this.container.getResource().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.container.getResource()}, 0, 0)};
        }

        public boolean contains(ResourceMapping mapping) {
            if (mapping.getModelProviderId().equals(this.getModelProviderId())) {
                Object object = mapping.getModelObject();
                IContainer resource = this.container.getResource();
                if (object instanceof ShallowContainer) {
                    ZeroDepthContainer sc = (ZeroDepthContainer)((Object)object);
                    return sc.getResource().equals((Object)resource);
                }
                if (object instanceof IResource) {
                    IResource other = (IResource)object;
                    return other.equals((Object)resource);
                }
            }
            return false;
        }
    }
}

