/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.SynchronizeView;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;

public class ParticipantSyncInfoSource
extends SyncInfoSource {
    public static ISynchronizePage getSyncViewPage(ISynchronizeParticipant participant) throws PartInitException {
        IWorkbenchPage activePage = TeamUIPlugin.getActivePage();
        ISynchronizeView view = (ISynchronizeView)activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
        IPage page = ((SynchronizeView)view).getPage(participant);
        return (ISynchronizePage)page;
    }

    public ParticipantSyncInfoSource() {
        IWorkbenchPage activePage = TeamUIPlugin.getActivePage();
        try {
            activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
        }
        catch (PartInitException partInitException) {
            throw new AssertionFailedError("Cannot show sync view in active page");
        }
    }

    protected SyncInfoToDiffConverter getConverter(Subscriber subscriber) {
        SyncInfoToDiffConverter converter = (SyncInfoToDiffConverter)Adapters.adapt((Object)subscriber, SyncInfoToDiffConverter.class);
        if (converter == null) {
            converter = SyncInfoToDiffConverter.getDefault();
        }
        return converter;
    }

    @Override
    public void tearDown() {
        ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < participants.length) {
            try {
                ISynchronizeParticipantReference ref = participants[i];
                if (ref.getParticipant().getId().equals("org.eclipse.team.cvs.ui.cvsmerge-participant")) {
                    TeamUI.getSynchronizeManager().removeSynchronizeParticipants(new ISynchronizeParticipant[]{ref.getParticipant()});
                }
            }
            catch (TeamException teamException) {
                return;
            }
            ++i;
        }
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    protected void showParticipant(ISynchronizeParticipant participant) throws AssertionFailedError {
        ISynchronizeManager synchronizeManager = TeamUI.getSynchronizeManager();
        synchronizeManager.addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        IWorkbenchPage activePage = TeamUIPlugin.getActivePage();
        try {
            ISynchronizeView view = (ISynchronizeView)activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
            view.display(participant);
        }
        catch (PartInitException partInitException) {
            throw new AssertionFailedError("Cannot show sync view in active page");
        }
    }

    public void assertViewMatchesModel(Subscriber subscriber) {
    }

    @Override
    public void refresh(Subscriber subscriber, IResource[] resources) throws TeamException {
        super.refresh(subscriber, resources);
        this.assertViewMatchesModel(subscriber);
    }
}

