/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.mapping.CVSActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelSorter;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementSorter;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.TreeViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PatchTreeTest
extends EclipseTest {
    public void testChangeSetModelSorter() throws CoreException {
        MyTreeViewer tree = new MyTreeViewer();
        tree.init();
        ViewerSorter sorter = tree.getSorter();
        UnchangedResourceModelElement elementZ = new UnchangedResourceModelElement(null, (IResource)this.getUniqueTestProject("z"));
        ChangeSetDiffNode nodeA = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "a"));
        ChangeSetDiffNode nodeB = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "b"));
        ChangeSetDiffNode nodeC = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "c"));
        Object[] elements = new Object[]{nodeB, nodeC, elementZ, nodeA};
        sorter.sort((Viewer)tree, elements);
        PatchTreeTest.assertEquals((Object)nodeA, (Object)elements[0]);
        PatchTreeTest.assertEquals((Object)nodeB, (Object)elements[1]);
        PatchTreeTest.assertEquals((Object)nodeC, (Object)elements[2]);
        PatchTreeTest.assertEquals((Object)elementZ, (Object)elements[3]);
    }

    public void testDuplicatedElementsInPatchTree() throws TeamException, CoreException {
        MyTreeViewer tree = new MyTreeViewer();
        tree.init();
        UnchangedResourceModelElement element = new UnchangedResourceModelElement(null, (IResource)this.getUniqueTestProject("z"));
        ChangeSetDiffNode nodeA = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "a"));
        ChangeSetDiffNode nodeB = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "b"));
        ChangeSetDiffNode nodeC = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "c"));
        ChangeSetDiffNode nodeD = new ChangeSetDiffNode(null, (ChangeSet)new CVSActiveChangeSet(null, "d"));
        Item[] treeChildren = tree.testGetChildren((Widget)tree.getTree());
        PatchTreeTest.assertEquals((int)0, (int)treeChildren.length);
        Object[] children = new Object[]{nodeC, nodeB, element, nodeA};
        tree.testInternalAdd(children);
        treeChildren = tree.testGetChildren((Widget)tree.getTree());
        PatchTreeTest.assertEquals((int)children.length, (int)treeChildren.length);
        Object[] childrenToAdd = new Object[]{nodeD, element, nodeA, nodeB};
        tree.testInternalAdd(childrenToAdd);
        treeChildren = tree.testGetChildren((Widget)tree.getTree());
        Object[] expected = new Object[]{nodeC, nodeB, element, nodeA, nodeD};
        PatchTreeTest.assertEquals((int)expected.length, (int)treeChildren.length);
        int i = 0;
        while (i < treeChildren.length) {
            PatchTreeTest.assertEquals((int)1, (int)this.countByData(treeChildren, treeChildren[i]));
            ++i;
        }
    }

    private int countByData(Item[] a, Item o) {
        int c = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i].getData() == o.getData()) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    private SynchronizePageConfiguration getMyConfiguration(final Viewer viewer) {
        SynchronizePageConfiguration conf = new SynchronizePageConfiguration(null);
        conf.setPage(new ISynchronizePage(){

            public void init(ISynchronizePageSite site) throws PartInitException {
            }

            public Viewer getViewer() {
                return viewer;
            }

            public boolean aboutToChangeProperty(ISynchronizePageConfiguration configuration, String key, Object newValue) {
                return false;
            }
        });
        return conf;
    }

    public static Test suite() {
        return PatchTreeTest.suite(PatchTreeTest.class);
    }

    private class MyModelProvider
    extends ChangeSetModelProvider
    implements IPropertyChangeListener {
        public ChangeSetCapability getChangeSetCapability() {
            return new ChangeSetCapability(){};
        }

        public MyModelProvider(Viewer viewer) {
            super((ISynchronizePageConfiguration)PatchTreeTest.this.getMyConfiguration(viewer), new SyncInfoSet(), "sampleProviderId");
            this.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    private class MyTreeViewer
    extends TreeViewerAdvisor.NavigableCheckboxTreeViewer {
        public MyTreeViewer() {
            super(new Composite((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0), 770);
        }

        public void testInternalAdd(Object[] childElements) {
            this.internalAdd((Widget)this.getTree(), null, childElements);
        }

        public Item[] testGetChildren(Widget widget) {
            return this.getChildren(widget);
        }

        public void init() {
            MyModelProvider provider = new MyModelProvider((Viewer)this);
            provider.setViewerSorter((ViewerSorter)new SynchronizeModelElementSorter());
            ChangeSetModelSorter sorter = new ChangeSetModelSorter((ChangeSetModelProvider)provider, 0);
            this.setSorter((ViewerSorter)sorter);
        }
    }
}

