/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.ui.model.AllRootsElement;
import org.eclipse.team.internal.ccvs.ui.model.BranchCategory;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.team.internal.ccvs.ui.model.VersionCategory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class RepositoriesViewTests
extends EclipseTest {
    public RepositoriesViewTests(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        RepositoryRoot repositoryRoot = this.getRepositoryRoot();
        String[] remotePaths = repositoryRoot.getKnownRemotePaths();
        int i = 0;
        while (i < remotePaths.length) {
            repositoryRoot.removeTags(remotePaths[i], repositoryRoot.getAllKnownTags(remotePaths[i]));
            ++i;
        }
    }

    private RepositoryRoot getRepositoryRoot() {
        RemoteContentProvider rcp = new RemoteContentProvider();
        AllRootsElement are = new AllRootsElement();
        Object[] repositoryRoots = rcp.getElements((Object)are);
        int i = 0;
        while (i < repositoryRoots.length) {
            RepositoryRoot repositoryRoot = (RepositoryRoot)repositoryRoots[i];
            if (this.getRepository().equals((Object)repositoryRoot.getRoot())) {
                return repositoryRoot;
            }
            ++i;
        }
        RepositoriesViewTests.fail((String)(this.getRepository() + " not found"));
        return null;
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(RepositoriesViewTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new RepositoriesViewTests(testName));
    }

    public void testBranchSubmoduleChildren() throws TeamException, CoreException {
        String time = Long.toString(System.currentTimeMillis());
        String moduleName = "TestBranchSubmoduleChildrenTestModule" + time;
        String branchName = "TestBranchSubmoduleChildrenBranch" + time;
        String versionName = "Root_" + branchName;
        IProject project = this.getUniqueTestProject("TestBranchSubmoduleChildrenProject");
        this.shareProject(this.getRepository(), project, String.valueOf(moduleName) + "/" + project.getName(), DEFAULT_MONITOR);
        this.assertValidCheckout(project);
        this.addResources((IContainer)project, new String[]{"file1.txt"}, true);
        CVSTag version = new CVSTag(versionName, 2);
        CVSTag branch = new CVSTag(branchName, 1);
        this.makeBranch(new IResource[]{project}, version, branch, true);
        RemoteContentProvider rcp = new RemoteContentProvider();
        Object[] categories = rcp.getChildren((Object)this.getRepositoryRoot());
        RepositoriesViewTests.assertEquals((int)4, (int)categories.length);
        RepositoriesViewTests.assertTrue((boolean)(categories[1] instanceof BranchCategory));
        Object[] branches = rcp.getChildren(categories[1]);
        RepositoriesViewTests.assertEquals((int)1, (int)branches.length);
        RepositoriesViewTests.assertEquals((String)branchName, (String)((CVSTagElement)branches[0]).getTag().getName());
        Object[] modules = rcp.getChildren(branches[0]);
        RepositoriesViewTests.assertEquals((int)1, (int)modules.length);
        RepositoriesViewTests.assertEquals((String)moduleName, (String)((RemoteResource)modules[0]).getName());
        branches = rcp.getChildren(categories[1]);
        RepositoriesViewTests.assertEquals((int)1, (int)branches.length);
        RepositoriesViewTests.assertEquals((String)branchName, (String)((CVSTagElement)branches[0]).getTag().getName());
        modules = rcp.getChildren(branches[0]);
        RepositoriesViewTests.assertEquals((int)1, (int)modules.length);
        RepositoriesViewTests.assertEquals((String)moduleName, (String)((RemoteResource)modules[0]).getName());
    }

    public void testTagSubmoduleChildren() throws TeamException, CoreException {
        String time = Long.toString(System.currentTimeMillis());
        String moduleName = "TestTagSubmoduleChildrenTestModule" + time;
        String versionName = "TestTagSubmoduleChildrenBranch" + time;
        IProject project = this.getUniqueTestProject("TestTagSubmoduleChildrenProject");
        this.shareProject(this.getRepository(), project, String.valueOf(moduleName) + "/" + project.getName(), DEFAULT_MONITOR);
        this.assertValidCheckout(project);
        this.addResources((IContainer)project, new String[]{"file1.txt"}, true);
        CVSTag tag = new CVSTag(versionName, 2);
        this.tagProject(project, tag, true);
        RemoteContentProvider rcp = new RemoteContentProvider();
        Object[] categories = rcp.getChildren((Object)this.getRepositoryRoot());
        RepositoriesViewTests.assertEquals((int)4, (int)categories.length);
        RepositoriesViewTests.assertTrue((boolean)(categories[2] instanceof VersionCategory));
        Object[] modules = rcp.getChildren(categories[2]);
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof RemoteModule && ((RemoteModule)modules[i]).getCVSResource().getName().equals(moduleName)) {
                Object[] folders = rcp.getChildren(modules[i]);
                RepositoriesViewTests.assertEquals((int)1, (int)folders.length);
                RepositoriesViewTests.assertEquals((String)versionName, (String)((RemoteFolder)folders[0]).getTag().getName());
                return;
            }
            ++i;
        }
        RepositoriesViewTests.fail((String)(String.valueOf(moduleName) + " not found"));
    }

    public void testTagsOnDifferentLevels() throws CoreException {
        CVSTagElement branch2Element;
        CVSTagElement branch1Element;
        String time = Long.toString(System.currentTimeMillis());
        String firstModule = "Module_1" + time;
        String secondModule = "Module_2" + time;
        String secondModulePath = String.valueOf(firstModule) + "/" + secondModule;
        IProject project1 = this.getUniqueTestProject("Project_1");
        this.shareProject(this.getRepository(), project1, String.valueOf(firstModule) + "/" + project1.getName(), DEFAULT_MONITOR);
        IProject project2 = this.getUniqueTestProject("Project_2");
        this.shareProject(this.getRepository(), project2, String.valueOf(secondModulePath) + "/" + project2.getName(), DEFAULT_MONITOR);
        IProject project3 = this.getUniqueTestProject("Project_3");
        this.shareProject(this.getRepository(), project3, String.valueOf(secondModulePath) + "/" + project3.getName(), DEFAULT_MONITOR);
        IProject project4 = this.getUniqueTestProject("Project_4");
        this.shareProject(this.getRepository(), project4, String.valueOf(firstModule) + "/" + project4.getName(), DEFAULT_MONITOR);
        String branch1 = "Branch_1" + time;
        String version1 = "Root_" + branch1;
        String branch2 = "Branch_2" + time;
        String version2 = "Root_" + branch2;
        this.makeBranch(new IResource[]{project1, project2}, new CVSTag(version1, 2), new CVSTag(branch1, 1), true);
        this.makeBranch(new IResource[]{project1, project2, project2, project4}, new CVSTag(version2, 2), new CVSTag(branch2, 1), true);
        RemoteContentProvider rcp = new RemoteContentProvider();
        Object[] categories = rcp.getChildren((Object)this.getRepositoryRoot());
        RepositoriesViewTests.assertEquals((int)4, (int)categories.length);
        RepositoriesViewTests.assertTrue((boolean)(categories[1] instanceof BranchCategory));
        Object[] branches = rcp.getChildren(categories[1]);
        RepositoriesViewTests.assertEquals((int)2, (int)branches.length);
        if (((CVSTagElement)branches[0]).getTag().getName().equals(branch1)) {
            branch1Element = (CVSTagElement)branches[0];
            branch2Element = (CVSTagElement)branches[1];
        } else {
            branch1Element = (CVSTagElement)branches[1];
            branch2Element = (CVSTagElement)branches[0];
        }
        Object[] modules = rcp.getChildren((Object)branch1Element);
        RepositoriesViewTests.assertEquals((int)1, (int)modules.length);
        RepositoriesViewTests.assertEquals((String)firstModule, (String)((RemoteResource)modules[0]).getName());
        modules = rcp.getChildren(modules[0]);
        RepositoriesViewTests.assertEquals((int)2, (int)modules.length);
        int i = 0;
        while (i < modules.length) {
            if (((RemoteResource)modules[i]).getName().equals(project1.getName())) {
                RepositoriesViewTests.assertTrue((boolean)rcp.hasChildren(modules[i]));
            } else if (((RemoteResource)modules[i]).getName().equals(secondModule)) {
                Object[] module2Children = rcp.getChildren(modules[i]);
                RepositoriesViewTests.assertEquals((int)1, (int)module2Children.length);
                RepositoriesViewTests.assertEquals((String)project2.getName(), (String)((RemoteResource)module2Children[0]).getName());
            }
            ++i;
        }
        modules = rcp.getChildren((Object)branch2Element);
        RepositoriesViewTests.assertEquals((int)1, (int)modules.length);
        RepositoriesViewTests.assertEquals((String)firstModule, (String)((RemoteResource)modules[0]).getName());
        modules = rcp.getChildren(modules[0]);
        RepositoriesViewTests.assertEquals((int)3, (int)modules.length);
    }
}

