/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.ui.SelectionPropertyTester;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.CommitAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.EnablementTest;
import org.eclipse.ui.IActionDelegate;

public class SelectionPropertyTesterTest
extends EnablementTest {
    public SelectionPropertyTesterTest() {
    }

    public SelectionPropertyTesterTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SelectionPropertyTesterTest.class);
        return new CVSTestSetup((Test)suite);
    }

    public void testSelectionPropertyTester_allNulls() {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)tester.test(null, null, null, null));
    }

    public void testSelectionPropertyTester_nullSelection() {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)tester.test(null, "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null));
    }

    public void testSelectionPropertyTester_invalidClassForSelection() throws TeamException, CoreException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)tester.test((Object)resources, "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null));
    }

    public void testSelectionPropertyTester_toManyArgs() throws TeamException, CoreException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction", "org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction"}, null));
    }

    public void testSelectionPropertyTester_unknownProperty() throws TeamException, CoreException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)tester.test((Object)this.asSelection(resources), "unknownProperty", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null));
    }

    public void testSelectionPropertyTester_commitActionManaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)true, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_ignoreActionManaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        IgnoreAction action = new IgnoreAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_branchActionManaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        BranchAction action = new BranchAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getManagedResources(project, false, false);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.BranchAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)true, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_commitActionUnmanaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getUnmanagedResources(project);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)true, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_ignoreActionUnmanaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        IgnoreAction action = new IgnoreAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getUnmanagedResources(project);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)true, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_branchActionUnmanaged() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        BranchAction action = new BranchAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        List resources = this.getUnmanagedResources(project);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.BranchAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_commitActionUnshared() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        CommitAction action = new CommitAction();
        String actionName = this.getName((IActionDelegate)action);
        String[] resourcesNames = new String[]{"file.txt", "folder1/", "folder1/a.txt"};
        IProject project = this.getUniqueTestProject(actionName);
        IResource[] buildResources = this.buildResources((IContainer)project, resourcesNames, true);
        List<IResource> resources = Arrays.asList(buildResources);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.CommitAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_ignoreActionUnshared() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        IgnoreAction action = new IgnoreAction();
        String actionName = this.getName((IActionDelegate)action);
        String[] resourcesNames = new String[]{"file.txt", "folder1/", "folder1/a.txt"};
        IProject project = this.getUniqueTestProject(actionName);
        IResource[] buildResources = this.buildResources((IContainer)project, resourcesNames, true);
        List<IResource> resources = Arrays.asList(buildResources);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }

    public void testSelectionPropertyTester_branchActionUnshared() throws CoreException, TeamException {
        SelectionPropertyTester tester = new SelectionPropertyTester();
        BranchAction action = new BranchAction();
        String actionName = this.getName((IActionDelegate)action);
        String[] resourcesNames = new String[]{"file.txt", "folder1/", "folder1/a.txt"};
        IProject project = this.getUniqueTestProject(actionName);
        IResource[] buildResources = this.buildResources((IContainer)project, resourcesNames, true);
        List<IResource> resources = Arrays.asList(buildResources);
        boolean testResult = tester.test((Object)this.asSelection(resources), "isEnabled", new Object[]{"org.eclipse.team.internal.ccvs.ui.actions.BranchAction"}, null);
        SelectionPropertyTesterTest.assertEquals((boolean)false, (boolean)testResult);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), testResult);
    }
}

