/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import junit.framework.AssertionFailedError;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.MergeSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelManager;
import org.eclipse.team.internal.ui.synchronize.SynchronizeView;
import org.eclipse.team.internal.ui.synchronize.TreeViewerAdvisor;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.ui.ParticipantSyncInfoSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;

public class SubscriberParticipantSyncInfoSource
extends ParticipantSyncInfoSource {
    @Override
    public SyncInfo getSyncInfo(Subscriber subscriber, IResource resource) throws TeamException {
        SubscriberParticipantSyncInfoSource.getCollector(subscriber);
        SyncInfo info = this.internalGetSyncInfo(subscriber, resource);
        if (info == null) {
            info = subscriber.getSyncInfo(resource);
            if (info != null && info.getKind() != 0) {
                throw new AssertionFailedError("Sync state for " + resource.getFullPath() + " was " + SyncInfo.kindToString((int)info.getKind()) + " but resource was not collected");
            }
        } else {
            SyncInfo realInfo = subscriber.getSyncInfo(resource);
            if (info.getKind() != realInfo.getKind()) {
                throw new AssertionFailedError("Collected sync state for " + resource.getFullPath() + " was " + SyncInfo.kindToString((int)info.getKind()) + " but the real state was " + SyncInfo.kindToString((int)realInfo.getKind()));
            }
        }
        return info;
    }

    @Override
    public IDiff getDiff(Subscriber subscriber, IResource resource) throws CoreException {
        SyncInfo info = this.getSyncInfo(subscriber, resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        return this.getConverter(subscriber).getDeltaFor(info);
    }

    public static SubscriberParticipant getParticipant(Subscriber subscriber) {
        ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < participants.length) {
            ISynchronizeParticipant participant;
            try {
                participant = participants[i].getParticipant();
            }
            catch (TeamException teamException) {
                return null;
            }
            if (participant instanceof SubscriberParticipant && ((SubscriberParticipant)participant).getSubscriber() == subscriber) {
                return (SubscriberParticipant)participant;
            }
            ++i;
        }
        return null;
    }

    public static SubscriberSyncInfoCollector getCollector(Subscriber subscriber) {
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(subscriber);
        if (participant == null) {
            return null;
        }
        SubscriberSyncInfoCollector syncInfoCollector = participant.getSubscriberSyncInfoCollector();
        EclipseTest.waitForSubscriberInputHandling(syncInfoCollector);
        SubscriberParticipantPage page = SubscriberParticipantSyncInfoSource.getPage(subscriber);
        SynchronizeModelManager manager = (SynchronizeModelManager)page.getConfiguration().getProperty("org.eclipse.team.ui.P_MODEL_MANAGER");
        AbstractSynchronizeModelProvider provider = (AbstractSynchronizeModelProvider)manager.getActiveModelProvider();
        provider.waitUntilDone(new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
        });
        return syncInfoCollector;
    }

    @Override
    protected void assertProjectRemoved(Subscriber subscriber, IProject project) throws TeamException {
        super.assertProjectRemoved(subscriber, project);
        SyncInfoTree set = SubscriberParticipantSyncInfoSource.getCollector(subscriber).getSyncInfoSet();
        if (set.hasMembers((IResource)project)) {
            throw new AssertionFailedError("The sync set still contains resources from the deleted project " + project.getName());
        }
    }

    @Override
    public CVSMergeSubscriber createMergeSubscriber(IProject project, CVSTag root, CVSTag branch, boolean isModelSync) {
        CVSMergeSubscriber mergeSubscriber = super.createMergeSubscriber(project, root, branch, isModelSync);
        MergeSynchronizeParticipant participant = new MergeSynchronizeParticipant(mergeSubscriber);
        this.showParticipant((ISynchronizeParticipant)participant);
        return mergeSubscriber;
    }

    @Override
    public Subscriber createWorkspaceSubscriber() throws TeamException {
        ISynchronizeManager synchronizeManager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] participants = synchronizeManager.get("org.eclipse.team.cvs.ui.cvsworkspace-participant");
        if (participants.length > 0) {
            return ((SubscriberParticipant)participants[0].getParticipant()).getSubscriber();
        }
        WorkspaceSynchronizeParticipant participant = new WorkspaceSynchronizeParticipant((ISynchronizeScope)new WorkspaceScope());
        this.showParticipant((ISynchronizeParticipant)participant);
        return participant.getSubscriber();
    }

    @Override
    public CVSCompareSubscriber createCompareSubscriber(IResource resource, CVSTag tag) {
        CVSCompareSubscriber s = super.createCompareSubscriber(resource, tag);
        CompareParticipant participant = new CompareParticipant(s);
        this.showParticipant((ISynchronizeParticipant)participant);
        return s;
    }

    private SyncInfo internalGetSyncInfo(Subscriber subscriber, IResource resource) {
        ISynchronizeModelElement root = this.getModelRoot(subscriber);
        return this.findSyncInfo(root, resource);
    }

    private SyncInfo findSyncInfo(ISynchronizeModelElement node, IResource resource) {
        SyncInfoModelElement element;
        if (node instanceof SyncInfoModelElement && (element = (SyncInfoModelElement)node).getResource().equals((Object)resource)) {
            return element.getSyncInfo();
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            ISynchronizeModelElement child = (ISynchronizeModelElement)children[i];
            SyncInfo info = this.findSyncInfo(child, resource);
            if (info != null) {
                return info;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void assertViewMatchesModel(Subscriber subscriber) {
        SubscriberParticipantSyncInfoSource.getCollector(subscriber);
        ISynchronizeModelElement root = this.getModelRoot(subscriber);
        TreeItem[] rootItems = this.getTreeItems(subscriber);
        this.assertMatchingTrees((IDiffElement)root, rootItems, root.getChildren());
    }

    private ISynchronizeModelElement getModelRoot(Subscriber subscriber) {
        SubscriberParticipantPage page = SubscriberParticipantSyncInfoSource.getPage(subscriber);
        return ((TreeViewerAdvisor)page.getViewerAdvisor()).getModelManager().getModelRoot();
    }

    private TreeItem[] getTreeItems(Subscriber subscriber) {
        SubscriberParticipantPage page = SubscriberParticipantSyncInfoSource.getPage(subscriber);
        Viewer v = page.getViewer();
        if (v instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)v;
            treeViewer.expandAll();
            Tree t = treeViewer.getTree();
            return t.getItems();
        }
        throw new AssertionFailedError("The tree for " + subscriber.getName() + " could not be retrieved");
    }

    private static SubscriberParticipantPage getPage(Subscriber subscriber) {
        try {
            SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(subscriber);
            if (participant == null) {
                throw new AssertionFailedError("The participant for " + subscriber.getName() + " could not be retrieved");
            }
            IWorkbenchPage activePage = TeamUIPlugin.getActivePage();
            ISynchronizeView view = (ISynchronizeView)activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
            IPage page = ((SynchronizeView)view).getPage((ISynchronizeParticipant)participant);
            if (page instanceof SubscriberParticipantPage) {
                SubscriberParticipantPage subscriberPage = (SubscriberParticipantPage)page;
                return subscriberPage;
            }
        }
        catch (PartInitException partInitException) {
            throw new AssertionFailedError("Cannot show sync view in active page");
        }
        throw new AssertionFailedError("The page for " + subscriber.getName() + " could not be retrieved");
    }

    private void assertMatchingTrees(IDiffElement parent, TreeItem[] items, IDiffElement[] children) {
        if (!(items != null && items.length != 0 || children != null && children.length != 0)) {
            return;
        }
        if (items == null || children == null || items.length != children.length) {
            throw new AssertionFailedError("The number of children of " + parent.getName() + " is " + (children == null ? 0 : children.length) + " but the view has " + (items == null ? 0 : items.length));
        }
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            TreeItem foundItem = null;
            int j = 0;
            while (j < items.length) {
                TreeItem item = items[j];
                if (item.getData() == element) {
                    foundItem = item;
                    break;
                }
                ++j;
            }
            if (foundItem == null) {
                throw new AssertionFailedError("Element" + element.getName() + " is in the model but not in the view");
            }
            this.assertMatchingTrees(element, foundItem.getItems(), ((IDiffContainer)element).getChildren());
            ++i;
        }
    }
}

