/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.tests.ccvs.ui.benchmark.SequenceGenerator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.junit.Assert;

public class BenchmarkUtils {
    public static IProject getProject(String name) throws CoreException {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IProject createProject(String name) throws CoreException {
        IProject project = BenchmarkUtils.getProject(name);
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    public static void deleteProject(IProject project) throws CoreException {
        project.delete(false, null);
    }

    public static void deleteFileAndPrune(IFile file) throws CoreException {
        file.delete(false, null);
        IContainer container = file.getParent();
        while (container != null && container instanceof IFolder && BenchmarkUtils.isFolderEmpty((IFolder)container)) {
            BenchmarkUtils.deleteFolder((IFolder)container);
            container = container.getParent();
        }
    }

    public static void deleteFolder(IFolder folder) throws CoreException {
        block2: {
            try {
                folder.delete(false, null);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (BenchmarkUtils.findStatusByCode(status, -18) != null) break block2;
                throw e;
            }
        }
    }

    public static IStatus findStatusByCode(IStatus status, int code) {
        if (status.getCode() == code) {
            return status;
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            IStatus found = BenchmarkUtils.findStatusByCode(children[i], code);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public static IProject createUniqueProject(String prefix) throws CoreException {
        return BenchmarkUtils.createProject(BenchmarkUtils.makeUniqueName(null, prefix, null));
    }

    public static IFile createUniqueFile(SequenceGenerator gen, IContainer parent, int meanSize, int variance, int probBinary) throws IOException, CoreException {
        String fileName;
        int fileSize;
        while ((fileSize = (int)Math.abs(gen.nextGaussian() * (double)variance + (double)meanSize)) > meanSize + variance * 4) {
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (gen.nextInt(100) < probBinary) {
            fileName = BenchmarkUtils.makeUniqueName(gen, "file", "class");
            BenchmarkUtils.writeRandomBytes(gen, os, fileSize);
        } else {
            fileName = BenchmarkUtils.makeUniqueName(gen, "file", "txt");
            BenchmarkUtils.writeRandomText(gen, os, fileSize);
        }
        IFile file = parent.getFile((IPath)new Path(fileName));
        file.create((InputStream)new ByteArrayInputStream(os.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
        os.close();
        return file;
    }

    public static IFolder createUniqueFolder(SequenceGenerator gen, IContainer parent) throws CoreException {
        IFolder folder = parent.getFolder((IPath)new Path(BenchmarkUtils.makeUniqueName(gen, "folder", null)));
        folder.create(false, true, null);
        return folder;
    }

    public static void renameResource(IResource resource, String newName) throws CoreException {
        switch (resource.getType()) {
            case 4: {
                IProject project = (IProject)resource;
                IProjectDescription desc = project.getDescription();
                desc.setName(newName);
                project.move(desc, false, true, null);
                break;
            }
            case 2: {
                try {
                    resource.move((IPath)new Path(newName), false, null);
                    break;
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (BenchmarkUtils.findStatusByCode(status, -18) != null) break;
                    throw e;
                }
            }
            default: {
                resource.move((IPath)new Path(newName), false, null);
            }
        }
    }

    public static void modifyFile(SequenceGenerator gen, IFile file) throws IOException, CoreException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             InputStream is = file.getContents(true);){
            int rsize;
            byte[] buffer = new byte[8192];
            boolean changed = false;
            while ((rsize = is.read(buffer)) != -1) {
                double gaussian;
                while ((gaussian = gen.nextGaussian() * 0.5) > 1.0 || gaussian < -1.0) {
                }
                int changeSize = (int)(gaussian * (double)rsize);
                changed = changed || changeSize != 0;
                os.write(buffer, 0, changeSize < 0 ? -changeSize : rsize);
                BenchmarkUtils.writeRandomText(gen, os, changeSize);
            }
            if (!changed) {
                os.write(33);
            }
            file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), false, true, null);
        }
    }

    public static String makeUniqueName(SequenceGenerator gen, String prefix, String extension) throws CoreException {
        StringBuffer name = new StringBuffer(prefix);
        name.append('-');
        if (gen == null) {
            name.append(SequenceGenerator.nextGloballyUniqueLong());
        } else {
            name.append(gen.nextUniqueInt());
        }
        if (extension != null) {
            name.append('.');
            name.append(extension);
        }
        return name.toString();
    }

    public static void importZip(IContainer container, File file) throws IOException, ZipException, InterruptedException, InvocationTargetException {
        ZipFile zipFile = new ZipFile(file);
        ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
        ImportOperation importOperation = new ImportOperation(container.getFullPath(), (Object)provider.getRoot(), (IImportStructureProvider)provider, null);
        importOperation.setOverwriteResources(true);
        importOperation.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)importOperation.getStatus().isOK());
    }

    public static void writeRandomText(SequenceGenerator gen, OutputStream os, int count) throws IOException {
        while (count-- > 0) {
            int c = gen.nextInt(99);
            os.write(c >= 95 ? 10 : c + 32);
        }
    }

    public static void writeRandomBytes(SequenceGenerator gen, OutputStream os, int count) throws IOException {
        while (count-- > 0) {
            os.write(gen.nextInt(256));
        }
    }

    public static IFolder createRandomDeepFolder(SequenceGenerator gen, IContainer root) throws CoreException {
        IFolder folder;
        IContainer container = BenchmarkUtils.pickRandomDeepContainer(gen, root);
        do {
            folder = BenchmarkUtils.createUniqueFolder(gen, container);
            container = folder;
        } while (gen.nextInt(8) == 0);
        return folder;
    }

    public static IFile[] createRandomDeepFiles(SequenceGenerator gen, IContainer root, int count, int meanSize, int variance, int probBinary) throws IOException, CoreException {
        IFile[] files = new IFile[count];
        while (count-- > 0) {
            files[count] = BenchmarkUtils.createUniqueFile(gen, BenchmarkUtils.pickRandomDeepContainer(gen, root), meanSize, variance, probBinary);
        }
        return files;
    }

    public static void deleteRandomDeepFiles(SequenceGenerator gen, IContainer root, int count) throws CoreException {
        while (count-- > 0) {
            IFile file = BenchmarkUtils.pickRandomDeepFile(gen, root);
            if (file == null) break;
            BenchmarkUtils.deleteFileAndPrune(file);
        }
    }

    public static void modifyRandomDeepFiles(SequenceGenerator gen, IContainer root, int count) throws IOException, CoreException {
        while (count-- > 0) {
            IFile file = BenchmarkUtils.pickRandomDeepFile(gen, root);
            if (file == null) break;
            BenchmarkUtils.modifyFile(gen, file);
        }
    }

    public static void touchRandomDeepFiles(SequenceGenerator gen, IContainer root, int count) throws CoreException {
        while (count-- > 0) {
            IFile file = BenchmarkUtils.pickRandomDeepFile(gen, root);
            if (file == null) break;
            file.touch(null);
        }
    }

    public static void renameRandomDeepFiles(SequenceGenerator gen, IContainer root, int count) throws CoreException {
        while (count-- > 0) {
            IFile file = BenchmarkUtils.pickRandomDeepFile(gen, root);
            if (file == null) break;
            BenchmarkUtils.renameResource((IResource)file, BenchmarkUtils.makeUniqueName(gen, "file", file.getFileExtension()));
        }
    }

    public static IFile pickRandomFile(SequenceGenerator gen, IContainer parent) throws CoreException {
        IResource[] members = BenchmarkUtils.filterResources(parent.members());
        int size = members.length;
        while (size != 0) {
            int elem = gen.nextInt(size);
            if (members[elem] instanceof IFile) {
                return (IFile)members[elem];
            }
            System.arraycopy(members, elem + 1, members, elem, size - elem - 1);
            --size;
        }
        return null;
    }

    public static IFolder pickRandomFolder(SequenceGenerator gen, IContainer parent) throws CoreException {
        IResource[] members = BenchmarkUtils.filterResources(parent.members());
        int size = members.length;
        while (size != 0) {
            int elem = gen.nextInt(size);
            if (members[elem] instanceof IFolder) {
                return (IFolder)members[elem];
            }
            System.arraycopy(members, elem + 1, members, elem, size - elem - 1);
            --size;
        }
        return null;
    }

    public static IFile pickRandomDeepFile(SequenceGenerator gen, IContainer root) throws CoreException {
        IResource[] members = BenchmarkUtils.filterResources(root.members());
        int size = members.length;
        while (size != 0) {
            IFile file;
            int elem = gen.nextInt(size);
            IResource resource = members[elem];
            if (resource instanceof IFile) {
                return (IFile)resource;
            }
            if (resource instanceof IFolder && (file = BenchmarkUtils.pickRandomDeepFile(gen, (IContainer)((IFolder)resource))) != null) {
                return file;
            }
            System.arraycopy(members, elem + 1, members, elem, size - elem - 1);
            --size;
        }
        return null;
    }

    public static IContainer pickRandomDeepContainer(SequenceGenerator gen, IContainer root) throws CoreException {
        if (gen.nextInt(6) == 0) {
            IResource[] members = BenchmarkUtils.filterResources(root.members());
            int size = members.length;
            while (size != 0) {
                int elem = gen.nextInt(size);
                IResource resource = members[elem];
                if (resource instanceof IFolder) {
                    return BenchmarkUtils.pickRandomDeepContainer(gen, (IContainer)((IFolder)resource));
                }
                System.arraycopy(members, elem + 1, members, elem, size - elem - 1);
                --size;
            }
        }
        Assert.assertTrue((boolean)BenchmarkUtils.isValidContainer((IResource)root));
        return root;
    }

    public static boolean isFolderEmpty(IFolder folder) throws CoreException {
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            if (BenchmarkUtils.isValidFile(members[i]) || BenchmarkUtils.isValidFolder(members[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidFile(IResource file) throws CoreException {
        String name = file.getName();
        return file instanceof IFile && !file.isPhantom() && !name.equals(".classpath") && !name.equals(".project") && !name.equals(".vcm_meta");
    }

    public static boolean isValidFolder(IResource folder) throws CoreException {
        String name = folder.getName();
        return folder instanceof IFolder && !folder.isPhantom() && !name.equals("CVS") && !name.equals("bin");
    }

    public static boolean isValidContainer(IResource container) throws CoreException {
        return container instanceof IProject || BenchmarkUtils.isValidFolder(container);
    }

    public static boolean isValidResource(IResource resource) throws CoreException {
        return BenchmarkUtils.isValidFile(resource) || BenchmarkUtils.isValidContainer(resource);
    }

    public static IResource[] filterResources(IResource[] resources) throws CoreException {
        ArrayList<IResource> list = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (BenchmarkUtils.isValidResource(resources[i])) {
                list.add(resources[i]);
            }
            ++i;
        }
        if (list.size() != resources.length) {
            resources = list.toArray(new IResource[list.size()]);
        }
        Arrays.sort(resources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((IResource)a).getName().compareTo(((IResource)b).getName());
            }
        });
        return resources;
    }

    public static boolean isEmpty(IDiffContainer node) {
        if (node == null) {
            return true;
        }
        if (node.getKind() != 0) {
            return false;
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!BenchmarkUtils.isEmpty(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(IDiffElement element) {
        if (element == null) {
            return true;
        }
        if (element.getKind() != 0) {
            return false;
        }
        if (element instanceof IDiffContainer) {
            IDiffElement[] children = ((DiffNode)element).getChildren();
            int i = 0;
            while (i < children.length) {
                if (!BenchmarkUtils.isEmpty(children[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

