/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.SubscriberParticipantSyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTest;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTestSetup;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkUtils;
import org.eclipse.team.tests.ccvs.ui.benchmark.SequenceGenerator;

public class MergeTests
extends BenchmarkTest {
    private static final String NON_MODEL_MERGE = "NonModelMerge";
    private static final String MODEL_MERGE = "ModelMerge";
    private static final String[] PERFORMANCE_GROUPS = new String[]{"NonModelMerge", "ModelMerge"};
    private static final int FILE_SIZE_MEAN = 16384;
    private static final int FILE_SIZE_VARIANCE = 0;
    private static final int PROB_BINARY = 0;

    public MergeTests() {
    }

    public MergeTests(String name) {
        super(name);
    }

    public static Test suite() {
        return MergeTests.suite(MergeTests.class);
    }

    protected IProject setupProject() throws Exception {
        IProject project = this.createUniqueProject(BenchmarkTestSetup.SMALL_ZIP_FILE);
        this.shareProject(project);
        return project;
    }

    public void testCompareMerges() throws Exception {
        this.openEmptyPerspective();
        this.setupGroups(PERFORMANCE_GROUPS, "Merge Tests", false);
        System.out.println("Loop: " + BenchmarkTestSetup.LOOP_COUNT);
        int i = 0;
        while (i < BenchmarkTestSetup.LOOP_COUNT) {
            SequenceGenerator gen = new SequenceGenerator();
            IProject headProject = this.setupProject();
            CVSTag root = new CVSTag("Root_branch", 1);
            CVSTag branch = new CVSTag("branch", 1);
            this.makeBranch(new IResource[]{headProject}, root, branch, false);
            IProject branchProject = this.checkoutCopy(headProject, branch);
            SubscriberParticipantSyncInfoSource source = new SubscriberParticipantSyncInfoSource();
            int size = 50;
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)branchProject, size);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)branchProject, size);
            IFile[] newResources = BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)branchProject, size, 16384, 0, 0);
            this.addResources((IResource[])newResources);
            this.syncCommitResources(source, new IResource[]{branchProject}, "");
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)headProject, size);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)headProject, size);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)headProject, size, 16384, 0, 0);
            this.startGroup(NON_MODEL_MERGE);
            CVSMergeSubscriber subscriber = ((SyncInfoSource)source).createMergeSubscriber(headProject, CVSTag.DEFAULT, branch, false);
            source.refresh((Subscriber)subscriber, (IResource)headProject);
            this.endGroup();
            this.startGroup(MODEL_MERGE);
            subscriber = ((SyncInfoSource)source).createMergeSubscriber(headProject, CVSTag.DEFAULT, branch, true);
            source.refresh((Subscriber)subscriber, (IResource)headProject);
            this.endGroup();
            System.out.println(i + 1);
            ++i;
        }
        this.commitGroups(false);
    }
}

