/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.performance.Dimension;
import org.osgi.framework.BundleContext;

public class PerformanceTestPlugin
extends Plugin {
    public static final String CONFIG = "config";
    public static final String BUILD = "build";
    private static final String DEFAULT_DB_NAME = "perfDB";
    private static final String DEFAULT_DB_USER = "guest";
    private static final String DEFAULT_DB_PASSWORD = "guest";
    private static final String DB_NAME = "dbname";
    private static final String DB_USER = "dbuser";
    private static final String DB_PASSWD = "dbpasswd";
    private static final String ECLIPSE_PERF_DBLOC = "eclipse.perf.dbloc";
    public static final String ECLIPSE_PERF_ASSERTAGAINST = "eclipse.perf.assertAgainst";
    private static final String ECLIPSE_PERF_CONFIG = "eclipse.perf.config";
    private static final String ECLIPSE_PERF_DEFAULT_DIM = "eclipse.perf.default.dim";
    private static final String ECLIPSE_PERF_RESULTS_DIMENSIONS = "eclipse.perf.results.dimensions";
    private static final String ECLIPSE_PERF_CONFIGS_DESCRIPTOR = "eclipse.perf.configs.descriptor";
    private static final Dim[] SUPPORTED_DIMENSIONS = new Dim[]{InternalDimensions.KERNEL_TIME, InternalDimensions.CPU_TIME, InternalDimensions.WORKING_SET, InternalDimensions.ELAPSED_PROCESS, InternalDimensions.USED_JAVA_HEAP, InternalDimensions.WORKING_SET_PEAK, InternalDimensions.COMITTED};
    private static final int[] SUPPORTED_DIMENSIONS_ID = new int[SUPPORTED_DIMENSIONS.length];
    private static final String DEFAULT_CONFIG_DESCRIPTORS = "";
    private static final Dim DEFAULT_DIMENSION;
    private static final Dim[] DEFAULT_RESULTS_DIMENSIONS;
    public static final String PLUGIN_ID = "org.eclipse.test.performance";
    public static final int INTERNAL_ERROR = 1;
    private static PerformanceTestPlugin fgPlugin;

    static {
        int length = SUPPORTED_DIMENSIONS.length;
        int i = 0;
        while (i < length) {
            PerformanceTestPlugin.SUPPORTED_DIMENSIONS_ID[i] = SUPPORTED_DIMENSIONS[i].getId();
            ++i;
        }
        DEFAULT_DIMENSION = InternalDimensions.ELAPSED_PROCESS;
        DEFAULT_RESULTS_DIMENSIONS = new Dim[]{InternalDimensions.ELAPSED_PROCESS, InternalDimensions.CPU_TIME};
    }

    public PerformanceTestPlugin() {
        fgPlugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        DB.shutdown();
        super.stop(context);
    }

    public static PerformanceTestPlugin getDefault() {
        return fgPlugin;
    }

    public static String getDBLocation() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            PerformanceTestPlugin.logInfo("System property eclipse.perf.dbloc found to equal " + dbloc + " in getDBLocation");
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(ECLIPSE_PERF_DBLOC);
        }
        return null;
    }

    public static String getDBName() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            PerformanceTestPlugin.logInfo("System property eclipse.perf.dbloc found to equal " + dbloc + " in getDBName");
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_NAME, DEFAULT_DB_NAME);
        }
        return DEFAULT_DB_NAME;
    }

    public static String getDBUser() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            PerformanceTestPlugin.logInfo("System property eclipse.perf.dbloc found to equal " + dbloc + " in getDBUser");
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_USER, "guest");
        }
        return "guest";
    }

    public static Dimension getDefaultDimension() {
        String defaultDim = System.getProperty(ECLIPSE_PERF_DEFAULT_DIM);
        if (defaultDim == null) {
            return DEFAULT_DIMENSION;
        }
        Dimension dimension = PerformanceTestPlugin.getDimension(defaultDim);
        Assert.isNotNull((Object)dimension, (String)("Invalid default dimension found in system property 'eclipse.perf.default.dim': " + defaultDim));
        return dimension;
    }

    public static Dimension[] getResultsDimensions() {
        String resultsDimension = System.getProperty(ECLIPSE_PERF_RESULTS_DIMENSIONS);
        if (resultsDimension == null) {
            return DEFAULT_RESULTS_DIMENSIONS;
        }
        StringTokenizer tokenizer = new StringTokenizer(resultsDimension, ",");
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            Dimension dimension = PerformanceTestPlugin.getDimension(token);
            if (dimension == null) {
                try {
                    dimension = PerformanceTestPlugin.getDimension(Integer.parseInt(token));
                }
                catch (NumberFormatException numberFormatException) {}
                if (dimension == null) {
                    System.err.println("Skip invalid results dimension found in system property 'eclipse.perf.results.dimensions': " + resultsDimension);
                    continue;
                }
            }
            list.add(dimension);
        }
        int size = list.size();
        if (size == 0) {
            System.err.println("No valid dimension was found in system property 'eclipse.perf.results.dimensions'!");
            System.err.println("=> default results dimensions will be used instead!");
            return DEFAULT_RESULTS_DIMENSIONS;
        }
        Dimension[] dimensions = new Dimension[size];
        list.toArray(dimensions);
        return dimensions;
    }

    public static List<String> getDimensions() {
        ArrayList<String> dimensions = new ArrayList<String>();
        int i = 0;
        while (i < SUPPORTED_DIMENSIONS.length) {
            dimensions.add(SUPPORTED_DIMENSIONS[i].getName());
            ++i;
        }
        return dimensions;
    }

    public static Dimension getDimension(int id) {
        int length = SUPPORTED_DIMENSIONS.length;
        int i = 0;
        while (i < length) {
            if (SUPPORTED_DIMENSIONS[i].getId() == id) {
                return SUPPORTED_DIMENSIONS[i];
            }
            ++i;
        }
        return null;
    }

    public static Dimension getDimension(String name) {
        int length = SUPPORTED_DIMENSIONS.length;
        int i = 0;
        while (i < length) {
            if (SUPPORTED_DIMENSIONS[i].getName().equals(name)) {
                return SUPPORTED_DIMENSIONS[i];
            }
            ++i;
        }
        return null;
    }

    public static String[][] getConfigDescriptors() {
        String descriptors = System.getProperty(ECLIPSE_PERF_CONFIGS_DESCRIPTOR, DEFAULT_CONFIG_DESCRIPTORS);
        StringTokenizer tokenizer = new StringTokenizer(descriptors, ",;");
        ArrayList<String[]> list = new ArrayList<String[]>();
        while (tokenizer.hasMoreTokens()) {
            String[] config = new String[]{tokenizer.nextToken().trim(), tokenizer.nextToken().trim()};
            list.add(config);
        }
        String[][] configDescriptors = new String[list.size()][];
        list.toArray((T[])configDescriptors);
        return configDescriptors;
    }

    public static String getDBPassword() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            PerformanceTestPlugin.logInfo("System property eclipse.perf.dbloc found to equal " + dbloc + " in getDBPassword");
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_PASSWD, "guest");
        }
        return "guest";
    }

    public static Variations getVariations() {
        Variations keys = new Variations();
        String configKey = System.getProperty(ECLIPSE_PERF_CONFIG);
        if (configKey != null) {
            keys.parsePairs(configKey);
        }
        return keys;
    }

    public static Variations getAssertAgainst() {
        String assertKey = System.getProperty(ECLIPSE_PERF_ASSERTAGAINST);
        if (assertKey != null) {
            Variations keys = PerformanceTestPlugin.getVariations();
            if (keys == null) {
                keys = new Variations();
            }
            keys.parsePairs(assertKey);
            return keys;
        }
        return null;
    }

    public static void logError(String message) {
        if (message == null) {
            message = DEFAULT_CONFIG_DESCRIPTORS;
        }
        PerformanceTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, null));
    }

    public static void logWarning(String message) {
        if (message == null) {
            message = DEFAULT_CONFIG_DESCRIPTORS;
        }
        PerformanceTestPlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, message, null));
    }

    public static void logInfo(String message) {
        if (message == null) {
            message = DEFAULT_CONFIG_DESCRIPTORS;
        }
        PerformanceTestPlugin.log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
    }

    public static void log(Throwable e) {
        PerformanceTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, "Internal Error", e));
    }

    public static void log(IStatus status) {
        if (fgPlugin != null) {
            fgPlugin.getLog().log(status);
        } else {
            switch (status.getSeverity()) {
                case 4: {
                    System.err.println("Error: " + status.getMessage());
                    break;
                }
                case 2: {
                    System.err.println("Warning: " + status.getMessage());
                    break;
                }
            }
            Throwable exception = status.getException();
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

