/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Report;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.junit.Assert;

public class Scenario {
    private static final boolean DEBUG = false;
    private SharedState fSharedState;
    private String fScenarioName;
    private String[] fSeriesNames;
    private StatisticsSession[] fSessions;
    private Map<Dim, TimeSeries> fSeries = new HashMap<Dim, TimeSeries>();
    private Dim[] fDimensions;

    @Deprecated
    public Scenario(String scenario, Variations variations, String seriesKey, Dim[] dimensions) {
        Assert.assertFalse((scenario.indexOf(37) >= 0 ? 1 : 0) != 0);
        this.fScenarioName = scenario;
        this.fSharedState = new SharedState(variations, scenario, seriesKey, dimensions);
    }

    public Scenario(String scenario, SharedState sharedState) {
        Assert.assertFalse((scenario.indexOf(37) >= 0 ? 1 : 0) != 0);
        this.fScenarioName = scenario;
        this.fSharedState = sharedState;
    }

    public String getScenarioName() {
        return this.fScenarioName;
    }

    public Dim[] getDimensions() {
        this.loadSessions();
        if (this.fDimensions == null) {
            return new Dim[0];
        }
        return this.fDimensions;
    }

    public String[] getTimeSeriesLabels() {
        this.loadSeriesNames();
        if (this.fSeriesNames == null) {
            return new String[0];
        }
        return this.fSeriesNames;
    }

    public String[] getFailureMessages() {
        this.loadSeriesNames();
        return this.fSharedState.getFailures(this.fSeriesNames, this.fScenarioName);
    }

    public TimeSeries getTimeSeries(Dim dim) {
        this.loadSessions();
        TimeSeries ts = this.fSeries.get(dim);
        if (ts == null) {
            double[] ds = new double[this.fSessions.length];
            double[] sd = new double[this.fSessions.length];
            long[] sizes = new long[this.fSessions.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = this.fSessions[i].getAverage(dim);
                sd[i] = this.fSessions[i].getStddev(dim);
                sizes[i] = this.fSessions[i].getCount(dim);
                ++i;
            }
            ts = new TimeSeries(this.fSeriesNames, ds, sd, sizes);
            this.fSeries.put(dim, ts);
        }
        return ts;
    }

    public void dump(PrintStream ps, String key) {
        Dim[] dimensions;
        ps.println("Scenario: " + this.getScenarioName());
        Report r = new Report(2);
        String[] timeSeriesLabels = this.getTimeSeriesLabels();
        r.addCell(String.valueOf(key) + ":");
        String[] stringArray = timeSeriesLabels;
        int n = timeSeriesLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String timeSeriesLabel = stringArray[n2];
            r.addCellRight(timeSeriesLabel);
            ++n2;
        }
        r.nextRow();
        Dim[] dimArray = dimensions = this.getDimensions();
        int n3 = dimensions.length;
        n = 0;
        while (n < n3) {
            Dim dim = dimArray[n];
            r.addCell(String.valueOf(dim.getName()) + ':');
            TimeSeries ts = this.getTimeSeries(dim);
            int n4 = ts.getLength();
            int j = 0;
            while (j < n4) {
                String stddev = "";
                double stddev2 = ts.getStddev(j);
                if (stddev2 != 0.0) {
                    stddev = " [" + dim.getDisplayValue(stddev2) + "]";
                }
                r.addCellRight(String.valueOf(dim.getDisplayValue(ts.getValue(j))) + stddev);
                ++j;
            }
            r.nextRow();
            ++n;
        }
        r.print(ps);
        ps.println();
    }

    private void loadSeriesNames() {
        if (this.fSeriesNames == null) {
            this.fSeriesNames = DB.querySeriesValues(this.fScenarioName, this.fSharedState.fVariations, this.fSharedState.fSeriesKey);
        }
    }

    private void loadSessions() {
        if (this.fSessions != null) {
            return;
        }
        this.loadSeriesNames();
        Variations v = (Variations)this.fSharedState.fVariations.clone();
        ArrayList<StatisticsSession> sessions = new ArrayList<StatisticsSession>();
        ArrayList<String> names2 = new ArrayList<String>();
        HashSet<Dim> dims = new HashSet<Dim>();
        String[] stringArray = this.fSeriesNames;
        int n = this.fSeriesNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fSeriesName = stringArray[n2];
            v.put(this.fSharedState.fSeriesKey, fSeriesName);
            DataPoint[] dps = DB.queryDataPoints(v, this.fScenarioName, this.fSharedState.fQueryDimensions);
            if (dps.length > 0) {
                dims.addAll(dps[0].getDimensions2());
                sessions.add(new StatisticsSession(dps));
                names2.add(fSeriesName);
            }
            ++n2;
        }
        this.fSessions = sessions.toArray(new StatisticsSession[sessions.size()]);
        this.fSeriesNames = names2.toArray(new String[sessions.size()]);
        this.fDimensions = dims.toArray(new Dim[dims.size()]);
        Arrays.sort(this.fDimensions, (o1, o2) -> {
            Dim d1 = o1;
            Dim d2 = o2;
            return d1.getName().compareTo(d2.getName());
        });
    }

    public static class SharedState {
        private Variations fVariations;
        private String fSeriesKey;
        private Set<Dim> fQueryDimensions;
        private String fScenarioPattern;
        private Map<String, Map<String, String>> fMessages;

        SharedState(Variations variations, String scenarioPattern, String seriesKey, Dim[] dimensions) {
            this.fVariations = variations;
            this.fScenarioPattern = scenarioPattern;
            this.fSeriesKey = seriesKey;
            if (dimensions != null && dimensions.length > 0) {
                this.fQueryDimensions = new HashSet<Dim>();
                Dim[] dimArray = dimensions;
                int n = dimensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Dim dimension = dimArray[n2];
                    this.fQueryDimensions.add(dimension);
                    ++n2;
                }
            }
        }

        String[] getFailures(String[] names, String scenarioId) {
            if (this.fMessages == null) {
                this.fMessages = new HashMap<String, Map<String, String>>();
                Variations v = (Variations)this.fVariations.clone();
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    v.put(this.fSeriesKey, name);
                    Map<String, String> map = DB.queryFailure(this.fScenarioPattern, v);
                    this.fMessages.put(name, map);
                    ++n2;
                }
            }
            String[] result = new String[names.length];
            int i = 0;
            while (i < names.length) {
                Map<String, String> messages = this.fMessages.get(names[i]);
                if (messages != null) {
                    result[i] = messages.get(scenarioId);
                }
                ++i;
            }
            return result;
        }
    }
}

