/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.tests;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.tests.TestPerformanceMeter;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class DBTests
extends TestCase {
    private static final String CONFIG = "c";
    private static final String BUILD = "b";
    private static final String SCENARIO_NAME_0 = "bar.testScenario0";
    private static final String SCENARIO_NAME_1 = "bar.testScenario1";
    private static final String SCENARIO_NAME_2 = "bar.testScenario2";
    private static final String SCENARIO_NAME_3 = "foo.testScenario3";
    private static final String SCENARIO_NAME_4 = "foo.testScenario4";
    private static final String SHORT_NAME_2 = "ShortName2";
    private static final String SHORT_NAME_3 = "ShortName3";
    private static final String SHORT_NAME_4 = "ShortName4";
    private static final String DBLOC = "testDBs";
    private String DBNAME;
    private static final String DBUSER = "testUser";
    private static final String DBPASSWD = "testPassword";

    protected void setUp() throws Exception {
        super.setUp();
        this.DBNAME = "testDB_" + new Date().getTime();
        System.setProperty("eclipse.perf.dbloc", "testDBs;dbname=" + this.DBNAME + ";dbuser=" + DBUSER + ";dbpasswd=" + DBPASSWD);
        System.setProperty("eclipse.perf.config", "c=test;b=b0001;jvm=sun142");
        System.setProperty("eclipse.perf.assertAgainst", "b=base");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPropertyGetters() {
        DBTests.assertEquals((String)DBLOC, (String)PerformanceTestPlugin.getDBLocation());
        DBTests.assertEquals((String)this.DBNAME, (String)PerformanceTestPlugin.getDBName());
        DBTests.assertEquals((String)DBUSER, (String)PerformanceTestPlugin.getDBUser());
        DBTests.assertEquals((String)DBPASSWD, (String)PerformanceTestPlugin.getDBPassword());
        DBTests.assertEquals((String)"|b=b0001||c=test||jvm=sun142|", (String)PerformanceTestPlugin.getVariations().toExactMatchString());
        DBTests.assertEquals((String)"|b=base||c=test||jvm=sun142|", (String)PerformanceTestPlugin.getAssertAgainst().toExactMatchString());
    }

    public void testAssertPerformance() throws SQLException {
        Performance perf = Performance.getDefault();
        System.setProperty("eclipse.perf.config", "c=test;b=ref");
        TestPerformanceMeter pm1 = new TestPerformanceMeter(SCENARIO_NAME_0);
        pm1.addPair(InternalDimensions.CPU_TIME, 100L, 1000L);
        pm1.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        pm1.start();
        pm1.stop();
        pm1.commit();
        pm1.dispose();
        String build = "001";
        System.setProperty("eclipse.perf.config", "c=test;b=" + build);
        System.setProperty("eclipse.perf.assertAgainst", "b=ref");
        TestPerformanceMeter pm2 = new TestPerformanceMeter(SCENARIO_NAME_0);
        pm2.addPair(InternalDimensions.CPU_TIME, 100L, 1100L);
        pm2.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        pm2.start();
        pm2.stop();
        pm2.commit();
        boolean failed = false;
        try {
            perf.assertPerformanceInRelativeBand(pm2, InternalDimensions.CPU_TIME, -5, 5);
        }
        catch (AssertionFailedError assertionFailedError) {
            failed = true;
        }
        pm2.dispose();
        if (!failed) {
            String mesg;
            Scenario s;
            String[] failureMessages;
            Variations v = new Variations();
            v.put(CONFIG, "%");
            v.put(BUILD, build);
            Scenario[] scenarios = DB.queryScenarios(v, SCENARIO_NAME_0, CONFIG, null);
            if (scenarios != null && scenarios.length > 0 && (failureMessages = (s = scenarios[0]).getFailureMessages()).length == 1 && (mesg = failureMessages[0]) != null && mesg.equals("Performance criteria not met when compared to '{b=ref, c=test}':\nCPU Time: 1 s is not within [95%, 105%] of 900 ms")) {
                failed = true;
            }
        }
        DBTests.assertTrue((boolean)failed);
    }

    public void testBasicDBFunctionality() {
        Performance perf = Performance.getDefault();
        TestPerformanceMeter pm1 = new TestPerformanceMeter(SCENARIO_NAME_1);
        pm1.addPair(InternalDimensions.CPU_TIME, 100L, 1000L);
        pm1.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        pm1.start();
        pm1.stop();
        pm1.commit();
        pm1.dispose();
        TestPerformanceMeter pm2 = new TestPerformanceMeter(SCENARIO_NAME_2);
        pm2.addPair(InternalDimensions.CPU_TIME, 100L, 1000L);
        pm2.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        perf.tagAsGlobalSummary((PerformanceMeter)pm2, SHORT_NAME_2, new Dimension[]{Dimension.CPU_TIME, Dimension.USED_JAVA_HEAP});
        pm2.start();
        pm2.stop();
        pm2.commit();
        pm2.dispose();
        TestPerformanceMeter pm3 = new TestPerformanceMeter(SCENARIO_NAME_3);
        pm3.addPair(InternalDimensions.CPU_TIME, 100L, 1000L);
        pm3.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        perf.tagAsGlobalSummary((PerformanceMeter)pm3, SHORT_NAME_3, Dimension.CPU_TIME);
        pm3.start();
        pm3.stop();
        pm3.commit();
        pm3.dispose();
        TestPerformanceMeter pm4 = new TestPerformanceMeter(SCENARIO_NAME_4);
        pm4.addPair(InternalDimensions.CPU_TIME, 100L, 1000L);
        pm4.addPair(InternalDimensions.WORKING_SET, 1000L, 2000L);
        perf.tagAsSummary((PerformanceMeter)pm4, SHORT_NAME_4, Dimension.USED_JAVA_HEAP);
        pm4.start();
        pm4.stop();
        pm4.commit();
        pm4.dispose();
        Variations v = new Variations();
        v.put(CONFIG, "test");
        v.put(BUILD, "b0001");
        v.put("jvm", "sun142");
        DataPoint[] points = DB.queryDataPoints(v, SCENARIO_NAME_1, null);
        DBTests.assertEquals((int)1, (int)points.length);
        DataPoint dp = points[0];
        Dim[] dimensions = dp.getDimensions();
        DBTests.assertEquals((int)2, (int)dimensions.length);
        Scalar s1 = dp.getScalar(InternalDimensions.CPU_TIME);
        DBTests.assertNotNull((Object)s1);
        DBTests.assertEquals((long)900L, (long)s1.getMagnitude());
        Scalar s2 = dp.getScalar(InternalDimensions.WORKING_SET);
        DBTests.assertNotNull((Object)s2);
        DBTests.assertEquals((long)1000L, (long)s2.getMagnitude());
        HashSet<Dim> dims = new HashSet<Dim>();
        dims.add(InternalDimensions.WORKING_SET);
        points = DB.queryDataPoints(v, SCENARIO_NAME_1, dims);
        DBTests.assertEquals((int)1, (int)points.length);
        dimensions = points[0].getDimensions();
        DBTests.assertEquals((int)1, (int)dimensions.length);
        Scalar s = points[0].getScalar(InternalDimensions.WORKING_SET);
        DBTests.assertNotNull((Object)s);
        DBTests.assertEquals((long)1000L, (long)s.getMagnitude());
        ArrayList<String> buildNames = new ArrayList<String>();
        Variations v2 = new Variations();
        v2.put(CONFIG, "%");
        v2.put(BUILD, "b%");
        DB.queryDistinctValues(buildNames, BUILD, v2, "%");
        DBTests.assertEquals((int)1, (int)buildNames.size());
        DBTests.assertEquals((String)"b0001", (String)((String)buildNames.get(0)));
        SummaryEntry[] fps = DB.querySummaries(PerformanceTestPlugin.getVariations(), null);
        DBTests.assertEquals((int)3, (int)fps.length);
        DBTests.assertEquals((String)SCENARIO_NAME_2, (String)fps[0].scenarioName);
        DBTests.assertEquals((String)SHORT_NAME_2, (String)fps[0].shortName);
        DBTests.assertEquals((Object)Dimension.USED_JAVA_HEAP, (Object)fps[0].dimension);
        DBTests.assertEquals((String)SCENARIO_NAME_2, (String)fps[1].scenarioName);
        DBTests.assertEquals((String)SHORT_NAME_2, (String)fps[1].shortName);
        DBTests.assertEquals((Object)Dimension.CPU_TIME, (Object)fps[1].dimension);
        DBTests.assertEquals((String)SCENARIO_NAME_3, (String)fps[2].scenarioName);
        DBTests.assertEquals((String)SHORT_NAME_3, (String)fps[2].shortName);
        DBTests.assertEquals((Object)Dimension.CPU_TIME, (Object)fps[2].dimension);
        SummaryEntry[] fps2 = DB.querySummaries(PerformanceTestPlugin.getVariations(), "foo.%");
        DBTests.assertEquals((int)2, (int)fps2.length);
        DBTests.assertEquals((String)SCENARIO_NAME_3, (String)fps2[0].scenarioName);
        DBTests.assertEquals((String)SHORT_NAME_3, (String)fps2[0].shortName);
        DBTests.assertEquals((Object)Dimension.CPU_TIME, (Object)fps2[0].dimension);
        DBTests.assertEquals((String)SCENARIO_NAME_4, (String)fps2[1].scenarioName);
        DBTests.assertEquals((String)SHORT_NAME_4, (String)fps2[1].shortName);
        DBTests.assertEquals((Object)Dimension.USED_JAVA_HEAP, (Object)fps2[1].dimension);
    }
}

