/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.osgi.framework.Bundle;

class ClassLoaderTools {
    ClassLoaderTools() {
    }

    public static ClassLoader getPluginClassLoader(String getfTestPluginName, ClassLoader currentTCCL) {
        Bundle bundle = Platform.getBundle((String)getfTestPluginName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + getfTestPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new TestBundleClassLoader(bundle, currentTCCL);
    }

    public static String getClassPlugin(String className) {
        int index = className.lastIndexOf(46);
        String plugin = null;
        while (index != -1) {
            plugin = className.substring(0, index);
            if (Platform.getBundle((String)plugin) != null) break;
            index = className.lastIndexOf(46, index - 1);
        }
        return plugin;
    }

    public static ClassLoader getJUnit5Classloader(List<String> platformEngine) {
        ArrayList<Bundle> platformEngineBundles = new ArrayList<Bundle>();
        for (String string : platformEngine) {
            Bundle bundle = Platform.getBundle((String)string);
            platformEngineBundles.add(bundle);
        }
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    static class MultiBundleClassLoader
    extends ClassLoader {
        private List<Bundle> bundleList;

        public MultiBundleClassLoader(List<Bundle> platformEngineBundles) {
            this.bundleList = platformEngineBundles;
        }

        public Class<?> findClasss(String name) throws ClassNotFoundException {
            return this.findClass(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class c = null;
            for (Bundle temp : this.bundleList) {
                try {
                    c = temp.loadClass(name);
                    if (c == null) continue;
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return c;
        }

        @Override
        protected URL findResource(String name) {
            URL url = null;
            for (Bundle temp : this.bundleList) {
                url = temp.getResource(name);
                if (url == null) continue;
                return url;
            }
            return url;
        }

        protected Enumeration findResources(String name) throws IOException {
            Enumeration enumFinal = null;
            int i = 0;
            while (i < this.bundleList.size()) {
                if (i == 0) {
                    enumFinal = this.bundleList.get(i).getResources(name);
                } else {
                    Enumeration e2 = this.bundleList.get(i).getResources(name);
                    Vector temp = new Vector();
                    while (enumFinal != null && enumFinal.hasMoreElements()) {
                        temp.add(enumFinal.nextElement());
                    }
                    while (e2 != null && e2.hasMoreElements()) {
                        temp.add(e2.nextElement());
                    }
                    enumFinal = temp.elements();
                }
                ++i;
            }
            return enumFinal;
        }
    }

    static class TestBundleClassLoader
    extends ClassLoader {
        protected Bundle bundle;
        protected ClassLoader currentTCCL;

        public TestBundleClassLoader(Bundle target, ClassLoader currentTCCL) {
            this.bundle = target;
            this.currentTCCL = currentTCCL;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.bundle.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.currentTCCL.loadClass(name);
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.bundle.getResource(name);
            if (url == null) {
                url = this.currentTCCL.getResource(name);
            }
            return url;
        }

        protected Enumeration findResources(String name) throws IOException {
            Enumeration<URL> enumeration = this.bundle.getResources(name);
            if (enumeration == null) {
                enumeration = this.currentTCCL.getResources(name);
            }
            return enumeration;
        }

        @Override
        public Enumeration<URL> getResources(String res) throws IOException {
            String newPath;
            URI uri;
            URI newUri;
            Enumeration<URL> urls = this.currentTCCL.getResources(res);
            if (urls.hasMoreElements()) {
                return urls;
            }
            ArrayList<URL> resources = new ArrayList<URL>(6);
            String location = null;
            URL url = null;
            if (this.bundle instanceof EquinoxBundle) {
                location = ((EquinoxBundle)this.bundle).getLocation();
            }
            if (location != null && location.startsWith("reference:") && (newUri = uri.resolve(newPath = String.valueOf((uri = URI.create(location = location.substring(10, location.length()))).getPath() == null ? "" : uri.getPath()) + "bin" + '/' + res).normalize()).isAbsolute()) {
                url = newUri.toURL();
            }
            if (url != null) {
                File f = new File(url.getFile());
                if (f.exists()) {
                    resources.add(url);
                }
            } else {
                return Collections.emptyEnumeration();
            }
            return Collections.enumeration(resources);
        }
    }
}

