/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.AwtScreenshot;
import org.eclipse.test.ClassLoaderTools;
import org.eclipse.test.LegacyXmlResultFormatter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class EclipseTestRunner {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private static final int SECONDS_BEFORE_TIMEOUT_BUFFER = 120;
    private static final int SECONDS_BETWEEN_DUMPS = 5;

    public static void main(String[] args) throws IOException {
        System.exit(EclipseTestRunner.run(args));
    }

    public static int run(String[] args) throws IOException {
        String className = null;
        String classesNames = null;
        String testPluginName = null;
        String testPluginsNames = null;
        String resultPathString = null;
        String timeoutString = null;
        String junitReportOutput = null;
        Properties props = new Properties();
        int startArgs = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            className = args[0];
            ++startArgs;
        }
        int i = startArgs;
        while (i < args.length) {
            block44: {
                Object formatterString;
                if (args[i].toLowerCase().equals("-classname")) {
                    if (i < args.length - 1) {
                        className = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-classesnames")) {
                    if (i < args.length - 1) {
                        classesNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginname")) {
                    if (i < args.length - 1) {
                        testPluginName = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginsnames")) {
                    if (i < args.length - 1) {
                        testPluginsNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].equals("-junitReportOutput")) {
                    if (i < args.length - 1) {
                        junitReportOutput = args[i + 1];
                    }
                    ++i;
                } else if (args[i].startsWith("haltOnError=")) {
                    System.err.println("The haltOnError option is no longer supported");
                } else if (args[i].startsWith("haltOnFailure=")) {
                    System.err.println("The haltOnFailure option is no longer supported");
                } else if (args[i].startsWith("formatter=")) {
                    formatterString = args[i].substring(10);
                    int seperatorIndex22 = ((String)formatterString).indexOf(44);
                    resultPathString = seperatorIndex22 == -1 ? null : ((String)formatterString).substring(seperatorIndex22 + 1);
                } else {
                    if (args[i].startsWith("propsfile=")) {
                        formatterString = null;
                        Object seperatorIndex22 = null;
                        try (FileInputStream in = new FileInputStream(args[i].substring(10));){
                            props.load(in);
                            break block44;
                        }
                        catch (Throwable seperatorIndex22) {
                            if (formatterString == null) {
                                formatterString = seperatorIndex22;
                            } else if (formatterString != seperatorIndex22) {
                                ((Throwable)formatterString).addSuppressed(seperatorIndex22);
                            }
                            throw formatterString;
                        }
                    }
                    if (args[i].equals("-testlistener")) {
                        System.err.println("The testlistener option is no longer supported");
                    } else if (args[i].equals("-timeout")) {
                        if (i < args.length - 1) {
                            timeoutString = args[i + 1];
                        }
                        ++i;
                    }
                }
            }
            ++i;
        }
        Properties p = System.getProperties();
        Enumeration _enum = ((Hashtable)p).keys();
        while (_enum.hasMoreElements()) {
            Object key = _enum.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        if (timeoutString == null || timeoutString.isEmpty()) {
            System.err.println("INFO: optional timeout was not specified.");
        } else {
            String timeoutScreenOutputDir = null;
            timeoutScreenOutputDir = junitReportOutput == null || junitReportOutput.isEmpty() ? "timeoutScreens" : String.valueOf(junitReportOutput) + "/timeoutScreens";
            System.err.println("INFO: timeoutScreenOutputDir: " + timeoutScreenOutputDir);
            System.err.println("INFO: timeout: " + timeoutString);
            EclipseTestRunner.startStackDumpTimeoutTimer(timeoutString, new File(timeoutScreenOutputDir), className);
        }
        if (testPluginsNames != null && classesNames != null) {
            String[] testPlugins = testPluginsNames.split(",");
            String[] suiteClasses = classesNames.split(",");
            int returnCode = 0;
            int j = 0;
            EclipseTestRunner runner = new EclipseTestRunner();
            String[] stringArray = suiteClasses;
            int n = suiteClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String oneClassName = stringArray[n2];
                int result = runner.runTests(props, testPlugins[j], oneClassName, resultPathString, true);
                ++j;
                if (result != 0) {
                    returnCode = result;
                }
                ++n2;
            }
            return returnCode;
        }
        if (className == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        EclipseTestRunner runner = new EclipseTestRunner();
        return runner.runTests(props, testPluginName, className, resultPathString, false);
    }

    private int runTests(Properties props, String testPluginName, String testClassName, String resultPath, boolean multiTest) {
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        ExecutionListener executionListener = new ExecutionListener();
        if (testPluginName == null) {
            testPluginName = ClassLoaderTools.getClassPlugin(testClassName);
        }
        if (testPluginName == null) {
            throw new IllegalArgumentException("Test class not found");
        }
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)testClassName)}).build();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderTools.getJUnit5Classloader(this.getPlatformEngines()));
            Launcher launcher = LauncherFactory.create();
            Thread.currentThread().setContextClassLoader(ClassLoaderTools.getPluginClassLoader(testPluginName, currentTCCL));
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (LegacyXmlResultFormatter legacyXmlResultFormatter = new LegacyXmlResultFormatter();){
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (OutputStream fileOutputStream = this.getResultOutputStream(resultPath, testClassName, multiTest);){
                        legacyXmlResultFormatter.setDestination(fileOutputStream);
                        legacyXmlResultFormatter.setContext(new ExecutionContext(props));
                        launcher.execute(request, new TestExecutionListener[]{legacyXmlResultFormatter, executionListener});
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Thread.currentThread().setContextClassLoader(currentTCCL);
                return 2;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
        return executionListener.didExecutionContainedFailures() ? 1 : 0;
    }

    private OutputStream getResultOutputStream(String resultPathString, String testClassName, boolean multiTest) throws IOException {
        File resultFile;
        if (resultPathString == null || resultPathString.isEmpty()) {
            return System.out;
        }
        if (multiTest) {
            Path resultDirectoryPath = new Path(resultPathString);
            File testDirectory = resultDirectoryPath.toFile();
            if (!testDirectory.exists()) {
                testDirectory.mkdirs();
            }
            resultFile = resultDirectoryPath.append("TEST-" + testClassName + ".xml").toFile();
        } else {
            Path resultPath = new Path(resultPathString);
            resultFile = resultPath.toFile();
            if (resultFile.isDirectory()) {
                resultFile = resultPath.append("TEST-" + testClassName + ".xml").toFile();
            } else {
                File resultDirectory = resultFile.getParentFile();
                if (!resultDirectory.exists()) {
                    resultDirectory.mkdirs();
                }
            }
        }
        if (!resultFile.exists()) {
            resultFile.createNewFile();
        }
        return new FileOutputStream(resultFile);
    }

    private List<String> getPlatformEngines() {
        Bundle[] bundles;
        ArrayList<String> platformEngines = new ArrayList<String>();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Bundle[] bundleArray = bundles = bundle.getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle iBundle = bundleArray[n2];
            try {
                BundleWiring bundleWiring = (BundleWiring)Platform.getBundle((String)iBundle.getSymbolicName()).adapt(BundleWiring.class);
                Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                if (!listResources.isEmpty()) {
                    platformEngines.add(iBundle.getSymbolicName());
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return platformEngines;
    }

    private static void startStackDumpTimeoutTimer(final String timeoutArg, final File outputDirectory, final String classname) {
        try {
            int delay = 120000;
            int timeout = Integer.parseInt(timeoutArg) - delay;
            String time0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
            System.err.println("starting EclipseTestRunner Timer with timeout=" + timeout + " at " + time0);
            if (timeout > 0) {
                new Timer("EclipseTestRunner Timer", true).schedule(new TimerTask(){
                    volatile boolean assumeUiThreadIsResponsive;

                    @Override
                    public void run() {
                        this.assumeUiThreadIsResponsive = true;
                        this.dump(0);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.dump(5);
                    }

                    private void dump(int num) {
                        long start = System.currentTimeMillis();
                        this.dumpStackTraces(num, System.err);
                        this.dumpStackTraces(num, System.out);
                        this.logStackTraces(num);
                        if (!this.dumpSwtDisplay(num)) {
                            String screenshotFile = this.getScreenshotFile(num);
                            EclipseTestRunner.dumpAwtScreenshot(screenshotFile);
                        }
                        long elapsedTimeMillis = System.currentTimeMillis() - start;
                        float elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f;
                        System.err.println("INFO: Seconds to do dump " + num + ": " + elapsedTimeSec);
                    }

                    private void logStackTraces(int num) {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        this.dumpStackTraces(num, new PrintStream(outputStream));
                        String symbolicName = "org.eclipse.test";
                        Status warningStatus = new Status(2, symbolicName, outputStream.toString());
                        Platform.getLog((Bundle)Platform.getBundle((String)symbolicName)).log((IStatus)warningStatus);
                    }

                    private void dumpStackTraces(int num, PrintStream out) {
                        out.println("EclipseTestRunner almost reached timeout '" + timeoutArg + "'.");
                        out.println("totalMemory:            " + Runtime.getRuntime().totalMemory());
                        out.println("freeMemory (before GC): " + Runtime.getRuntime().freeMemory());
                        out.flush();
                        System.gc();
                        out.println("freeMemory (after GC):  " + Runtime.getRuntime().freeMemory());
                        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
                        out.println("Thread dump " + num + " at " + time + ":");
                        out.flush();
                        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                            String name = entry.getKey().getName();
                            StackTraceElement[] stack = entry.getValue();
                            ThreadDump exception = new ThreadDump("for thread \"" + name + "\"");
                            exception.setStackTrace(stack);
                            exception.printStackTrace(out);
                        }
                        out.flush();
                    }

                    String getScreenshotFile(int num) {
                        if (!outputDirectory.exists()) {
                            outputDirectory.mkdirs();
                        }
                        String filename = String.valueOf(outputDirectory.getAbsolutePath()) + "/" + classname + "_screen" + num + ".png";
                        return filename;
                    }

                    private boolean dumpSwtDisplay(final int num) {
                        try {
                            final Display display = Display.getDefault();
                            if (!this.assumeUiThreadIsResponsive) {
                                String message = "trying to make UI thread respond";
                                IllegalStateException toThrow = new IllegalStateException(message);
                                Thread t = display.getThread();
                                toThrow.initCause(new RuntimeException(message));
                                toThrow.setStackTrace(t.getStackTrace());
                                try {
                                    t.stop(toThrow);
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    try {
                                        Method stop0 = Thread.class.getDeclaredMethod("stop0", Object.class);
                                        stop0.setAccessible(true);
                                        stop0.invoke((Object)t, toThrow);
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                            this.assumeUiThreadIsResponsive = false;
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    assumeUiThreadIsResponsive = true;
                                    this.dumpDisplayState(System.err);
                                    this.dumpDisplayState(System.out);
                                    GC gc = new GC((Drawable)display);
                                    Image image = new Image((Device)display, display.getBounds());
                                    gc.copyArea(image, 0, 0);
                                    gc.dispose();
                                    ImageLoader loader = new ImageLoader();
                                    loader.data = new ImageData[]{image.getImageData()};
                                    String filename = this.getScreenshotFile(num);
                                    loader.save(filename, 5);
                                    System.err.println("Screenshot saved to: " + filename);
                                    System.out.println("Screenshot saved to: " + filename);
                                    image.dispose();
                                }

                                private void dumpDisplayState(PrintStream out) {
                                    Shell[] shells;
                                    Control focusControl = display.getFocusControl();
                                    if (focusControl != null) {
                                        out.println("FocusControl: ");
                                        StringBuilder indent = new StringBuilder("  ");
                                        do {
                                            out.println(String.valueOf(indent.toString()) + focusControl);
                                            focusControl = focusControl.getParent();
                                            indent.append("  ");
                                        } while (focusControl != null);
                                    }
                                    if ((shells = display.getShells()).length > 0) {
                                        out.println("Shells: ");
                                        Shell[] shellArray = shells;
                                        int n = shells.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Shell shell = shellArray[n2];
                                            out.println(String.valueOf(shell.isVisible() ? "  visible: " : "  invisible: ") + shell);
                                            ++n2;
                                        }
                                    }
                                    out.flush();
                                }
                            });
                            return true;
                        }
                        catch (SWTException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                }, timeout);
            } else {
                System.err.println("EclipseTestRunner argument error: '-timeout " + timeoutArg + "' was too short to accommodate time delay required (" + delay + ").");
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public static void dumpAwtScreenshot(String screenshotFile) {
        try {
            URL location = AwtScreenshot.class.getProtectionDomain().getCodeSource().getLocation();
            String cp = location.toURI().getPath();
            String javaHome = System.getProperty("java.home");
            String javaExe = String.valueOf(javaHome) + File.separatorChar + "bin" + File.separatorChar + "java";
            if (File.separatorChar == '\\') {
                javaExe = String.valueOf(javaExe) + ".exe";
            }
            String[] args = new String[]{javaExe, "-cp", cp, AwtScreenshot.class.getName(), screenshotFile};
            System.err.println("Start process: " + Arrays.asList(args));
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                processBuilder.environment().put("AWT_TOOLKIT", "CToolkit");
            }
            Process process = processBuilder.start();
            new StreamForwarder(process.getErrorStream(), System.err).start();
            new StreamForwarder(process.getInputStream(), System.err).start();
            int screenshotTimeout = 15;
            long end = System.currentTimeMillis() + (long)(screenshotTimeout * 1000);
            boolean done = false;
            do {
                try {
                    process.exitValue();
                    done = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (!done && System.currentTimeMillis() < end);
            if (done) {
                System.err.println("AwtScreenshot VM finished with exit code " + process.exitValue() + ".");
            } else {
                process.destroy();
                System.err.println("Killed AwtScreenshot VM after " + screenshotTimeout + " seconds.");
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private final class ExecutionContext
    implements TestExecutionContext {
        private final Properties props;

        ExecutionContext(Properties props) {
            this.props = props;
        }

        public Properties getProperties() {
            return this.props;
        }

        public Optional<Project> getProject() {
            return null;
        }
    }

    private final class ExecutionListener
    implements TestExecutionListener {
        private boolean executionContainedFailures = false;

        public boolean didExecutionContainedFailures() {
            return this.executionContainedFailures;
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                this.executionContainedFailures = true;
            }
        }
    }

    static class StreamForwarder
    extends Thread {
        private InputStream fProcessOutput;
        private PrintStream fStream;

        public StreamForwarder(InputStream processOutput, PrintStream stream) {
            this.fProcessOutput = processOutput;
            this.fStream = stream;
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.fProcessOutput));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.fStream.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class ThreadDump
    extends Exception {
        private static final long serialVersionUID = 1L;

        ThreadDump(String message) {
            super(message);
        }
    }
}

