/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.eclipse.urischeme.IUriSchemeProcessor;
import org.eclipse.urischeme.internal.UriSchemeProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UriSchemeProcessorUnitTest {
    private static final String ABC_SCHEME = "abc";
    private static final String XYZ_SCHEME = "xyz";
    private static final String ABC_URI = "abc://test";
    private static final String XYZ_URI = "xyz://test";
    private HandlerMock abcHandler;
    private ConfigElementMock configElementForAbc;
    private UriSchemeProcessor schemeProcessor;

    @Before
    public void setup() throws Exception {
        this.abcHandler = new HandlerMock();
        this.configElementForAbc = new ConfigElementMock(ABC_SCHEME, this.abcHandler);
        this.schemeProcessor = new UriSchemeProcessor();
        this.registerExtensions((IUriSchemeProcessor)this.schemeProcessor, this.configElementForAbc);
    }

    @Test
    public void callsRegisteredlUriSchemeHandler() throws Exception {
        this.schemeProcessor.handleUri(ABC_SCHEME, ABC_URI);
        String errorMsg = "Registered handler was not called for 'abc://test'";
        Assert.assertTrue((String)errorMsg, (boolean)this.abcHandler.handled.contains(ABC_URI));
    }

    @Test
    public void doesntCallHandlerForUnregisteredScheme() throws Exception {
        this.schemeProcessor.handleUri(XYZ_SCHEME, XYZ_URI);
        Assert.assertFalse((boolean)this.abcHandler.called);
    }

    @Test
    public void callsFirstOfTwoHandlersForSameScheme() throws Exception {
        HandlerMock secondAbcHandler = new HandlerMock();
        ConfigElementMock secondConfigElementForAbc = new ConfigElementMock(ABC_SCHEME, secondAbcHandler);
        this.registerExtensions((IUriSchemeProcessor)this.schemeProcessor, this.configElementForAbc, secondConfigElementForAbc);
        this.schemeProcessor.handleUri(ABC_SCHEME, ABC_URI);
        Assert.assertTrue((boolean)this.abcHandler.called);
        Assert.assertFalse((boolean)secondAbcHandler.called);
    }

    @Test
    public void buffersExtensionAndCreatesThemOnlyOnce() throws Exception {
        this.schemeProcessor.handleUri(ABC_SCHEME, ABC_URI);
        this.schemeProcessor.handleUri(ABC_SCHEME, ABC_URI);
        Assert.assertTrue((boolean)this.abcHandler.called);
        Assert.assertEquals((String)"Extension created more than once", (long)1L, (long)this.configElementForAbc.extensionCreatedCount);
    }

    @Test(expected=CoreException.class)
    public void throwExceptionOnWrongRegisteredType() throws Exception {
        Object handlerWithWrongType = new Object();
        ConfigElementMock element = new ConfigElementMock(ABC_SCHEME, handlerWithWrongType);
        this.registerExtensions((IUriSchemeProcessor)this.schemeProcessor, element);
        this.schemeProcessor.handleUri(ABC_SCHEME, ABC_URI);
    }

    private void registerExtensions(IUriSchemeProcessor instance, IConfigurationElement ... element) throws Exception {
        Field configurationElementsFields = UriSchemeProcessor.class.getDeclaredField("configurationElements");
        configurationElementsFields.setAccessible(true);
        configurationElementsFields.set(instance, element);
    }

    private final class ConfigElementMock
    implements IConfigurationElement {
        private final String uriScheme;
        private final Object handler;
        public int extensionCreatedCount = 0;

        private ConfigElementMock(String uriScheme, Object handler) {
            this.uriScheme = uriScheme;
            this.handler = handler;
        }

        public boolean isValid() {
            return false;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public int getHandleId() {
            return 0;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals("uriScheme")) {
                return this.uriScheme;
            }
            return null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            ++this.extensionCreatedCount;
            return this.handler;
        }
    }

    private class HandlerMock
    implements IUriSchemeHandler {
        public Set<String> handled = new HashSet<String>();
        public boolean called = false;

        private HandlerMock() {
        }

        public void handle(String uri) {
            this.called = true;
            this.handled.add(uri);
        }
    }
}

