/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.urischeme.internal.registration.DesktopFileWriter;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitDesktopFileWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String NO_MIME = "";

    @Test
    public void addsOneScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        writer.addScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void addTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        writer.addScheme("adt");
        writer.addScheme("other");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
    }

    @Test
    public void addsSecondToExistingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("other");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
    }

    @Test
    public void doesntAddSchemeIfExisting() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("&/%");
    }

    @Test
    public void removesScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.not(this.contains("MimeType")));
    }

    @Test
    public void removesFirstOfTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
        writer.removeScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/other;"));
    }

    @Test
    public void removesLastOfTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
        writer.removeScheme("other");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void removesSecondOfThreeSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;x-scheme-handler/yetAnother;"));
        writer.removeScheme("other");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/yetAnother;"));
    }

    @Test
    public void removesNonExistingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("other");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("&/%");
    }

    @Test
    public void doesNothing() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void removesEmptyMimeType() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.not(this.contains("MimeType")));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnEmptyDocument() {
        this.getWriterFor(Collections.emptyList());
    }

    @Test
    public void keepsComments() {
        String comment = "# comment=test";
        ArrayList<String> fileContent = new ArrayList<String>(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        fileContent.add(comment);
        DesktopFileWriter writer = this.getWriterFor(fileContent);
        Assert.assertThat((Object)new String(writer.getResult()), (Matcher)new StringEndsWith(comment));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnNonPropertiesFile() {
        this.getWriterFor(Arrays.asList("foo=bar"));
    }

    @Test
    public void addsUriPlaceholderToExecLineWhenAddingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", NO_MIME));
        writer.addScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void addsAddUriPlaceholderToExecLineWhenJustGettingResult() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", NO_MIME));
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void addsAddUriPlaceholderToExecLineWhenRemovingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        Assert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void returnsRegisteredSchemeOnerequested() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        List schemes = writer.getRegisteredSchemes(Arrays.asList("adt"));
        Assert.assertEquals((long)1L, (long)schemes.size());
        Assert.assertTrue((boolean)schemes.contains("adt"));
    }

    @Test
    public void returnsRegisteredSchemeTwoRequested() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        List schemes = writer.getRegisteredSchemes(Arrays.asList("adt", "other"));
        Assert.assertEquals((long)1L, (long)schemes.size());
        Assert.assertTrue((boolean)schemes.contains("adt"));
    }

    @Test
    public void returnsNoRegisteredSchemeTwoRequested() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/yetAnother;"));
        List schemes = writer.getRegisteredSchemes(Arrays.asList("adt", "other"));
        Assert.assertEquals((long)0L, (long)schemes.size());
    }

    @Test
    public void returnsNoRegisteredSchemeTwoRequestedNoneRegistered() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        List schemes = writer.getRegisteredSchemes(Arrays.asList("adt", "other"));
        Assert.assertEquals((long)0L, (long)schemes.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getRegisteredFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.getRegisteredSchemes(Arrays.asList("&/%"));
    }

    @Test
    public void keepsPropertiesOrder() {
        List<String> fileContent = this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;");
        DesktopFileWriter writer = this.getWriterFor(fileContent);
        String expected = String.join((CharSequence)LINE_SEPARATOR, fileContent);
        Assert.assertThat((Object)new String(writer.getResult()), (Matcher)new IsEqual((Object)expected));
    }

    private Matcher<String> containsLine(String line) {
        return AnyOf.anyOf((Matcher)new StringContains(String.valueOf(LINE_SEPARATOR) + line + LINE_SEPARATOR), (Matcher)new StringContains(String.valueOf(LINE_SEPARATOR) + line));
    }

    private Matcher<String> contains(String line) {
        return new StringContains(line);
    }

    private Matcher<String> not(Matcher<String> not) {
        return new IsNot(not);
    }

    private DesktopFileWriter getWriterFor(List<String> fileContent) {
        return new DesktopFileWriter(fileContent);
    }

    private List<String> fileContentWith(String execLine, String mimeTypeLine) {
        return Arrays.asList("[Desktop Entry]", "Encoding=UTF-8", "Name=Eclipse 4.4.1", "Comment=Eclipse Luna", String.valueOf(execLine), "Icon=/opt/eclipse/icon.xpm", "Categories=Application;Development;Java;IDE", "Version=1.0", "Type=Application", "Terminal=0", mimeTypeLine);
    }
}

