/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.CopyOnWriteTextStore;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ITextStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CopyOnWriteTextStoreTest {
    private static final String INITIAL_CONTENT = "xxxxx";
    private COWTextStore fText;

    @Before
    public void setUp() {
        this.fText = new COWTextStore();
        this.fText.set(INITIAL_CONTENT);
    }

    @After
    public void tearDown() {
        this.fText = null;
    }

    @Test
    public void testInitialContent() {
        Assert.assertEquals((Object)INITIAL_CONTENT, (Object)this.fText.get());
        boolean failed = false;
        try {
            this.fText.getStore().replace(0, 0, null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testFirstModification() {
        this.checkReplace(1, 1, "y");
        Assert.assertEquals(GapTextStore.class, this.fText.getStore().getClass());
    }

    @Test
    public void testSet() {
        this.fText.replace(1, 1, "y");
        this.fText.set(INITIAL_CONTENT);
        Assert.assertEquals((Object)INITIAL_CONTENT, (Object)this.fText.get());
        boolean failed = false;
        try {
            this.fText.getStore().replace(0, 0, null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testInsert1() {
        int i = 1;
        while (i < 5) {
            this.checkReplace(2 * i - 1, 0, "y");
            ++i;
        }
    }

    @Test
    public void testInsert2() {
        int i = 1;
        while (i < 5) {
            this.checkReplace(2 * (i - 1), 0, "y");
            ++i;
        }
    }

    @Test
    public void testDelete1() {
        int i = 1;
        while (i < 5) {
            this.checkReplace(0, 1, "");
            ++i;
        }
    }

    @Test
    public void testDelete2() {
        int i = 1;
        while (i < 5) {
            this.checkReplace(this.fText.getLength() - 1, 1, "");
            ++i;
        }
    }

    @Test
    public void testAppend() {
        int i = 1;
        while (i < 5) {
            this.checkReplace(this.fText.getLength(), 0, "y");
            ++i;
        }
    }

    private void checkReplace(int offset, int length, String text) {
        StringBuffer buf = new StringBuffer(this.fText.get());
        buf.replace(offset, offset + length, text);
        this.fText.replace(offset, length, text);
        Assert.assertEquals((Object)buf.toString(), (Object)this.fText.get());
    }

    private static class COWTextStore
    extends CopyOnWriteTextStore {
        COWTextStore() {
            super((ITextStore)new GapTextStore());
        }

        ITextStore getStore() {
            return this.fTextStore;
        }

        String get() {
            return this.get(0, this.getLength());
        }
    }
}

