/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.tests.AbstractLineTrackerTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LineTrackerTest4
extends AbstractLineTrackerTest {
    @Before
    public void setUp() {
        this.fText = new GapTextStore();
        this.fTracker = new ConfigurableLineTracker(new String[]{"\r\n"});
        this.set("x\r\nx\r\nx\r\nx\r\nx\r\n");
    }

    @After
    public void tearDown() {
        this.fTracker = null;
        this.fText = null;
    }

    @Override
    protected int getLineOffset(int line, int[] lines) {
        int offset = 0;
        int i = 0;
        while (i < line) {
            offset += lines[i] + 2;
            ++i;
        }
        return offset;
    }

    @Test
    public void testEditScript1() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "x");
        this.checkLines(new int[]{1});
        this.replace(1, 0, "y");
        this.checkLines(new int[]{2});
        this.replace(2, 0, "z");
        this.checkLines(new int[]{3});
        this.replace(3, 0, "\r\n");
        int[] nArray2 = new int[2];
        nArray2[0] = 3;
        this.checkLines(nArray2);
        this.replace(5, 0, "x");
        this.checkLines(new int[]{3, 1});
    }

    @Test
    public void testEmptyLines() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, 15, null);
        this.checkLines(new int[1]);
        this.replace(0, 0, "\r\n\r\n\r\n\r\n\r\n");
        this.checkLines(new int[6]);
        int i = 0;
        while (i < 10) {
            int no = this.fTracker.getLineNumberOfOffset(i);
            double l = Math.floor(i / 2);
            Assert.assertTrue((String)("invalid line number " + no + " for position " + i + " should be " + l), (l == (double)no ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testInsert1() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(4, 0, "yyyy");
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[1] = 5;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.checkLines(nArray2);
        this.replace(11, 0, "y\r\n");
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[1] = 5;
        nArray3[2] = 2;
        nArray3[4] = 1;
        nArray3[5] = 1;
        this.checkLines(nArray3);
        this.replace(14, 0, "y\r\n");
        int[] nArray4 = new int[8];
        nArray4[0] = 1;
        nArray4[1] = 5;
        nArray4[2] = 2;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        this.checkLines(nArray4);
        this.replace(17, 0, "y");
        int[] nArray5 = new int[8];
        nArray5[0] = 1;
        nArray5[1] = 5;
        nArray5[2] = 2;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        this.checkLines(nArray5);
    }

    @Test
    public void testInsert2() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(4, 0, "yyyy");
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[1] = 5;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.checkLines(nArray2);
        this.replace(11, 0, "y\r\ny\r\ny");
        int[] nArray3 = new int[8];
        nArray3[0] = 1;
        nArray3[1] = 5;
        nArray3[2] = 2;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        this.checkLines(nArray3);
    }

    @Test
    public void testLinesNumbers() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, 15, "\r\na\r\nbb\r\nccc\r\ndddd\r\neeeee\r\n");
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        this.checkLines(nArray2);
        int offset = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j <= i) {
                int no = this.fTracker.getLineNumberOfOffset(offset + j);
                Assert.assertTrue((String)("invalid line number " + no + " reported instead of " + i), (no == i ? 1 : 0) != 0);
                ++j;
            }
            offset += i + 2;
            ++i;
        }
    }

    @Test
    public void testOffsets() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        int i = 0;
        while (i < 5) {
            IRegion line = this.fTracker.getLineInformation(i);
            int pos = line.getOffset() + line.getLength() + 1;
            int offset = 3 * i + 2;
            Assert.assertTrue((String)("invalid line end offset " + pos + " for line " + i + " should be " + offset), (offset == pos ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            int offset = 3 * i;
            Assert.assertTrue((String)("invalid line start offset " + pos + " for line " + i + " should be " + offset), (pos == offset ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 15) {
            int line = this.fTracker.getLineNumberOfOffset(i);
            double l = Math.floor(i / 3);
            Assert.assertTrue((String)("invalid line number " + line + " for position " + i + " should be " + l), (l == (double)line ? 1 : 0) != 0);
            ++i;
        }
        int lastLine = this.fTracker.getLineNumberOfOffset(this.fText.getLength());
        Assert.assertTrue((String)("invalid last line number " + lastLine), (5 == lastLine ? 1 : 0) != 0);
        int offset = this.fTracker.getLineOffset(lastLine);
        Assert.assertTrue((String)("invalid last line start offset " + offset), (this.fText.getLength() == offset ? 1 : 0) != 0);
        int length = this.fTracker.getLineLength(lastLine);
        Assert.assertTrue((String)("invalid last line end offset " + (offset + length - 1)), (length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(4, 2, null);
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 1;
        nArray2[3] = 1;
        this.checkLines(nArray2);
        this.replace(8, 2, null);
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[1] = 2;
        nArray3[2] = 2;
        this.checkLines(nArray3);
        this.replace(4, 7, null);
        this.checkLines(new int[]{1, 1});
        this.replace(0, 4, null);
        this.checkLines(new int[1]);
    }

    @Test
    public void testReplace() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "\tx\r\n\tx\r\n\tx\r\n\tx\r\n\tx\r\n");
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
    }

    @Test
    public void testShiftLeft() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "\tx\r\n\tx\r\n\tx\r\n\tx\r\n\tx\r\n");
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 1, null);
            ++i;
        }
        String txt = this.fText.get(0, this.fText.getLength());
        Assert.assertEquals((String)"invalid text", (Object)"x\r\nx\r\nx\r\nx\r\nx\r\n", (Object)txt);
    }

    @Test
    public void testShiftRight() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 0, "\t");
            ++i;
        }
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
        String txt = this.fText.get(0, this.fText.getLength());
        Assert.assertEquals((String)"invalid text", (Object)"\tx\r\n\tx\r\n\tx\r\n\tx\r\n\tx\r\n", (Object)txt);
    }
}

