/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.projection.Fragment;
import org.eclipse.jface.text.projection.Segment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectionDocumentTest {
    private static boolean LINES = true;
    private ProjectionDocument fSlaveDocument;
    private IDocument fMasterDocument;
    private ISlaveDocumentManager fSlaveDocumentManager;

    private String getOriginalMasterContents() {
        return LINES ? "1111111111111111111\n2222222222222222222\n3333333333333333333\n4444444444444444444\n5555555555555555555\n6666666666666666666\n7777777777777777777\n8888888888888888888\n9999999999999999999\n" : "111111111111111111112222222222222222222233333333333333333333444444444444444444445555555555555555555566666666666666666666777777777777777777778888888888888888888899999999999999999999";
    }

    @Before
    public void setUp() {
        this.fMasterDocument = new Document();
        this.fMasterDocument.set(this.getOriginalMasterContents());
        this.fSlaveDocumentManager = new ProjectionDocumentManager();
        this.fSlaveDocument = (ProjectionDocument)this.fSlaveDocumentManager.createSlaveDocument(this.fMasterDocument);
    }

    @After
    public void tearDown() {
        this.fSlaveDocumentManager.freeSlaveDocument((IDocument)this.fSlaveDocument);
        this.fSlaveDocument = null;
        this.fSlaveDocumentManager = null;
    }

    private void createIdenticalProjection() {
        int offset = 0;
        int length = this.fMasterDocument.getLength();
        try {
            this.fSlaveDocument.addMasterDocumentRange(offset, length);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    private void createProjectionA() {
        this.createProjectionA(this.fSlaveDocument);
    }

    private void createProjectionA(ProjectionDocument projection) {
        try {
            projection.addMasterDocumentRange(0, 20);
            projection.addMasterDocumentRange(40, 20);
            projection.addMasterDocumentRange(80, 20);
            projection.addMasterDocumentRange(120, 20);
            projection.addMasterDocumentRange(160, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    private String getProjectionASlaveContents() {
        return LINES ? "1111111111111111111\n3333333333333333333\n5555555555555555555\n7777777777777777777\n9999999999999999999\n" : "1111111111111111111133333333333333333333555555555555555555557777777777777777777799999999999999999999";
    }

    private void createProjectionB() {
        this.createProjectionB(this.fSlaveDocument);
    }

    private void createProjectionB(ProjectionDocument projection) {
        try {
            projection.addMasterDocumentRange(20, 20);
            projection.addMasterDocumentRange(60, 20);
            projection.addMasterDocumentRange(100, 20);
            projection.addMasterDocumentRange(140, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    private String getProjectionBSlaveContents() {
        return LINES ? "2222222222222222222\n4444444444444444444\n6666666666666666666\n8888888888888888888\n" : "22222222222222222222444444444444444444446666666666666666666688888888888888888888";
    }

    private String print(Position p) {
        return "[" + p.getOffset() + "," + p.getLength() + "]";
    }

    private void assertWellFormedSegmentation() {
        Position[] segmentation = this.fSlaveDocument.getSegments2();
        Assert.assertNotNull((Object)segmentation);
        Position previous = null;
        int i = 0;
        while (i < segmentation.length) {
            Assert.assertFalse((segmentation.length > 1 && segmentation[i].getLength() == 0 && i < segmentation.length - 1 ? 1 : 0) != 0);
            if (previous != null) {
                Assert.assertTrue((previous.getOffset() + previous.getLength() == segmentation[i].getOffset() ? 1 : 0) != 0);
            }
            previous = segmentation[i];
            ++i;
        }
    }

    private void assertWellFormedFragmentation() {
        Position[] segmentation = this.fSlaveDocument.getSegments2();
        Assert.assertNotNull((Object)segmentation);
        Position[] fragmention = this.fSlaveDocument.getFragments2();
        Assert.assertNotNull((Object)fragmention);
        Assert.assertTrue((fragmention.length == segmentation.length ? 1 : 0) != 0);
        Fragment previous = null;
        int i = 0;
        while (i < segmentation.length) {
            Segment segment = (Segment)segmentation[i];
            Fragment fragment = (Fragment)fragmention[i];
            Assert.assertTrue((fragment == segment.fragment ? 1 : 0) != 0);
            Assert.assertTrue((segment == fragment.segment ? 1 : 0) != 0);
            Assert.assertFalse((segmentation.length > 1 && fragment.getLength() == 0 && i < segmentation.length - 1 ? 1 : 0) != 0);
            Assert.assertTrue((fragment.length == segment.length ? 1 : 0) != 0);
            if (previous != null && i < segmentation.length - 1) {
                Assert.assertFalse((previous.getOffset() + previous.getLength() == fragment.getOffset() ? 1 : 0) != 0);
            }
            previous = fragment;
            ++i;
        }
    }

    private void assertFragmentation(Position[] expected) {
        this.assertFragmentation(expected, true);
    }

    private void assertFragmentation(Position[] expected, boolean checkWellFormedness) {
        Position[] segmentation;
        if (checkWellFormedness) {
            this.assertWellFormedSegmentation();
            this.assertWellFormedFragmentation();
        }
        Assert.assertTrue((String)"invalid number of segments", (expected.length == (segmentation = this.fSlaveDocument.getSegments2()).length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Segment segment = (Segment)segmentation[i];
            Fragment actual = segment.fragment;
            Assert.assertEquals((String)(String.valueOf(this.print((Position)actual)) + " != " + this.print(expected[i])), (Object)expected[i], (Object)actual);
            ++i;
        }
    }

    private void assertLineInformationConsistency(IDocument document) {
        DefaultLineTracker textTracker = new DefaultLineTracker();
        textTracker.set(document.get());
        int textLines = textTracker.getNumberOfLines();
        int trackerLines = document.getNumberOfLines();
        Assert.assertEquals((long)trackerLines, (long)textLines);
        int i = 0;
        while (i < trackerLines) {
            try {
                IRegion trackerLine = document.getLineInformation(i);
                IRegion textLine = textTracker.getLineInformation(i);
                Assert.assertEquals((long)trackerLine.getOffset(), (long)textLine.getOffset());
                Assert.assertEquals((long)trackerLine.getLength(), (long)textLine.getLength());
            }
            catch (BadLocationException badLocationException) {
                Assert.assertTrue((boolean)false);
            }
            ++i;
        }
    }

    private void assertContents(String expected, IDocument document) {
        this.assertWellFormedSegmentation();
        this.assertWellFormedFragmentation();
        Assert.assertEquals((Object)expected, (Object)document.get());
        this.assertLineInformationConsistency(document);
    }

    private void assertSlaveContents(String expected) {
        this.assertContents(expected, (IDocument)this.fSlaveDocument);
    }

    private void assertMasterContents(String expected) {
        this.assertContents(expected, this.fMasterDocument);
    }

    @Test
    public void test1() {
        this.createIdenticalProjection();
        this.assertSlaveContents(this.fMasterDocument.get());
    }

    @Test
    public void test2() {
        this.createIdenticalProjection();
        try {
            this.fMasterDocument.replace(0, this.fMasterDocument.getLength(), "nothing");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.fMasterDocument.get());
    }

    @Test
    public void test3() {
        this.createProjectionA();
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test4() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(145, 5, "~");
            this.fMasterDocument.replace(105, 5, "~");
            this.fMasterDocument.replace(65, 5, "~");
            this.fMasterDocument.replace(25, 5, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test5() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(165, 5, "~");
            this.fMasterDocument.replace(125, 5, "~");
            this.fMasterDocument.replace(85, 5, "~");
            this.fMasterDocument.replace(45, 5, "~");
            this.fMasterDocument.replace(5, 5, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(85, 90, "~");
        buffer.replace(65, 70, "~");
        buffer.replace(45, 50, "~");
        buffer.replace(25, 30, "~");
        buffer.replace(5, 10, "~");
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test6() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(160, 20, "~");
            this.fMasterDocument.replace(120, 20, "~");
            this.fMasterDocument.replace(80, 20, "~");
            this.fMasterDocument.replace(40, 20, "~");
            this.fMasterDocument.replace(0, 20, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
    }

    @Test
    public void test7() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(0, this.fMasterDocument.getLength(), "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
        Position[] expected = new Position[]{new Position(0, 5)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test8_1() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(0, 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~" + this.getProjectionASlaveContents());
    }

    @Test
    public void test8_2() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(0, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents().substring(1));
    }

    @Test
    public void test8_3() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(0, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~" + this.getProjectionASlaveContents().substring(1));
    }

    @Test
    public void test8_4() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(this.fMasterDocument.getLength(), 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(String.valueOf(this.getProjectionASlaveContents()) + "~");
    }

    @Test
    public void test8_5() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(this.fMasterDocument.getLength() - 1, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        String text = this.getProjectionASlaveContents();
        this.assertSlaveContents(text.substring(0, text.length() - 1));
    }

    @Test
    public void test8_6() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(this.fMasterDocument.getLength() - 1, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        String text = this.getProjectionASlaveContents();
        this.assertSlaveContents(String.valueOf(text.substring(0, text.length() - 1)) + "~");
    }

    @Test
    public void test8_7() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(80, 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.insert(40, '~');
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test8_8() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(80, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.deleteCharAt(40);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test8_9() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(80, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(40, 41, "~");
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test8_10() {
        this.test9_1();
    }

    @Test
    public void test8_11() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(99, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.deleteCharAt(59);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test8_12() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(99, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(59, 60, "~");
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test9_1() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(100, 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test9_2() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(100, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test9_3() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(100, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test9_4() {
        this.test8_7();
    }

    @Test
    public void test9_5() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(79, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test9_6() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(79, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test9_7() {
        if (!LINES) {
            return;
        }
        try {
            int startOffset = this.fMasterDocument.getLineOffset(4);
            Assert.assertEquals((long)80L, (long)startOffset);
            int endOffset = this.fMasterDocument.getLineOffset(7);
            Assert.assertEquals((long)140L, (long)endOffset);
            this.fSlaveDocument.addMasterDocumentRange(startOffset, endOffset - startOffset);
            this.assertSlaveContents(this.getOriginalMasterContents().substring(80, 140));
            this.fMasterDocument.replace(endOffset, 1, "x");
            this.assertLineInformationConsistency((IDocument)this.fSlaveDocument);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test10_1() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(50, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(30, 40);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test10_2() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(50, 20, "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 15), new Position(65, 20), new Position(105, 20), new Position(145, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(30, 40, "~~~~~");
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test10_3() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(70, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(40, 50);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test10_4() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(70, 20, "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(70, 15), new Position(105, 20), new Position(145, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(40, 50, "~~~~~");
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test11() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(60, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 40), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
        this.assertSlaveContents(this.getProjectionASlaveContents());
    }

    @Test
    public void test12() {
        this.createProjectionA();
        try {
            this.fMasterDocument.replace(80, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test13() {
        this.createIdenticalProjection();
        try {
            this.fSlaveDocument.replace(0, this.fSlaveDocument.getLength(), "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
        this.assertMasterContents("~~~~~");
    }

    @Test
    public void test14_1() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(0, this.fSlaveDocument.getLength(), "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
        this.assertMasterContents("~~~~~");
    }

    @Test
    public void test14_2() {
        this.createProjectionB();
        try {
            this.fSlaveDocument.replace(0, this.fSlaveDocument.getLength(), "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(20, 160, "~~~~~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test15() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(90, 5, "~");
            this.fSlaveDocument.replace(70, 5, "~");
            this.fSlaveDocument.replace(50, 5, "~");
            this.fSlaveDocument.replace(30, 5, "~");
            this.fSlaveDocument.replace(10, 5, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(90, 95, "~");
        buffer.replace(70, 75, "~");
        buffer.replace(50, 55, "~");
        buffer.replace(30, 35, "~");
        buffer.replace(10, 15, "~");
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(170, 175, "~");
        buffer.replace(130, 135, "~");
        buffer.replace(90, 95, "~");
        buffer.replace(50, 55, "~");
        buffer.replace(10, 15, "~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test16() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(80, 20, "~");
            this.fSlaveDocument.replace(60, 20, "~");
            this.fSlaveDocument.replace(40, 20, "~");
            this.fSlaveDocument.replace(20, 20, "~");
            this.fSlaveDocument.replace(0, 20, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("~~~~~");
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(160, 180, "~");
        buffer.replace(120, 140, "~");
        buffer.replace(80, 100, "~");
        buffer.replace(40, 60, "~");
        buffer.replace(0, 20, "~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_1() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(20, 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.insert(20, '~');
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.insert(40, '~');
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_2() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(20, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.deleteCharAt(20);
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.deleteCharAt(40);
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_3() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(20, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(20, 21, "~");
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(40, 41, "~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_4() {
        this.test17_1();
    }

    @Test
    public void test17_5() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(39, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.deleteCharAt(39);
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.deleteCharAt(59);
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_6() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(39, 1, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(39, 40, "~");
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(59, 60, "~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test17_7() {
        this.createIdenticalProjection();
        String originalSlaveContent = "";
        try {
            this.fSlaveDocument.removeMasterDocumentRange(80, 100);
            originalSlaveContent = this.fSlaveDocument.get();
            this.fSlaveDocument.replace(80, 0, "~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(originalSlaveContent);
        buffer.insert(80, "~");
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.insert(180, "~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test18_1() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(30, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(80, 20), new Position(120, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(30, 50);
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.delete(50, 90);
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test18_2() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(30, 20, "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 25), new Position(85, 20), new Position(125, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.replace(30, 50, "~~~~~");
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(50, 90, "~~~~~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void test19() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.replace(20, 20, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(20, 40);
        this.assertSlaveContents(buffer.toString());
        buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.delete(40, 60);
        this.assertMasterContents(buffer.toString());
        Position[] expected = new Position[]{new Position(0, 20), new Position(60, 20), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test20_1() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(60, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 30), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(60, 70);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_2() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(70, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(70, 30), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(70, 80);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_3() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(65, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(65, 10), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(65, 75);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_4() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(60, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 60), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(60, 80);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_5() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(70, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(70, 30), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(70, 80);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_6() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(50, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 30), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(60, 70);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_7() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(50, 40);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 60), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(60, 80);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test20_8() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.addMasterDocumentRange(70, 40);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(70, 40), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        String addition = this.getOriginalMasterContents().substring(100, 110);
        buffer.insert(60, addition);
        addition = this.getOriginalMasterContents().substring(70, 80);
        buffer.insert(40, addition);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_1() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(40, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(50, 10), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(20, 30);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_2() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(50, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 10), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(30, 40);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_3() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(85, 10);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(80, 5), new Position(95, 5), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(45, 55);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_4() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(40, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(20, 40);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_5() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(50, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 10), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(30, 40);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_6() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(70, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(90, 10), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(40, 50);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_7() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(70, 40);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(40, 60);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_8() {
        this.createProjectionA();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(50, 40);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 10), new Position(90, 10), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getProjectionASlaveContents());
        buffer.delete(30, 50);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_9() {
        this.createIdenticalProjection();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(50, 40);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 50), new Position(90, 90)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.delete(50, 90);
        this.assertSlaveContents(buffer.toString());
    }

    @Test
    public void test21_a() {
        this.createIdenticalProjection();
        try {
            this.fSlaveDocument.removeMasterDocumentRange(80, 100);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 80), new Position(180, 0)};
        this.assertFragmentation(expected);
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.delete(80, 180);
        this.assertSlaveContents(buffer.toString());
    }

    private void assertEquals(DocumentEvent expected, DocumentEvent received) {
        Assert.assertSame((Object)expected.getDocument(), (Object)received.getDocument());
        Assert.assertEquals((long)expected.getOffset(), (long)received.getOffset());
        Assert.assertEquals((long)expected.getLength(), (long)received.getLength());
        if (expected.getText() == null || expected.getText().length() == 0) {
            Assert.assertTrue((received.getText() == null || received.getText().length() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)expected.getText(), (Object)received.getText());
        }
    }

    private void assertSlaveEvents(DocumentEvent[] expected, DocumentEvent[] received) {
        if (expected == null) {
            Assert.assertNull((Object)received);
        }
        Assert.assertTrue((expected.length == received.length ? 1 : 0) != 0);
        int i = 0;
        while (i < received.length) {
            this.assertEquals(received[i], expected[i]);
            ++i;
        }
    }

    @Test
    public void test22() {
        final ArrayList receivedEvents = new ArrayList();
        IDocumentListener listener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                receivedEvents.add(event);
            }
        };
        this.fSlaveDocument.addDocumentListener(listener);
        this.createProjectionA();
        DocumentEvent[] actual = new DocumentEvent[receivedEvents.size()];
        receivedEvents.toArray(actual);
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        DocumentEvent[] expected = new DocumentEvent[]{new DocumentEvent((IDocument)this.fSlaveDocument, 0, 0, buffer.substring(0, 20)), new DocumentEvent((IDocument)this.fSlaveDocument, 20, 0, buffer.substring(40, 60)), new DocumentEvent((IDocument)this.fSlaveDocument, 40, 0, buffer.substring(80, 100)), new DocumentEvent((IDocument)this.fSlaveDocument, 60, 0, buffer.substring(120, 140)), new DocumentEvent((IDocument)this.fSlaveDocument, 80, 0, buffer.substring(160, 180))};
        this.assertSlaveEvents(expected, actual);
    }

    @Test
    public void test23() {
        final ArrayList receivedEvents = new ArrayList();
        IDocumentListener listener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                receivedEvents.add(event);
            }
        };
        this.createProjectionA();
        this.fSlaveDocument.addDocumentListener(listener);
        try {
            this.fSlaveDocument.removeMasterDocumentRange(40, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        DocumentEvent[] actual = new DocumentEvent[receivedEvents.size()];
        receivedEvents.toArray(actual);
        DocumentEvent[] expected = new DocumentEvent[]{new DocumentEvent((IDocument)this.fSlaveDocument, 20, 20, "")};
        this.assertSlaveEvents(expected, actual);
    }

    @Test
    public void test24_1() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 5, 10, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(5, 10), new Position(20, 20), new Position(60, 20), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_2() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 165, 10, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(60, 20), new Position(100, 20), new Position(140, 20), new Position(165, 10)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_3() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 45, 10, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(45, 10), new Position(60, 20), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_4() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 85, 10, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(60, 20), new Position(85, 10), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_5() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 50, 20, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(50, 30), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_6() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 70, 20, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(60, 30), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_7() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 50, 40, "~");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 20), new Position(50, 40), new Position(100, 20), new Position(140, 20)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test24_8() {
        this.createProjectionB();
        this.fSlaveDocument.setAutoExpandMode(true);
        try {
            DocumentEvent event = new DocumentEvent(this.fMasterDocument, 0, this.fMasterDocument.getLength(), "x" + this.getOriginalMasterContents() + "y");
            this.fSlaveDocument.adaptProjectionToMasterChange2(event);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, this.fMasterDocument.getLength())};
        this.assertFragmentation(expected);
    }

    @Test
    public void test25() {
        try {
            this.fSlaveDocument.isUpdating = true;
            this.fSlaveDocument.adaptProjectionToMasterChange2(new DocumentEvent((IDocument)this.fSlaveDocument, 0, 0, "~"));
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 0)};
        this.assertFragmentation(expected, false);
    }

    @Test
    public void test26() {
        this.createIdenticalProjection();
        ProjectionDocument slave2 = (ProjectionDocument)this.fSlaveDocumentManager.createSlaveDocument(this.fMasterDocument);
        this.createProjectionA(slave2);
        ProjectionDocument slave3 = (ProjectionDocument)this.fSlaveDocumentManager.createSlaveDocument(this.fMasterDocument);
        this.createProjectionB(slave3);
        this.assertContents(this.getOriginalMasterContents(), (IDocument)this.fSlaveDocument);
        this.assertContents(this.getProjectionASlaveContents(), (IDocument)slave2);
        this.assertContents(this.getProjectionBSlaveContents(), (IDocument)slave3);
        this.fSlaveDocumentManager.freeSlaveDocument((IDocument)slave3);
        this.fSlaveDocumentManager.freeSlaveDocument((IDocument)slave2);
    }

    @Test
    public void test27() {
        this.createProjectionA();
        Position[] expected = new Position[]{new Position(0, 20), new Position(40, 20), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        try {
            this.fSlaveDocument.addMasterDocumentRange(20, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        expected = new Position[]{new Position(0, 60), new Position(80, 20), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        try {
            this.fSlaveDocument.addMasterDocumentRange(60, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        expected = new Position[]{new Position(0, 100), new Position(120, 20), new Position(160, 20)};
        this.assertFragmentation(expected);
        try {
            this.fSlaveDocument.addMasterDocumentRange(100, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        expected = new Position[]{new Position(0, 140), new Position(160, 20)};
        this.assertFragmentation(expected);
        try {
            this.fSlaveDocument.addMasterDocumentRange(140, 20);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        expected = new Position[]{new Position(0, this.fMasterDocument.getLength())};
        this.assertFragmentation(expected);
    }

    @Test
    public void test28_1() {
        this.createProjectionB();
        try {
            this.fSlaveDocument.replace(0, this.fSlaveDocument.getLength(), "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        this.assertSlaveContents("");
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.delete(20, 160);
        this.assertMasterContents(buffer.toString());
        Position[] expected = new Position[]{new Position(20, 0)};
        this.assertFragmentation(expected);
    }

    @Test
    public void test28_2() {
        this.createProjectionB();
        try {
            this.fSlaveDocument.replace(0, this.fSlaveDocument.getLength(), "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        try {
            this.fSlaveDocument.replace(0, 0, "~~~~~");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Position[] expected = new Position[]{new Position(20, 5)};
        this.assertFragmentation(expected);
        this.assertSlaveContents("~~~~~");
        StringBuffer buffer = new StringBuffer(this.getOriginalMasterContents());
        buffer.replace(20, 160, "~~~~~");
        this.assertMasterContents(buffer.toString());
    }

    @Test
    public void _test29() {
    }

    private String print(IRegion p) {
        return "[" + p.getOffset() + "," + p.getLength() + "]";
    }

    private void assertRegions(IRegion[] expected, IRegion[] actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
            return;
        }
        if (actual == null) {
            Assert.assertNull((Object)expected);
        }
        Assert.assertTrue((String)"invalid number of regions", (expected.length == actual.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)(String.valueOf(this.print(actual[i])) + " != " + this.print(expected[i])), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    private void assertUnprojectedMasterRegions(IRegion[] expected, int offsetInMaster, int lengthInMaster) {
        this.createProjectionB();
        try {
            IRegion[] regions = this.fSlaveDocument.computeUnprojectedMasterRegions(offsetInMaster, lengthInMaster);
            this.assertRegions(expected, regions);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test29_1() {
        IRegion[] expected = new IRegion[]{new Region(45, 10)};
        this.assertUnprojectedMasterRegions(expected, 45, 10);
    }

    @Test
    public void test29_2() {
        IRegion[] expected = new IRegion[]{new Region(45, 15)};
        this.assertUnprojectedMasterRegions(expected, 45, 15);
    }

    @Test
    public void test29_3() {
        IRegion[] expected = new IRegion[]{new Region(80, 15)};
        this.assertUnprojectedMasterRegions(expected, 80, 15);
    }

    @Test
    public void test29_4() {
        IRegion[] expected = new IRegion[]{new Region(85, 10)};
        this.assertUnprojectedMasterRegions(expected, 85, 10);
    }

    @Test
    public void test29_5() {
        IRegion[] expected = new IRegion[]{new Region(50, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 20);
    }

    @Test
    public void test29_6() {
        this.assertUnprojectedMasterRegions(new IRegion[0], 60, 10);
    }

    @Test
    public void test29_7() {
        this.assertUnprojectedMasterRegions(new IRegion[0], 65, 10);
    }

    @Test
    public void test29_8() {
        this.assertUnprojectedMasterRegions(new IRegion[0], 65, 15);
    }

    @Test
    public void test29_9() {
        IRegion[] expected = new IRegion[]{new Region(80, 10)};
        this.assertUnprojectedMasterRegions(expected, 70, 20);
    }

    @Test
    public void test29_10() {
        this.assertUnprojectedMasterRegions(new IRegion[0], 60, 20);
    }

    @Test
    public void test29_11() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 40);
    }

    @Test
    public void test29_12() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 80);
    }

    @Test
    public void test29_13() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 90);
    }

    @Test
    public void test29_14() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 60);
    }

    @Test
    public void test29_15() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 110);
    }

    @Test
    public void test29_16() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 80);
    }

    @Test
    public void test29_17() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 60, 70);
    }

    @Test
    public void test29_18() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 60, 80);
    }

    @Test
    public void test29_19() {
        IRegion[] expected = new IRegion[]{new Region(80, 20)};
        this.assertUnprojectedMasterRegions(expected, 60, 50);
    }

    @Test
    public void test29_20() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 60, 100);
    }

    @Test
    public void test29_21() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 60, 70);
    }

    @Test
    public void test29_22() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 70, 60);
    }

    @Test
    public void test29_23() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 70, 70);
    }

    @Test
    public void test29_24() {
        IRegion[] expected = new IRegion[]{new Region(80, 20)};
        this.assertUnprojectedMasterRegions(expected, 70, 40);
    }

    @Test
    public void test29_25() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 70, 90);
    }

    @Test
    public void test29_26() {
        IRegion[] expected = new IRegion[]{new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 70, 60);
    }

    @Test
    public void test29_27() {
        IRegion[] expected = new IRegion[]{new Region(40, 20), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 40, 90);
    }

    @Test
    public void test29_28() {
        IRegion[] expected = new IRegion[]{new Region(40, 20), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 40, 100);
    }

    @Test
    public void test29_29() {
        IRegion[] expected = new IRegion[]{new Region(40, 20), new Region(80, 20)};
        this.assertUnprojectedMasterRegions(expected, 40, 70);
    }

    @Test
    public void test29_30() {
        IRegion[] expected = new IRegion[]{new Region(40, 20), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 40, 120);
    }

    @Test
    public void test29_31() {
        IRegion[] expected = new IRegion[]{new Region(40, 20), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 40, 90);
    }

    @Test
    public void test29_32() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 80);
    }

    @Test
    public void test29_33() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 90);
    }

    @Test
    public void test29_34() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 60);
    }

    @Test
    public void test29_35() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 20)};
        this.assertUnprojectedMasterRegions(expected, 50, 110);
    }

    @Test
    public void test29_36() {
        IRegion[] expected = new IRegion[]{new Region(50, 10), new Region(80, 20), new Region(120, 10)};
        this.assertUnprojectedMasterRegions(expected, 50, 80);
    }

    @Test
    public void test29_37() {
        this.createProjectionB();
        try {
            IRegion[] regions = this.fSlaveDocument.computeUnprojectedMasterRegions(0, 180);
            IRegion[] expected = new IRegion[]{new Region(0, 20), new Region(40, 20), new Region(80, 20), new Region(120, 20), new Region(160, 20)};
            this.assertRegions(expected, regions);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test29_38() {
        this.createProjectionA();
        try {
            IRegion[] regions = this.fSlaveDocument.computeUnprojectedMasterRegions(0, 180);
            IRegion[] expected = new IRegion[]{new Region(20, 20), new Region(60, 20), new Region(100, 20), new Region(140, 20)};
            this.assertRegions(expected, regions);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    private static class ProjectionDocument
    extends org.eclipse.jface.text.projection.ProjectionDocument {
        public boolean isUpdating = false;

        public ProjectionDocument(IDocument masterDocument) {
            super(masterDocument);
        }

        public Position[] getSegments2() {
            return super.getSegments();
        }

        public Position[] getFragments2() {
            return super.getFragments();
        }

        public boolean adaptProjectionToMasterChange2(DocumentEvent masterEvent) throws BadLocationException {
            return super.adaptProjectionToMasterChange(masterEvent);
        }

        protected boolean isUpdating() {
            return super.isUpdating() || this.isUpdating;
        }
    }

    private static class ProjectionDocumentManager
    extends org.eclipse.jface.text.projection.ProjectionDocumentManager {
        private ProjectionDocumentManager() {
        }

        protected org.eclipse.jface.text.projection.ProjectionDocument createProjectionDocument(IDocument master) {
            return new ProjectionDocument(master);
        }
    }
}

