/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.link;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InclusivePositionUpdaterTest {
    private IPositionUpdater fUpdater;
    private static final String CATEGORY = "testcategory";
    private Position fPos;
    private IDocument fDoc;

    @Before
    public void setUp() throws Exception {
        this.fUpdater = new InclusivePositionUpdater(CATEGORY);
        this.fDoc = new Document("ccccccccccccccccccccccccccccccccccccccccccccc");
        this.fPos = new Position(5, 5);
        this.fDoc.addPositionUpdater(this.fUpdater);
        this.fDoc.addPositionCategory(CATEGORY);
        this.fDoc.addPosition(CATEGORY, this.fPos);
    }

    @After
    public void tearDown() throws Exception {
        this.fDoc.removePositionUpdater(this.fUpdater);
        this.fDoc.removePositionCategory(CATEGORY);
    }

    @Test
    public void testDeleteAfter() throws BadLocationException {
        this.fDoc.replace(20, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddAfter() throws BadLocationException {
        this.fDoc.replace(20, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteBefore() throws BadLocationException {
        this.fDoc.replace(2, 2, "");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddBefore() throws BadLocationException {
        this.fDoc.replace(2, 0, "yy");
        Assert.assertEquals((long)7L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddRightBefore() throws BadLocationException {
        this.fDoc.replace(5, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)7L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteAtOffset() throws BadLocationException {
        this.fDoc.replace(5, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteRightBefore() throws BadLocationException {
        this.fDoc.replace(3, 2, "");
        Assert.assertEquals((long)3L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)7L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)5L, (long)this.fPos.length);
    }

    @Test
    public void testAddWithin() throws BadLocationException {
        this.fDoc.replace(6, 0, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)7L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteWithin() throws BadLocationException {
        this.fDoc.replace(6, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)3L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceLeftBorder() throws BadLocationException {
        this.fDoc.replace(4, 2, "yy");
        Assert.assertEquals((long)4L, (long)this.fPos.offset);
        Assert.assertEquals((long)6L, (long)this.fPos.length);
    }

    @Test
    public void testReplaceRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "yy");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)6L, (long)this.fPos.length);
    }

    @Test
    public void testDeleteOverRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "");
        Assert.assertEquals((long)5L, (long)this.fPos.offset);
        Assert.assertEquals((long)4L, (long)this.fPos.length);
    }

    @Test
    public void testDeleted() throws BadLocationException {
        this.fDoc.replace(4, 7, "");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }

    @Test
    public void testReplaced() throws BadLocationException {
        this.fDoc.replace(4, 7, "yyyyyyy");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }
}

