/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EncodingChangeTests {
    private static final String NON_DEFAULT_ENCODING = "US-ASCII".equals(ResourcesPlugin.getEncoding()) ? "ISO-8859-1" : "US-ASCII";
    private static final String ORIGINAL_CONTENT = "line1\nline2\nline3";
    private IFile fFile;
    private IEditorPart fEditor;
    private int fCount;

    public static void closeEditor(IEditorPart editor) {
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        if (editor != null && (site = editor.getSite()) != null && (page = site.getPage()) != null) {
            page.closeEditor(editor, false);
        }
    }

    private String getOriginalContent() {
        return ORIGINAL_CONTENT;
    }

    @Before
    public void setUp() throws Exception {
        IFolder folder = ResourceHelper.createFolder((String)"EncodingChangeTestProject/EncodingChangeTests/");
        this.fFile = ResourceHelper.createFile((IFolder)folder, (String)("file" + this.fCount + ".txt"), (String)this.getOriginalContent());
        this.fFile.setCharset(null, null);
        ++this.fCount;
    }

    @After
    public void tearDown() throws Exception {
        EncodingChangeTests.closeEditor(this.fEditor);
        this.fEditor = null;
        this.fFile = null;
        ResourceHelper.deleteProject((String)"EncodingChangeTestProject");
        TestUtil.cleanUp();
    }

    @Test
    public void testChangeEncodingViaFile() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            this.fFile.setCharset(NON_DEFAULT_ENCODING, null);
        }
        catch (CoreException coreException) {
            Assert.fail();
        }
        try {
            this.fEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
            if (this.fEditor instanceof TextEditor) {
                TextEditor editor = (TextEditor)this.fEditor;
                Accessor accessor = new Accessor((Object)editor, StatusTextEditor.class);
                while (editor.getSite().getShell().getDisplay().readAndDispatch()) {
                }
                ScrolledComposite composite = (ScrolledComposite)accessor.get("fStatusControl");
                Assert.assertNull((Object)composite);
                DefaultEncodingSupport encodingSupport = (DefaultEncodingSupport)editor.getAdapter(IEncodingSupport.class);
                Assert.assertEquals((Object)NON_DEFAULT_ENCODING, (Object)encodingSupport.getEncoding());
            } else {
                Assert.fail();
            }
        }
        catch (PartInitException partInitException) {
            Assert.fail();
        }
    }

    @Test
    public void testChangeEncodingViaEncodingSupport() {
        block7: {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                this.fEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
                if (this.fEditor instanceof TextEditor) {
                    TextEditor editor = (TextEditor)this.fEditor;
                    while (editor.getSite().getShell().getDisplay().readAndDispatch()) {
                    }
                    DefaultEncodingSupport encodingSupport = (DefaultEncodingSupport)editor.getAdapter(IEncodingSupport.class);
                    encodingSupport.setEncoding(NON_DEFAULT_ENCODING);
                    Accessor accessor = new Accessor((Object)editor, StatusTextEditor.class);
                    while (editor.getSite().getShell().getDisplay().readAndDispatch()) {
                    }
                    ScrolledComposite composite = (ScrolledComposite)accessor.get("fStatusControl");
                    Assert.assertNull((Object)composite);
                    String actual = null;
                    try {
                        actual = this.fFile.getCharset(false);
                    }
                    catch (CoreException coreException) {
                        Assert.fail();
                    }
                    Assert.assertEquals((Object)NON_DEFAULT_ENCODING, (Object)actual);
                    break block7;
                }
                Assert.fail();
            }
            catch (PartInitException partInitException) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testAInvalidEncoding() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            this.fFile.setCharset("nonexistent", null);
        }
        catch (CoreException coreException) {
            Assert.fail();
        }
        try {
            this.fEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
            if (this.fEditor instanceof TextEditor) {
                TextEditor editor = (TextEditor)this.fEditor;
                Accessor accessor = new Accessor((Object)editor, StatusTextEditor.class);
                while (editor.getSite().getShell().getDisplay().readAndDispatch()) {
                }
                ITextFileBuffer fileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
                DefaultEncodingSupport encodingSupport = (DefaultEncodingSupport)editor.getAdapter(IEncodingSupport.class);
                String expected = encodingSupport.getStatusMessage(fileBuffer.getStatus());
                Composite composite = (Composite)accessor.get("fStatusControl");
                ScrolledComposite scrolledComposite = (ScrolledComposite)composite.getChildren()[0];
                StyledText statusText = (StyledText)((Composite)scrolledComposite.getContent()).getChildren()[5];
                String actual = statusText.getText();
                Assert.assertEquals((Object)expected, (Object)actual);
            } else {
                Assert.fail();
            }
        }
        catch (PartInitException partInitException) {
            Assert.fail();
        }
    }
}

