/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentedModeTest {
    private static final String ORIGINAL_CONTENT = "this\nis\nthe\ncontent\nof\nthe\nfile";
    private IFile fFile;

    private String getOriginalContent() {
        return ORIGINAL_CONTENT;
    }

    @Before
    public void setUp() throws Exception {
        IFolder folder = ResourceHelper.createFolder((String)"project/folderA/folderB/");
        this.fFile = ResourceHelper.createFile((IFolder)folder, (String)"file.txt", (String)this.getOriginalContent());
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject((String)"project");
        TestUtil.cleanUp();
    }

    @Test
    public void testSegmentation() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
            try {
                if (part instanceof ITextEditor) {
                    ITextEditor editor = (ITextEditor)part;
                    editor.showHighlightRangeOnly(true);
                    editor.setHighlightRange(5, 0, true);
                    Control control = (Control)part.getAdapter(Control.class);
                    if (control instanceof StyledText) {
                        StyledText styledText = (StyledText)control;
                        int caret = styledText.getCaretOffset();
                        styledText.replaceTextRange(caret, 0, "really ");
                        StringBuffer buffer = new StringBuffer(this.getOriginalContent());
                        buffer.insert(5, "really ");
                        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                        Assert.assertEquals((Object)buffer.toString(), (Object)document.get());
                    }
                }
            }
            finally {
                page.saveEditor(part, false);
            }
        }
        catch (PartInitException partInitException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testShowNothing() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            while (Display.getDefault().readAndDispatch()) {
            }
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
            try {
                if (part instanceof ITextEditor) {
                    ITextEditor editor = (ITextEditor)part;
                    editor.showHighlightRangeOnly(true);
                    editor.setHighlightRange(0, 0, true);
                    Control control = (Control)part.getAdapter(Control.class);
                    if (control instanceof StyledText) {
                        StyledText styledText = (StyledText)control;
                        String text = styledText.getText();
                        Assert.assertEquals((Object)"", (Object)text);
                    }
                }
            }
            finally {
                page.saveEditor(part, false);
            }
        }
        catch (PartInitException partInitException) {
            Assert.assertTrue((boolean)false);
        }
    }
}

