/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.osgi.framework.Bundle;

public class ContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String AUTO_INSERT = "autoinsert";
    private static final String TEMPLATE = "template";
    private static final String PATTERN = "pattern";
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";

    public ContributionTemplateStore(IPreferenceStore store, String key) {
        super(store, key);
    }

    public ContributionTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    protected void loadContributedTemplates() throws IOException {
        IConfigurationElement[] extensions = ContributionTemplateStore.getTemplateExtensions();
        Collection<TemplatePersistenceData> contributed = this.readContributedTemplates(extensions);
        for (TemplatePersistenceData data : contributed) {
            this.internalAdd(data);
        }
    }

    private Collection<TemplatePersistenceData> readContributedTemplates(IConfigurationElement[] extensions) throws IOException {
        ArrayList<TemplatePersistenceData> templates = new ArrayList<TemplatePersistenceData>();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getName().equals(TEMPLATE)) {
                this.createTemplate(templates, extensions[i]);
            } else if (extensions[i].getName().equals(INCLUDE)) {
                this.readIncludedTemplates(templates, extensions[i]);
            }
            ++i;
        }
        return templates;
    }

    private void readIncludedTemplates(Collection<TemplatePersistenceData> templates, IConfigurationElement element) throws IOException {
        Bundle plugin;
        URL url;
        String file = element.getAttribute(FILE);
        if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)element.getContributor().getName())), (IPath)Path.fromOSString((String)file), null)) != null) {
            Throwable throwable;
            URL bundleURL;
            PropertyResourceBundle bundle = null;
            String translations = element.getAttribute(TRANSLATIONS);
            if (translations != null && (bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null)) != null) {
                throwable = null;
                Object var10_13 = null;
                try (InputStream bundleStream = bundleURL.openStream();){
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable throwable3 = null;
            throwable = null;
            try (BufferedInputStream stream = new BufferedInputStream(url.openStream());){
                TemplateReaderWriter reader = new TemplateReaderWriter();
                TemplatePersistenceData[] datas = reader.read((InputStream)stream, bundle);
                int i = 0;
                while (i < datas.length) {
                    TemplatePersistenceData data = datas[i];
                    if (data.isCustom()) {
                        if (data.getId() == null) {
                            EditorsPlugin.logErrorMessage(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_no_id, data.getTemplate().getName()));
                        } else {
                            EditorsPlugin.logErrorMessage(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_deleted, data.getTemplate().getName()));
                        }
                    } else if (this.validateTemplate(data.getTemplate())) {
                        templates.add(data);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException e) {
                EditorsPlugin.log(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_validation_failed, template.getName()), e);
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private void createTemplate(Collection<TemplatePersistenceData> map, IConfigurationElement element) {
        String pattern;
        String name;
        String id;
        String contextTypeId = element.getAttribute(CONTEXT_TYPE_ID);
        if (this.contextExists(contextTypeId) && ContributionTemplateStore.isValidTemplateId(id = element.getAttribute(ID)) && (name = element.getAttribute(NAME)) != null && (pattern = element.getChildren(PATTERN)[0].getValue()) != null) {
            String autoInsert;
            String desc = element.getAttribute(DESCRIPTION);
            if (desc == null) {
                desc = "";
            }
            boolean bAutoInsert = (autoInsert = element.getAttribute(AUTO_INSERT)) == null ? true : Boolean.valueOf(autoInsert);
            Template template = new Template(name, desc, contextTypeId, pattern, bAutoInsert);
            TemplatePersistenceData data = new TemplatePersistenceData(template, true, id);
            if (this.validateTemplate(template)) {
                map.add(data);
            }
        }
    }

    private static boolean isValidTemplateId(String id) {
        return id != null && id.trim().length() != 0;
    }

    protected void handleException(IOException x) {
        EditorsPlugin.log(x);
    }
}

