/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.editor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.examples.contributions.ContributionMessages;
import org.eclipse.ui.examples.contributions.model.PersonInput;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicEditorList
extends CompoundContributionItem {
    private static final IContributionItem[] EMPTY = new IContributionItem[0];

    protected IContributionItem[] getContributionItems() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return EMPTY;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EMPTY;
        }
        IEditorReference[] editors = page.getEditorReferences();
        ArrayList<Object> menuList = new ArrayList<Object>();
        int editorNum = 1;
        int i = 0;
        while (i < editors.length && editorNum < 10) {
            try {
                if (editors[i].getId().equals("org.eclipse.ui.examples.contributions.editor")) {
                    menuList.add(this.createItem(editorNum++, editors[i]));
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
        if (menuList.isEmpty()) {
            menuList.add((Object)new NobodyHereContribution());
        }
        return menuList.toArray(new IContributionItem[menuList.size()]);
    }

    private IContributionItem createItem(int i, IEditorReference ref) throws PartInitException {
        CommandContributionItemParameter p = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "org.eclipse.ui.examples.contributions.editor.activate", 8);
        p.parameters = new HashMap();
        PersonInput editorInput = (PersonInput)ref.getEditorInput();
        p.parameters.put("org.eclipse.ui.examples.contributions.editor.activate.index", editorInput.getIndex());
        String menuNum = Integer.toString(i);
        p.label = String.valueOf(menuNum) + " " + ref.getTitle();
        p.mnemonic = menuNum;
        return new CommandContributionItem(p);
    }

    private static class NobodyHereContribution
    extends ContributionItem {
        private NobodyHereContribution() {
        }

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0, index);
            item.setText(ContributionMessages.DynamicEditorList_label);
            item.setEnabled(false);
        }
    }
}

