/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.examples.readmetool.AdaptableList;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmeModelFactory;

public class ReadmeFilePropertyPage
extends PropertyPage {
    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Control createContents(Composite parent) {
        Label label;
        this.noDefaultAndApplyButton();
        Composite panel = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.examples.readmetool.property_page_context");
        IResource resource = (IResource)this.getElement();
        IStatus result = null;
        if (resource.getType() == 1) {
            block20: {
                label = this.createLabel(panel, MessageUtil.getString("File_name"));
                label = this.createLabel(panel, resource.getName());
                this.grabExcessSpace((Control)label);
                this.createLabel(panel, MessageUtil.getString("Path"));
                label = this.createLabel(panel, resource.getFullPath().setDevice(null).toString());
                this.grabExcessSpace((Control)label);
                this.createLabel(panel, MessageUtil.getString("Size"));
                IFile file = (IFile)resource;
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try {
                        InputStream contentStream = file.getContents();
                        try {
                            try (InputStreamReader in = new InputStreamReader(contentStream);){
                                int chunkSize = contentStream.available();
                                StringBuilder buffer = new StringBuilder(chunkSize);
                                char[] readBuffer = new char[chunkSize];
                                int n = in.read(readBuffer);
                                while (true) {
                                    if (n <= 0) {
                                        contentStream.close();
                                        label = this.createLabel(panel, Integer.toString(buffer.length()));
                                        break;
                                    }
                                    buffer.append(readBuffer);
                                    n = in.read(readBuffer);
                                }
                            }
                            if (contentStream == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (contentStream == null) throw throwable;
                            contentStream.close();
                            throw throwable;
                        }
                        contentStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (CoreException e) {
                    result = e.getStatus();
                    String message = result.getMessage();
                    label = message == null ? this.createLabel(panel, MessageUtil.getString("<Unknown>")) : this.createLabel(panel, message);
                }
                catch (IOException iOException) {
                    label = this.createLabel(panel, MessageUtil.getString("<Unknown>"));
                }
            }
            this.grabExcessSpace((Control)label);
            this.createLabel(panel, MessageUtil.getString("Number_of_sections"));
            AdaptableList sections = this.getSections((IAdaptable)resource);
            if (sections instanceof AdaptableList) {
                AdaptableList list = sections;
                label = this.createLabel(panel, String.valueOf(list.size()));
                this.grabExcessSpace((Control)label);
            }
        }
        label = this.createLabel(panel, MessageUtil.getString("Additional_information"));
        this.grabExcessSpace((Control)label);
        GridData gd = (GridData)label.getLayoutData();
        gd.horizontalSpan = 2;
        return new Canvas(panel, 0);
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private AdaptableList getSections(IAdaptable adaptable) {
        if (adaptable instanceof IFile) {
            return ReadmeModelFactory.getInstance().getSections((IFile)adaptable);
        }
        return null;
    }

    private void grabExcessSpace(Control control) {
        GridData gd = (GridData)control.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
        }
    }

    public boolean performOk() {
        return true;
    }
}

