/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.examples.undo.Box;
import org.eclipse.ui.examples.undo.BoxOperation;

public class MoveBoxOperation
extends BoxOperation {
    private Point origin;
    private Point target;

    public MoveBoxOperation(String label, IUndoContext context, Box box, Canvas canvas, Point newOrigin) {
        super(label, context, null, box, canvas);
        this.origin = new Point(box.x1, box.y1);
        this.target = new Point(newOrigin.x, newOrigin.y);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.box == null) {
            throw new ExecutionException("box ix null");
        }
        this.box.move(this.target);
        this.canvas.redraw();
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.box == null) {
            throw new ExecutionException("box ix null");
        }
        this.box.move(this.origin);
        this.canvas.redraw();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(super.getLabel());
        stringBuffer.append("[");
        stringBuffer.append("(");
        stringBuffer.append(Integer.valueOf(this.origin.x).toString());
        stringBuffer.append(", ");
        stringBuffer.append(Integer.valueOf(this.origin.y).toString());
        stringBuffer.append(')');
        stringBuffer.append(", ");
        stringBuffer.append("(");
        stringBuffer.append(Integer.valueOf(this.target.x).toString());
        stringBuffer.append(", ");
        stringBuffer.append(Integer.valueOf(this.target.y).toString());
        stringBuffer.append(')');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

