/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.undo;

import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.examples.undo.UndoExampleMessages;
import org.eclipse.ui.examples.undo.UndoPlugin;

public final class PromptingUserApprover
implements IOperationApprover {
    private IUndoContext context;

    public PromptingUserApprover(IUndoContext context) {
        this.context = context;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!operation.hasContext(this.context)) {
            return Status.OK_STATUS;
        }
        boolean prompt = UndoPlugin.getDefault().getPreferenceStore().getBoolean("prefConfirmUndo");
        if (!prompt) {
            return Status.OK_STATUS;
        }
        return this.prompt(false, operation, uiInfo);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!operation.hasContext(this.context)) {
            return Status.OK_STATUS;
        }
        boolean prompt = UndoPlugin.getDefault().getPreferenceStore().getBoolean("prefConfirmUndo");
        if (!prompt) {
            return Status.OK_STATUS;
        }
        return this.prompt(true, operation, uiInfo);
    }

    private IStatus prompt(boolean undoing, IUndoableOperation operation, IAdaptable uiInfo) {
        boolean createdShell = false;
        Shell shell = this.getShell(uiInfo);
        if (shell == null && shell == null) {
            createdShell = true;
            shell = new Shell();
        }
        String command = undoing ? UndoExampleMessages.BoxView_Undo : UndoExampleMessages.BoxView_Redo;
        String message = NLS.bind((String)UndoExampleMessages.BoxView_ConfirmUndo, (Object)command, (Object)operation.getLabel());
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)UndoExampleMessages.BoxView_Title, (String)message, (String)UndoExampleMessages.UndoPreferences_DoNotConfirm, (boolean)false, null, null);
        UndoPlugin.getDefault().getPreferenceStore().setValue("prefConfirmUndo", !dialog.getToggleState());
        if (createdShell) {
            shell.dispose();
        }
        if (dialog.getReturnCode() == 0) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    Shell getShell(IAdaptable uiInfo) {
        Shell shell;
        if (uiInfo != null && (shell = (Shell)Adapters.adapt((Object)uiInfo, Shell.class)) != null) {
            return shell;
        }
        return null;
    }
}

