/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.examples.dotproject.codemining;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;

public class ProjectReferenceCodeMining
extends LineHeaderCodeMining {
    private final String projectName;

    public ProjectReferenceCodeMining(String projectName, int beforeLineNumber, IDocument document, ICodeMiningProvider provider) throws BadLocationException {
        super(beforeLineNumber, document, provider);
        this.projectName = projectName;
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.runAsync(() -> {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            int refCount = project != null ? project.getReferencingProjects().length : 0;
            super.setLabel(String.valueOf(refCount) + (refCount > 1 ? " references" : " reference"));
        });
    }
}

