/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.Before;

public class AbstratGenericEditorTest {
    protected IProject project;
    protected IFile file;
    protected ExtensionBasedTextEditor editor;

    @Before
    public void setUp() throws Exception {
        AbstratGenericEditorTest.closeIntro();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
        this.project.create(null);
        this.project.open(null);
        this.project.setDefaultCharset("UTF-8", null);
        this.createAndOpenFile();
    }

    protected void createAndOpenFile() throws Exception {
        this.createAndOpenFile("foo.txt", "bar 'bar'");
    }

    protected void createAndOpenFile(String name, String contents) throws Exception {
        this.file = this.project.getFile(name);
        this.file.create((InputStream)new ByteArrayInputStream(contents.getBytes("UTF-8")), true, null);
        this.file.setCharset("UTF-8", null);
        this.editor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.file), "org.eclipse.ui.genericeditor.GenericEditor");
    }

    protected void cleanFileAndEditor() throws Exception {
        if (this.editor != null) {
            this.editor.close(false);
            this.editor = null;
        }
        while (Display.getDefault().readAndDispatch()) {
        }
        if (this.file != null) {
            this.file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.file = null;
        }
    }

    protected SourceViewer getSourceViewer() {
        SourceViewer sourceViewer = (SourceViewer)new Accessor((Object)this.editor, AbstractTextEditor.class).invoke("getSourceViewer", new Object[0]);
        return sourceViewer;
    }

    @After
    public void tearDown() throws Exception {
        this.cleanFileAndEditor();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    private static void closeIntro() {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
    }

    public static void waitAndDispatch(long milliseconds) {
        long timeout = milliseconds;
        long start = System.currentTimeMillis();
        while (start + timeout > System.currentTimeMillis()) {
            Display.getDefault().readAndDispatch();
        }
    }
}

