/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CompletionTest
extends AbstratGenericEditorTest {
    private Shell completionShell;

    @Test
    public void testCompletion() throws Exception {
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        this.openConentAssist();
        this.completionShell = this.findNewShell(beforeShells);
        Table completionProposalList = this.findCompletionSelectionControl((Widget)this.completionShell);
        this.checkCompletionContent(completionProposalList);
    }

    @Test
    public void testEnabledWhenCompletion() throws Exception {
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        Set beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        this.openConentAssist();
        Shell[] afterShells = (Shell[])Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toArray(Shell[]::new);
        Assert.assertEquals((String)"A new shell was found", (long)0L, (long)afterShells.length);
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        Set<Shell> beforeEnabledShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        this.openConentAssist();
        Assert.assertNotNull((Object)this.findNewShell(beforeEnabledShells));
    }

    private void openConentAssist() {
        this.editor.selectAndReveal(3, 0);
        ContentAssistAction action = (ContentAssistAction)this.editor.getAction("ContentAssistProposal");
        action.update();
        action.run();
        CompletionTest.waitAndDispatch(100L);
    }

    private void checkCompletionContent(final Table completionProposalList) {
        new DisplayHelper(){

            protected boolean condition() {
                return completionProposalList.getItemCount() == 2;
            }
        }.waitForCondition(completionProposalList.getDisplay(), 200L);
        Assert.assertEquals((long)2L, (long)completionProposalList.getItemCount());
        final TableItem computingItem = completionProposalList.getItem(0);
        Assert.assertTrue((String)"Missing computing info entry", (boolean)computingItem.getText().contains("Computing"));
        TableItem completionProposalItem = completionProposalList.getItem(1);
        ICompletionProposal selectedProposal = (ICompletionProposal)completionProposalItem.getData();
        Assert.assertTrue((String)"Incorrect proposal content", (boolean)"bars are good for a beer.".endsWith(selectedProposal.getDisplayString()));
        completionProposalList.setSelection(completionProposalItem);
        new DisplayHelper(){

            protected boolean condition() {
                return completionProposalList.getItem(0) != computingItem && completionProposalList.getItemCount() == 2;
            }
        }.waitForCondition(completionProposalList.getDisplay(), 2200L);
        completionProposalItem = completionProposalList.getItem(0);
        Assert.assertTrue((String)"Proposal content seems incorrect", (boolean)"bars are good for a beer.".endsWith(((ICompletionProposal)completionProposalItem.getData()).getDisplayString()));
        TableItem otherProposalItem = completionProposalList.getItem(1);
        Assert.assertTrue((String)"Proposal content seems incorrect", (boolean)"bars are also good for soft drink cocktails.".endsWith(((ICompletionProposal)otherProposalItem.getData()).getDisplayString()));
        Assert.assertEquals((String)"Addition of completion proposal should keep selection", (Object)selectedProposal, (Object)completionProposalList.getSelection()[0].getData());
    }

    private Shell findNewShell(Set<Shell> beforeShells) {
        Shell[] afterShells = (Shell[])Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toArray(Shell[]::new);
        Assert.assertEquals((String)"No new shell found", (long)1L, (long)afterShells.length);
        return afterShells[0];
    }

    @Test
    public void testCompletionFreeze_bug521484() throws Exception {
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        this.openConentAssist();
        this.completionShell = this.findNewShell(beforeShells);
        final Table completionProposalList = this.findCompletionSelectionControl((Widget)this.completionShell);
        new DisplayHelper(){

            protected boolean condition() {
                return completionProposalList.getItemCount() == 2;
            }
        }.waitForCondition(this.completionShell.getDisplay(), 200L);
        Assert.assertEquals((long)2L, (long)completionProposalList.getItemCount());
        TableItem computingItem = completionProposalList.getItem(0);
        Assert.assertTrue((String)"Missing computing info entry", (boolean)computingItem.getText().contains("Computing"));
        long timestamp = System.currentTimeMillis();
        this.emulatePressLeftArrowKey();
        DisplayHelper.sleep((Display)this.editor.getSite().getShell().getDisplay(), (long)200L);
        long processingDuration = System.currentTimeMillis() - timestamp;
        Assert.assertTrue((String)("UI Thread frozen for " + processingDuration + "ms"), (processingDuration < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testMoveCaretBackUsesAllProcessors_bug522255() throws Exception {
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        this.testCompletion();
        this.emulatePressLeftArrowKey();
        DisplayHelper.sleep((Display)this.editor.getSite().getShell().getDisplay(), (long)2500L);
        this.completionShell = this.findNewShell(beforeShells);
        Table completionProposalList = this.findCompletionSelectionControl((Widget)this.completionShell);
        Assert.assertEquals((String)"Missing proposals from a Processor", (long)2L, (long)completionProposalList.getItemCount());
    }

    private void emulatePressLeftArrowKey() {
        this.editor.selectAndReveal(((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset() - 1, 0);
        StyledText styledText = (StyledText)this.editor.getAdapter(Control.class);
        Event e = new Event();
        e.type = 3005;
        e.widget = styledText;
        e.keyCode = 0x1000003;
        e.display = styledText.getDisplay();
        styledText.notifyListeners(3005, e);
    }

    private Table findCompletionSelectionControl(Widget control) {
        if (control instanceof Table) {
            return (Table)control;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Table res = this.findCompletionSelectionControl((Widget)child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    @After
    public void closeShell() {
        if (this.completionShell != null && !this.completionShell.isDisposed()) {
            this.completionShell.close();
        }
    }
}

