/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ContextInfoTest
extends AbstratGenericEditorTest {
    private Shell completionShell;

    @Test
    public void testContextInfo() throws Exception {
        this.cleanFileAndEditor();
        this.createAndOpenFile("foobar.txt", "bars are good for a beer.");
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        TextOperationAction action = (TextOperationAction)this.editor.getAction("ContentAssistContextInformation");
        this.editor.selectAndReveal(4, 0);
        action.update();
        action.run();
        ContextInfoTest.waitAndDispatch(100L);
        this.completionShell = this.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)this.getInfoText(this.completionShell));
        this.editor.selectAndReveal(8, 0);
        action.update();
        action.run();
        ContextInfoTest.waitAndDispatch(100L);
        this.completionShell = this.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 1", (Object)this.getInfoText(this.completionShell));
    }

    @Test
    public void testContextInfo_hide_Bug512251() throws Exception {
        this.cleanFileAndEditor();
        this.createAndOpenFile("foobar.txt", "bars are good for a beer.");
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        TextOperationAction action = (TextOperationAction)this.editor.getAction("ContentAssistContextInformation");
        this.editor.selectAndReveal(4, 0);
        action.update();
        action.run();
        ContextInfoTest.waitAndDispatch(100L);
        this.completionShell = this.findNewShell(beforeShells);
        this.editor.selectAndReveal(8, 0);
        action.update();
        action.run();
        ContextInfoTest.waitAndDispatch(100L);
        this.completionShell = this.findNewShell(beforeShells);
        this.editor.getAction("DeleteLine").run();
        SourceViewer sourceViewer = this.getSourceViewer();
        ContentAssistant assist = (ContentAssistant)new Accessor((Object)sourceViewer, SourceViewer.class).get("fContentAssistant");
        new Accessor((Object)assist, ContentAssistant.class).invoke("hide", new Object[0]);
    }

    private Shell findNewShell(Set<Shell> beforeShells) {
        Shell[] afterShells = (Shell[])Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toArray(Shell[]::new);
        Assert.assertEquals((String)"No new shell found", (long)1L, (long)afterShells.length);
        return afterShells[0];
    }

    private String getInfoText(Shell shell) {
        Control[] children;
        Assert.assertTrue((boolean)shell.isVisible());
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text) {
                return ((Text)child).getText();
            }
            if (child instanceof StyledText) {
                return ((StyledText)child).getText();
            }
            ++n2;
        }
        return null;
    }

    @After
    public void closeShell() {
        if (this.completionShell != null && !this.completionShell.isDisposed()) {
            this.completionShell.close();
        }
    }
}

