/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.core.commands.Command;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.Assert;
import org.junit.Test;

public class EditorTest
extends AbstratGenericEditorTest {
    @Test
    public void testGenericEditorHasWordWrap() throws Exception {
        this.editor.setFocus();
        StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
        Assert.assertFalse((boolean)editorTextWidget.getWordWrap());
        Assert.assertFalse((boolean)this.editor.isWordWrapEnabled());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleWordWrap");
        Assert.assertTrue((boolean)wordWrapCommand.isDefined());
        Assert.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assert.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
        Assert.assertTrue((boolean)editorTextWidget.getWordWrap());
        Assert.assertTrue((boolean)this.editor.isWordWrapEnabled());
    }

    @Test
    public void testGenericEditorCanShowWhitespaceCharacters() throws Exception {
        this.editor.setFocus();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        Assert.assertTrue((boolean)wordWrapCommand.isDefined());
        Assert.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assert.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
    }

    @Test
    public void testGenericEditorCanUseBlockSelection() throws Exception {
        this.editor.setFocus();
        Assert.assertFalse((boolean)this.editor.isBlockSelectionModeEnabled());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleBlockSelectionMode");
        Assert.assertTrue((boolean)wordWrapCommand.isDefined());
        Assert.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assert.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
        Assert.assertTrue((boolean)this.editor.isBlockSelectionModeEnabled());
    }
}

