/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.junit.Assert;
import org.junit.Test;

public class FoldingTest
extends AbstratGenericEditorTest {
    @Override
    protected void createAndOpenFile() throws Exception {
    }

    @Test
    public void testDefaultIndentFoldingOneFold() throws Exception {
        this.createAndOpenFile("bar.xml", "<a>\n b</a>");
        this.checkFolding(FoldingTest.pos(0, 10));
    }

    @Test
    public void testDefaultIndentFoldingTwoFold() throws Exception {
        this.createAndOpenFile("bar.xml", "<a>\n <b>\n  c\n </b>\n</a>");
        this.checkFolding(FoldingTest.pos(0, 19), FoldingTest.pos(4, 9));
    }

    @Test
    public void testCustomFoldingReconciler() throws Exception {
        this.createAndOpenFile("bar.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.checkFolding(FoldingTest.pos(0, 24), FoldingTest.pos(5, 14));
    }

    @Test
    public void testEnabledWhenCustomFoldingReconciler() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.checkFolding(FoldingTest.pos(0, 24), FoldingTest.pos(5, 14));
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.checkFolding(new Position[0]);
    }

    private static Position pos(int offset, int length) {
        return new Position(offset, length);
    }

    private void checkFolding(Position ... expectedPositions) {
        if (expectedPositions == null) {
            expectedPositions = new Position[]{};
        }
        this.waitForAnnotations(expectedPositions.length);
        List<Annotation> folderAnnotations = this.getAnnotationsFromAnnotationModel();
        Assert.assertEquals((long)expectedPositions.length, (long)folderAnnotations.size());
        ArrayList<Position> actualPositions = new ArrayList<Position>(expectedPositions.length);
        int i = 0;
        while (i < expectedPositions.length) {
            Annotation folderAnnotation = folderAnnotations.get(i);
            Position actualPosition = this.getProjectionAnnotationModel().getPosition(folderAnnotation);
            actualPositions.add(actualPosition);
            ++i;
        }
        Collections.sort(actualPositions, (p1, p2) -> p1.offset - p2.offset);
        Assert.assertArrayEquals((Object[])expectedPositions, (Object[])actualPositions.toArray());
    }

    private IAnnotationModel getProjectionAnnotationModel() {
        ProjectionViewer dp = (ProjectionViewer)this.editor.getAdapter(ITextViewer.class);
        ProjectionAnnotationModel am = dp.getProjectionAnnotationModel();
        return am;
    }

    private void waitForAnnotations(final int count) {
        new DisplayHelper(){

            protected boolean condition() {
                return FoldingTest.this.getAnnotationsFromAnnotationModel().size() == count;
            }
        }.waitForCondition(Display.getDefault(), 2000L);
    }

    private List<Annotation> getAnnotationsFromAnnotationModel() {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        Iterator annotationIterator = this.getProjectionAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation ann = (Annotation)annotationIterator.next();
            if (!ann.getType().equals("org.eclipse.projection")) continue;
            annotationList.add(ann);
        }
        return annotationList;
    }
}

